/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.net;

import com.oracle.coherence.common.net.SocketProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public abstract class InetSocketProvider
implements SocketProvider {
    @Override
    public SocketAddress resolveAddress(String sAddr) {
        int nPort;
        String sHost;
        if (sAddr.startsWith("[")) {
            int ofPort = sAddr.lastIndexOf("]:");
            if (ofPort == 2) {
                throw new IllegalArgumentException("address does not contain an hostname or ip");
            }
            if (ofPort == -1) {
                throw new IllegalArgumentException("address does not contain a port");
            }
            sHost = sAddr.substring(1, ofPort - 1);
            nPort = Integer.parseInt(sAddr.substring(ofPort + 2));
        } else {
            int ofPort = sAddr.lastIndexOf(58);
            if (ofPort == 0) {
                throw new IllegalArgumentException("address does not contain an hostname of ip");
            }
            if (ofPort == -1) {
                throw new IllegalArgumentException("address does not contain a port");
            }
            sHost = sAddr.substring(0, ofPort);
            nPort = Integer.parseInt(sAddr.substring(ofPort + 1));
        }
        return new InetSocketAddress(sHost, nPort);
    }

    @Override
    public String getAddressString(Socket socket) {
        InetAddress addr = socket.getInetAddress();
        if (addr == null) {
            return null;
        }
        Object sAddr = addr.getHostAddress();
        if (((String)sAddr).contains(":")) {
            sAddr = "[" + (String)sAddr + "]";
        }
        return (String)sAddr + ":" + socket.getPort();
    }

    @Override
    public String getAddressString(ServerSocket socket) {
        Object sAddr;
        InetAddress addr = socket.getInetAddress();
        boolean fAny = addr.isAnyLocalAddress();
        if (fAny) {
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            sAddr = addr.getCanonicalHostName();
        } else {
            sAddr = addr.getHostAddress();
        }
        if (((String)sAddr).contains(":")) {
            sAddr = "[" + (String)sAddr + "]";
        }
        return (String)sAddr + ":" + socket.getLocalPort();
    }
}

