/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Predicate;
import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.net.InetAddressComparator;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.oracle.coherence.common.util.Duration;
import com.oracle.coherence.common.util.SafeClock;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public abstract class InetAddresses {
    public static final boolean PreferIPv4Stack = Boolean.getBoolean("java.net.preferIPv4Stack");
    public static final boolean PreferIPv6Addresses = Boolean.getBoolean("java.net.preferIPv6Addresses");
    public static final InetAddress ADDR_ANY = new InetSocketAddress((InetAddress)null, 0).getAddress();
    private static final AtomicLong INETADDRESS_TIMEOUT = new AtomicLong();
    private static final Set<InetAddress> LOCAL_ADDRESSES = new CopyOnWriteArraySet<InetAddress>();
    private static InetAddress s_addrLocalhost;
    private static final AtomicReference<Set<InetSocketAddress>> s_refSetNAT;
    private static final Deque<InetAddress> s_dequeAddrBindable;
    private static volatile boolean s_fDequeAddrBindablePopulated;
    protected static final long NAT_CHECK_TIMEOUT;
    protected static final long INETADDRESS_REFRESH;

    public static InetAddress getLocalAddress(Predicate<InetAddress> predicate) throws UnknownHostException {
        InetAddress addrLocal = InetAddress.getLocalHost();
        InetAddress addrBest = null;
        int nMTUBest = 0;
        int nMTULocal = 0;
        Map mapAddr = InetAddresses.getAllLocalMTUs();
        for (Map.Entry entry : mapAddr.entrySet()) {
            int nMTU;
            InetAddress addr = (InetAddress)entry.getKey();
            if (!predicate.evaluate(addr)) continue;
            Integer oMTU = (Integer)entry.getValue();
            int n = nMTU = oMTU == null ? 0 : oMTU;
            if (addr.equals(addrLocal)) {
                nMTULocal = nMTU;
            }
            if (nMTU <= nMTUBest && (nMTU != nMTUBest || InetAddresses.compare(addr, addrBest) >= 0)) continue;
            addrBest = addr;
            nMTUBest = nMTU;
        }
        if (addrBest == null) {
            throw new UnknownHostException("No local address matching " + String.valueOf(predicate));
        }
        return nMTUBest == nMTULocal && predicate.evaluate(addrLocal) ? addrLocal : addrBest;
    }

    public static InetAddress getLocalAddress(String sAddr) throws UnknownHostException {
        if (sAddr == null || sAddr.isEmpty() || sAddr.equals("localhost")) {
            return InetAddresses.getLocalHost();
        }
        if (sAddr.equals("0.0.0.0") || sAddr.equals("::0") || sAddr.equals("::")) {
            return ADDR_ANY;
        }
        if (sAddr.indexOf(47) != -1) {
            return InetAddresses.getLocalAddress(new IsSubnetMask(sAddr));
        }
        return InetAddress.getByName(sAddr);
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress addrLocal = s_addrLocalhost;
        if (addrLocal != null && InetAddresses.isLocalAddress(addrLocal)) {
            return addrLocal;
        }
        boolean fNonRoutable = false;
        HashSet<InetAddress> setExclude = null;
        while (true) {
            try {
                HashSet<InetAddress> setExcludePass;
                boolean fNonRoutablePass;
                InetAddress addr;
                while (!InetAddresses.isLocalReachableAddress(addr = InetAddresses.getLocalAddress(new Predicate<InetAddress>(){
                    final /* synthetic */ boolean val$fNonRoutablePass;
                    final /* synthetic */ Set val$setExcludePass;
                    {
                        this.val$fNonRoutablePass = bl;
                        this.val$setExcludePass = set;
                    }

                    @Override
                    public boolean evaluate(InetAddress addr) {
                        return !(!this.val$fNonRoutablePass && !IsRoutable.INSTANCE.evaluate(addr) || this.val$setExcludePass != null && this.val$setExcludePass.contains(addr));
                    }
                }), 300)) {
                    if (setExclude == null) {
                        setExclude = new HashSet<InetAddress>();
                    }
                    setExclude.add(addr);
                }
                s_addrLocalhost = addr;
                return s_addrLocalhost;
            }
            catch (UnknownHostException e) {
                if (fNonRoutable) {
                    return InetAddress.getLocalHost();
                }
                fNonRoutable = true;
                continue;
            }
            break;
        }
    }

    public static int compare(InetAddress addrA, InetAddress addrB) {
        return InetAddressComparator.INSTANCE.compare(addrA, addrB);
    }

    public static int getLocalMTU(InetAddress addr) {
        try {
            NetworkInterface ni = NetworkInterface.getByInetAddress(addr);
            if (ni == null) {
                throw new IllegalArgumentException("The specified address \"" + String.valueOf(addr) + "\" is not a local address.");
            }
            return InetAddresses.getLocalMTU(ni);
        }
        catch (SocketException socketException) {
            return 0;
        }
    }

    public static int getLocalMTU(NetworkInterface ni) {
        try {
            int nMTU = ni.getMTU();
            return nMTU < 0 ? Integer.MAX_VALUE : nMTU;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int getLocalMTU() {
        int nMtu = 65535;
        try {
            Enumeration<NetworkInterface> enmrNI = NetworkInterface.getNetworkInterfaces();
            while (enmrNI != null && enmrNI.hasMoreElements()) {
                int nMtuNic = InetAddresses.getLocalMTU(enmrNI.nextElement());
                if (nMtuNic <= 0) continue;
                nMtu = Math.min(nMtu, nMtuNic);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return nMtu;
    }

    public static InetAddress getLocalPeer(InetAddress addr) {
        for (InetAddress addrLocal : InetAddresses.getAllLocalAddresses()) {
            if (!InetAddresses.isInSubnet(addr, addrLocal, InetAddresses.getLocalSubnetLength(addrLocal))) continue;
            return addrLocal;
        }
        return null;
    }

    public static boolean isInSubnet(InetAddress addr, InetAddress addrSubnet, int cBitSubnet) {
        byte[] abPat;
        byte[] ab = addr.getAddress();
        if (ab.length != (abPat = addrSubnet.getAddress()).length) {
            return false;
        }
        for (int i = 0; i < ab.length && cBitSubnet > 0; cBitSubnet -= 8, ++i) {
            int bMask;
            if (cBitSubnet < 8) {
                bMask = 0;
                for (int j = 0; j < cBitSubnet; ++j) {
                    bMask = (byte)(bMask | 1 << cBitSubnet - j);
                }
            } else {
                bMask = -1;
            }
            if ((ab[i] & bMask) == (abPat[i] & bMask)) continue;
            return false;
        }
        return true;
    }

    public static InetAddress getLocalSubnetAddress(InetAddress addr) {
        int cBits = InetAddresses.getLocalSubnetLength(addr);
        byte[] abAddr = addr.getAddress();
        int c = abAddr.length;
        for (int i = 0; i < c; ++i) {
            if (cBits == 0) {
                abAddr[i] = 0;
                continue;
            }
            if (cBits < 8) {
                byte cZero = (byte)(8 - cBits);
                abAddr[i] = (byte)(abAddr[i] >> cZero << cZero);
                cBits = 0;
                continue;
            }
            cBits -= 8;
        }
        try {
            return InetAddress.getByAddress(abAddr);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public static short getLocalSubnetLength(InetAddress addr) {
        try {
            NetworkInterface ni = NetworkInterface.getByInetAddress(addr);
            if (ni == null) {
                throw new IllegalArgumentException("The specified address \"" + String.valueOf(addr) + "\" is not a local address.");
            }
            for (InterfaceAddress addrIf : ni.getInterfaceAddresses()) {
                if (!addrIf.getAddress().equals(addr)) continue;
                short cBits = addrIf.getNetworkPrefixLength();
                return cBits == 0 ? (short)8 : (short)cBits;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        throw new IllegalStateException();
    }

    public static List<InetAddress> getAllLocalAddresses() {
        return InetAddresses.getLocalAddresses(o -> true);
    }

    public static List<InetAddress> getLocalAddresses(Predicate<InetAddress> predicate) {
        ArrayList<InetAddress> listAddr = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> enmrNI = NetworkInterface.getNetworkInterfaces();
            while (enmrNI != null && enmrNI.hasMoreElements()) {
                NetworkInterface ni = enmrNI.nextElement();
                Enumeration<InetAddress> enmrAddr = ni.getInetAddresses();
                while (enmrAddr.hasMoreElements()) {
                    InetAddress addr = enmrAddr.nextElement();
                    if (!predicate.evaluate(addr)) continue;
                    listAddr.add(addr);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return listAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<InetAddress> getLocalBindableAddresses() {
        if (!s_fDequeAddrBindablePopulated) {
            Deque<InetAddress> deque = s_dequeAddrBindable;
            synchronized (deque) {
                if (!s_fDequeAddrBindablePopulated) {
                    s_dequeAddrBindable.addAll(InetAddresses.getLocalAddresses(new Predicate<InetAddress>(){

                        @Override
                        public boolean evaluate(InetAddress addr) {
                            boolean bl;
                            if (addr.isAnyLocalAddress()) {
                                return false;
                            }
                            if (addr instanceof Inet4Address) {
                                return true;
                            }
                            ServerSocket socket = new ServerSocket(0, 0, addr);
                            try {
                                bl = true;
                            }
                            catch (Throwable throwable) {
                                try {
                                    try {
                                        socket.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                catch (IOException iOException) {
                                    return false;
                                }
                            }
                            socket.close();
                            return bl;
                        }
                    }));
                    s_fDequeAddrBindablePopulated = true;
                }
            }
        }
        return Collections.unmodifiableCollection(s_dequeAddrBindable);
    }

    public static Map getAllLocalMTUs() {
        HashMap<InetAddress, Integer> mapAddr = new HashMap<InetAddress, Integer>();
        try {
            Enumeration<NetworkInterface> enmrNI = NetworkInterface.getNetworkInterfaces();
            while (enmrNI != null && enmrNI.hasMoreElements()) {
                NetworkInterface ni = enmrNI.nextElement();
                int nMTU = InetAddresses.getLocalMTU(ni);
                Integer oMTU = nMTU == 0 ? null : Integer.valueOf(nMTU);
                Enumeration<InetAddress> enmrAddr = ni.getInetAddresses();
                while (enmrAddr.hasMoreElements()) {
                    mapAddr.put(enmrAddr.nextElement(), oMTU);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return mapAddr;
    }

    private static String unbracketAddressString(String sAddr) {
        if (sAddr.charAt(0) == '[') {
            int ofBracket = sAddr.indexOf(93, 1);
            if (ofBracket < 0) {
                throw new IllegalArgumentException("invalid IPv6 address");
            }
            sAddr = sAddr.substring(1, ofBracket);
        }
        return sAddr;
    }

    public static boolean isHostName(String sHost) {
        return sHost.length() != 0 && sHost.indexOf(":") < 0 && !sHost.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$");
    }

    public static boolean isAnyLocalAddress(String sAddr) {
        return sAddr != null && (sAddr.equals("::0") || sAddr.equals("0.0.0.0"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEphemeral(int nPort) {
        int nHigh;
        int nLow;
        String sOS;
        if (nPort < 0 || nPort > 65535) {
            nPort = MultiplexedSocketProvider.getBasePort(nPort);
        }
        if ("linux".equals(sOS = System.getProperty("os.name").toLowerCase().trim())) {
            StringTokenizer sTok;
            BufferedReader in2;
            try {
                in2 = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/sys/net/ipv4/ip_local_reserved_ports")));
                try {
                    sTok = new StringTokenizer(in2.readLine(), ",");
                    while (sTok.hasMoreElements()) {
                        String sReserved = sTok.nextToken().trim();
                        int ofRange = sReserved.indexOf(45);
                        if (ofRange == -1) {
                            if (Integer.parseInt(sReserved) != nPort) continue;
                            boolean bl = false;
                            return bl;
                        }
                        int nLowRes = Integer.parseInt(sReserved.substring(0, ofRange).trim());
                        int nHighRes = Integer.parseInt(sReserved.substring(ofRange + 1).trim());
                        if (nPort < nLowRes || nPort > nHighRes) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    in2.close();
                }
            }
            catch (Throwable in2) {
                // empty catch block
            }
            try {
                in2 = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/sys/net/ipv4/ip_local_port_range")));
                try {
                    sTok = new StringTokenizer(in2.readLine());
                    nLow = Integer.parseInt(sTok.nextToken().trim());
                    nHigh = Integer.parseInt(sTok.nextToken().trim());
                }
                finally {
                    in2.close();
                }
            }
            catch (Throwable t) {
                nLow = 32768;
                nHigh = 61000;
            }
        } else {
            nLow = 49152;
            nHigh = 65535;
        }
        if (nPort < nLow) return false;
        if (nPort > nHigh) return false;
        return true;
    }

    public static InetSocketAddress getSocketAddress(String sAddr, int nPort) throws UnknownHostException {
        int ofPort;
        if (sAddr == null) {
            throw new IllegalArgumentException("address cannot be null");
        }
        String sHost = InetAddresses.unbracketAddressString(sAddr);
        if (sAddr.equals(sHost)) {
            ofPort = sAddr.lastIndexOf(58);
            int ofEnd = ofPort != -1 ? ofPort : sAddr.length();
            sHost = sAddr.substring(0, ofEnd);
        } else {
            ofPort = sAddr.indexOf(58, sAddr.indexOf(93));
        }
        if (ofPort != -1) {
            nPort = Integer.parseInt(sAddr.substring(ofPort + 1));
        }
        if (sHost.equals("*")) {
            return new InetSocketAddress(nPort);
        }
        if (sHost.equals("localhost") || sAddr.length() == 0) {
            return new InetSocketAddress(InetAddresses.getLocalHost(), nPort);
        }
        InetSocketAddress addr = new InetSocketAddress(sHost, nPort);
        if (addr.getAddress() == null) {
            throw new UnknownHostException("could not resolve address \"" + sAddr + "\"");
        }
        return addr;
    }

    public static InetAddress getAddress(SocketAddress sockAddr) {
        if (sockAddr instanceof InetSocketAddress) {
            return ((InetSocketAddress)sockAddr).getAddress();
        }
        if (sockAddr instanceof InetSocketAddress32) {
            return ((InetSocketAddress32)sockAddr).getAddress();
        }
        throw new IllegalArgumentException("Cannot obtain an address from class " + String.valueOf(sockAddr.getClass()));
    }

    public static int getPort(SocketAddress sockAddr) {
        if (sockAddr instanceof InetSocketAddress) {
            return ((InetSocketAddress)sockAddr).getPort();
        }
        if (sockAddr instanceof InetSocketAddress32) {
            return ((InetSocketAddress32)sockAddr).getPort();
        }
        throw new IllegalArgumentException("Cannot obtain a port from class " + String.valueOf(sockAddr.getClass()));
    }

    public static SocketAddress setAddress(SocketAddress sockAddr, InetAddress addr) {
        if (sockAddr instanceof InetSocketAddress) {
            return new InetSocketAddress(addr, ((InetSocketAddress)sockAddr).getPort());
        }
        if (sockAddr instanceof InetSocketAddress32) {
            return new InetSocketAddress32(addr, ((InetSocketAddress32)sockAddr).getPort());
        }
        throw new IllegalArgumentException("Cannot set address for class " + String.valueOf(sockAddr.getClass()));
    }

    public static SocketAddress setPort(SocketAddress sockAddr, int nPort) {
        if (sockAddr instanceof InetSocketAddress) {
            return new InetSocketAddress(((InetSocketAddress)sockAddr).getAddress(), nPort);
        }
        if (sockAddr instanceof InetSocketAddress32) {
            return new InetSocketAddress32(((InetSocketAddress32)sockAddr).getAddress(), nPort);
        }
        throw new IllegalArgumentException("Cannot set port for class " + String.valueOf(sockAddr.getClass()));
    }

    public static boolean isLocalAddress(InetAddress addr) {
        try {
            return addr.isLoopbackAddress() || addr.isAnyLocalAddress() || InetAddresses.checkLocalAddress(addr);
        }
        catch (SocketException e) {
            return false;
        }
    }

    public static boolean isLocalBindableAddress(InetAddress addr) {
        boolean bl;
        ServerSocket socket = new ServerSocket(0, 0, addr);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocalReachableAddress(InetAddress addr, int cMillis) {
        try (ServerSocket socket = new ServerSocket(0, 0, addr);){
            boolean bl;
            try (Socket client = new Socket();){
                Blocking.connect(client, socket.getLocalSocketAddress(), cMillis);
                bl = true;
            }
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean hasNatLocalAddress() {
        return s_refSetNAT.get() != null;
    }

    public static boolean isNatLocalAddress(SocketAddress addr) {
        return InetAddresses.isNatLocalAddress(InetAddresses.getAddress(addr), InetAddresses.getPort(addr));
    }

    public static boolean isNatLocalAddress(InetAddress addr, int nPort) {
        return InetAddresses.isNatLocalAddress(addr, nPort, nPort);
    }

    public static boolean isNatLocalAddress(InetAddress addr, int nPortMin, int nPortMax) {
        return InetAddresses.isNatLocalAddress(addr, nPortMin, nPortMax, (int)NAT_CHECK_TIMEOUT);
    }

    /*
     * Exception decompiling
     */
    public static boolean isNatLocalAddress(InetAddress addr, int nPortMin, int nPortMax, int cMillis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK], 2[TRYBLOCK]], but top level block is 47[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InetAddress getByAddress(byte[] abAddr) throws UnknownHostException {
        if (abAddr == null) {
            return null;
        }
        return InetAddress.getByAddress(abAddr);
    }

    public static long toLong(InetAddress addr) {
        byte[] ab = addr.getAddress();
        int of = ab.length == 4 ? 0 : 12;
        return ((long)ab[of + 0] & 0xFFL) << 24 | ((long)ab[of + 1] & 0xFFL) << 16 | ((long)ab[of + 2] & 0xFFL) << 8 | (long)ab[of + 3] & 0xFFL;
    }

    public static Collection<InetAddress> getRoutes(Iterable<? extends InetAddress> collSource, Iterable<? extends InetAddress> collDest) {
        ArrayList<InetAddress> listAddr = new ArrayList<InetAddress>();
        int cbBest = 0;
        for (InetAddress inetAddress : collDest) {
            byte[] abDest = inetAddress.getAddress();
            for (InetAddress inetAddress2 : collSource) {
                int cbEqual;
                int ofDest;
                byte[] abSrc = inetAddress2.getAddress();
                int ofSrc = 0;
                if (abDest.length != abSrc.length) {
                    for (ofDest = 0; ofDest < abDest.length && abDest[ofDest] == 0; ++ofDest) {
                    }
                    while (ofSrc < abSrc.length && abSrc[ofSrc] == 0) {
                        ++ofSrc;
                    }
                    if (abDest.length - ofDest != abSrc.length - ofSrc) continue;
                }
                int cb = abSrc.length - ofSrc;
                for (cbEqual = 0; cbEqual < cb && abSrc[ofSrc + cbEqual] == abDest[ofDest + cbEqual]; ++cbEqual) {
                }
                if (cbEqual < cbBest) continue;
                if (cbEqual > cbBest) {
                    cbBest = cbEqual;
                    listAddr.clear();
                }
                listAddr.add(inetAddress2);
            }
        }
        return listAddr;
    }

    protected static void setSubnetMask(byte[] ab, int cBits) {
        int i;
        if (ab.length * 8 < cBits) {
            throw new IllegalArgumentException("subnet mask of " + cBits + " exceeds address length of " + ab.length * 8);
        }
        int cBytes = cBits / 8;
        for (i = 0; i < cBytes; ++i) {
            ab[i] = -1;
        }
        int c = cBits % 8;
        for (i = 0; i < c; ++i) {
            int n = cBytes;
            ab[n] = (byte)(ab[n] | 1 << 7 - i);
        }
    }

    protected static byte[] generateMagic() {
        int nRnd = ThreadLocalRandom.current().nextInt();
        return new byte[]{82, 65, 74, 65, (byte)(nRnd >> 24 & 0xFF), (byte)(nRnd >> 16 & 0xFF), (byte)(nRnd >> 8 & 0xFF), (byte)(nRnd & 0xFF)};
    }

    protected static boolean checkLocalAddress(InetAddress addr) throws SocketException {
        long cTimeout = INETADDRESS_TIMEOUT.get();
        if (SafeClock.INSTANCE.getSafeTimeMillis() > cTimeout) {
            try {
                HashSet<InetAddress> setAddresses = new HashSet<InetAddress>();
                Enumeration<NetworkInterface> enmr = NetworkInterface.getNetworkInterfaces();
                while (enmr.hasMoreElements()) {
                    NetworkInterface iface = enmr.nextElement();
                    Enumeration<InetAddress> enmrAddr = iface.getInetAddresses();
                    while (enmrAddr.hasMoreElements()) {
                        setAddresses.add(enmrAddr.nextElement());
                    }
                }
                if (INETADDRESS_TIMEOUT.compareAndSet(cTimeout, SafeClock.INSTANCE.getSafeTimeMillis() + INETADDRESS_REFRESH)) {
                    LOCAL_ADDRESSES.clear();
                    LOCAL_ADDRESSES.addAll(setAddresses);
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return LOCAL_ADDRESSES.contains(addr) || NetworkInterface.getByInetAddress(addr) != null;
    }

    static {
        s_refSetNAT = new AtomicReference();
        s_dequeAddrBindable = new ConcurrentLinkedDeque<InetAddress>();
        NAT_CHECK_TIMEOUT = new Duration(System.getProperty(InetAddresses.class.getName() + ".natCheckTimeout", "10s")).as(Duration.Magnitude.MILLI);
        INETADDRESS_REFRESH = new Duration(System.getProperty(InetAddresses.class.getName() + ".localAddressCacheTimeout", "1h")).as(Duration.Magnitude.MILLI);
    }

    public static class IsSubnetMask
    implements Predicate<InetAddress> {
        protected String m_sDescription;
        protected byte[] m_abPattern;
        protected byte[] m_abMask;

        public IsSubnetMask(InetAddress addrPattern, InetAddress addrMask) {
            this.m_abPattern = addrPattern.getAddress();
            this.m_abMask = addrMask.getAddress();
            this.m_sDescription = String.valueOf(addrPattern) + "/" + String.valueOf(addrMask);
            if (this.m_abPattern.length != this.m_abMask.length) {
                throw new IllegalArgumentException("pattern and mask must be of the same byte length");
            }
        }

        public IsSubnetMask(InetAddress addrPattern, int cMaskBits) {
            this.m_abPattern = addrPattern.getAddress();
            this.m_abMask = new byte[this.m_abPattern.length];
            this.m_sDescription = String.valueOf(addrPattern) + "/" + cMaskBits;
            InetAddresses.setSubnetMask(this.m_abMask, cMaskBits);
        }

        public IsSubnetMask(String sAddr) {
            try {
                this.m_sDescription = sAddr;
                int ofSubnetMask = sAddr.indexOf(47);
                InetAddress addr = ofSubnetMask == -1 ? InetAddress.getByName(sAddr) : InetAddress.getByName(sAddr.substring(0, ofSubnetMask));
                this.m_abPattern = addr.getAddress();
                byte[] abPattern = this.m_abPattern;
                if (ofSubnetMask == -1 || sAddr.indexOf(46, ofSubnetMask) == -1) {
                    this.m_abMask = new byte[abPattern.length];
                    byte[] abMask = this.m_abMask;
                    InetAddresses.setSubnetMask(abMask, ofSubnetMask == -1 ? abPattern.length * 8 : Integer.valueOf(sAddr.substring(ofSubnetMask + 1)));
                } else {
                    this.m_abMask = InetAddress.getByName(sAddr.substring(ofSubnetMask + 1)).getAddress();
                }
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("dns names are not supported");
            }
        }

        @Override
        public boolean evaluate(InetAddress addr) {
            byte[] ab = addr.getAddress();
            byte[] abPat = this.m_abPattern;
            byte[] abMask = this.m_abMask;
            if (ab.length != abPat.length) {
                return false;
            }
            for (int i = ab.length - 1; i >= 0; --i) {
                byte bMask = abMask[i];
                if ((ab[i] & bMask) == (abPat[i] & bMask)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "IsSubnetMask(" + this.m_sDescription + ")";
        }
    }

    public static class IsRoutable
    implements Predicate<InetAddress> {
        public static final IsRoutable INSTANCE = new IsRoutable();

        @Override
        public boolean evaluate(InetAddress addr) {
            return !addr.isLoopbackAddress() && !addr.isAnyLocalAddress() && !addr.isLinkLocalAddress();
        }

        public String toString() {
            return "is routable";
        }
    }
}

