/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.io;

import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.io.Buffers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class MultiBufferSequence
extends AtomicInteger
implements BufferSequence {
    protected final BufferManager f_manager;
    protected ByteBuffer[] m_aBuffer;
    protected final int f_ofBuffer;
    protected final int f_cBuffer;
    protected final long f_cbBuffer;
    protected final int[] f_aPosLimit;
    protected IOException m_stackDispose;
    private static final boolean TRACK_DISPOSE = Boolean.getBoolean(BufferSequence.class.getName() + ".trackDispose");

    public MultiBufferSequence(BufferManager manager, ByteBuffer[] aBuffer) {
        this(manager, aBuffer, 0, aBuffer.length);
    }

    public MultiBufferSequence(BufferManager manager, ByteBuffer[] aBuffer, int of, int cBuffer) {
        this(manager, aBuffer, of, cBuffer, MultiBufferSequence.computeLength(aBuffer, of, cBuffer));
    }

    public MultiBufferSequence(BufferManager manager, ByteBuffer[] aBuffer, int of, int cBuffer, long cbBuffer) {
        if (aBuffer == null) {
            throw new IllegalArgumentException("buffer array cannot be null");
        }
        int[] aPosLimit = new int[cBuffer * 2];
        for (int i = 0; i < cBuffer; ++i) {
            ByteBuffer buff = aBuffer[of + i];
            aPosLimit[i] = buff.position();
            aPosLimit[cBuffer + i] = buff.limit();
        }
        this.f_manager = manager;
        this.m_aBuffer = aBuffer;
        this.f_ofBuffer = of;
        this.f_cBuffer = cBuffer;
        this.f_cbBuffer = cbBuffer;
        this.f_aPosLimit = aPosLimit;
    }

    @Override
    public long getLength() {
        return this.f_cbBuffer;
    }

    @Override
    public int getBufferCount() {
        return this.f_cBuffer;
    }

    @Override
    public ByteBuffer getBuffer(int iBuffer) {
        if (iBuffer < 0 || iBuffer >= this.f_cBuffer) {
            throw new IndexOutOfBoundsException();
        }
        return this.getSafeBuffer(iBuffer);
    }

    @Override
    public ByteBuffer getUnsafeBuffer(int iBuffer) {
        if (iBuffer < 0 || iBuffer >= this.f_cBuffer) {
            throw new IndexOutOfBoundsException();
        }
        return this.m_aBuffer[this.f_ofBuffer + iBuffer];
    }

    @Override
    public int getBufferPosition(int iBuffer) {
        if (iBuffer < 0 || iBuffer >= this.f_cBuffer) {
            throw new IndexOutOfBoundsException();
        }
        return this.f_aPosLimit[this.f_ofBuffer + iBuffer];
    }

    @Override
    public int getBufferLimit(int iBuffer) {
        if (iBuffer < 0 || iBuffer >= this.f_cBuffer) {
            throw new IndexOutOfBoundsException();
        }
        return this.f_aPosLimit[this.f_ofBuffer + this.f_cBuffer + iBuffer];
    }

    @Override
    public int getBufferLength(int iBuffer) {
        return this.f_aPosLimit[this.f_ofBuffer + this.f_cBuffer + iBuffer] - this.f_aPosLimit[this.f_ofBuffer + iBuffer];
    }

    @Override
    public ByteBuffer[] getBuffers() {
        int cBuffer = this.f_cBuffer;
        ByteBuffer[] aBufferNew = new ByteBuffer[cBuffer];
        for (int i = 0; i < cBuffer; ++i) {
            aBufferNew[i] = this.getSafeBuffer(i);
        }
        return aBufferNew;
    }

    @Override
    public void getBuffers(int iBuffer, int cBuffers, ByteBuffer[] abufDest, int iDest) {
        int cBufferSrc = this.f_cBuffer;
        if (iBuffer < 0 || iBuffer + cBuffers > cBufferSrc) {
            throw new IndexOutOfBoundsException();
        }
        int eDest = iDest + cBuffers;
        while (iDest < eDest) {
            abufDest[iDest] = this.getSafeBuffer(iBuffer);
            ++iDest;
            ++iBuffer;
        }
    }

    @Override
    public void dispose() {
        ByteBuffer[] aBuffer = this.m_aBuffer;
        if (aBuffer == null) {
            throw new IllegalStateException("already disposed (for location use -D" + BufferSequence.class.getName() + ".trackDispose=true)", this.m_stackDispose);
        }
        if (TRACK_DISPOSE) {
            this.m_stackDispose = new IOException("disposed at");
        }
        this.m_aBuffer = null;
        BufferManager manager = this.f_manager;
        if (manager != null) {
            int of;
            int eof = of + this.f_cBuffer;
            for (of = this.f_ofBuffer; of < eof; ++of) {
                manager.release(aBuffer[of]);
            }
        }
    }

    @Override
    public String toString() {
        return Buffers.toString(this);
    }

    public boolean isDisposed() {
        return this.m_aBuffer == null;
    }

    protected static long computeLength(ByteBuffer[] aBuffer, int of, int cBuffer) {
        long cb = 0L;
        int e = of + cBuffer;
        while (of < e) {
            cb += (long)aBuffer[of].remaining();
            ++of;
        }
        return cb;
    }

    private final ByteBuffer getSafeBuffer(int i) {
        ByteBuffer[] aBuffer = this.m_aBuffer;
        if (aBuffer == null) {
            throw new IllegalStateException("disposed (for location use -D" + BufferSequence.class.getName() + ".trackDispose=true)", this.m_stackDispose);
        }
        ByteBuffer buff = aBuffer[this.f_ofBuffer + i];
        if (this.compareAndSet(i, i + 1)) {
            return buff;
        }
        buff = buff.duplicate();
        buff.limit(this.f_aPosLimit[this.f_cBuffer + i]).position(this.f_aPosLimit[i]);
        return buff;
    }
}

