/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;

public class Files {
    protected static final boolean ASSUME_LOCAL = Boolean.getBoolean(Files.class.getCanonicalName() + ".assumeLocal");

    public static boolean isLocal(File file) {
        return Files.isLocal(file, ASSUME_LOCAL);
    }

    public static boolean isLocal(File file, boolean fAssumeLocal) {
        try {
            String sMountTable;
            String sOS;
            file.exists();
            Object sDir = file.isDirectory() ? file.getCanonicalPath() : file.getCanonicalFile().getParent();
            switch (sOS = new StringTokenizer(System.getProperty("os.name").toLowerCase().trim()).nextToken()) {
                case "windows": {
                    String sDrive;
                    int ofDrive;
                    String sSystemDrive = System.getenv("SystemDrive");
                    if (sSystemDrive != null && (ofDrive = ((String)sDir).indexOf(":")) != -1 && (sDrive = ((String)sDir).substring(0, ofDrive + 1)).equalsIgnoreCase(sSystemDrive)) {
                        return true;
                    }
                    return fAssumeLocal;
                }
                case "mac": {
                    return !((String)sDir).startsWith("/Volumes/") || fAssumeLocal;
                }
                case "linux": {
                    sMountTable = "/proc/mounts";
                    break;
                }
                default: {
                    sMountTable = "/etc/mnttab";
                }
            }
            Object sPointBest = "";
            boolean fLocal = fAssumeLocal;
            try (BufferedReader in = new BufferedReader(new FileReader(new File(sMountTable)));){
                String sLine;
                if (!((String)sDir).endsWith("/")) {
                    sDir = (String)sDir + "/";
                }
                while ((sLine = in.readLine()) != null) {
                    if ((sLine = sLine.trim()).isEmpty() || sLine.startsWith("#")) continue;
                    StringTokenizer sMount = new StringTokenizer(sLine);
                    String sDevice = sMount.nextToken();
                    Object sPoint = sMount.nextToken();
                    String sFs = sMount.nextToken();
                    if (!((String)sPoint).endsWith("/")) {
                        sPoint = (String)sPoint + "/";
                    }
                    if (!((String)sDir).startsWith((String)sPoint) || ((String)sPoint).length() < ((String)sPointBest).length()) continue;
                    sPointBest = sPoint;
                    boolean bl = fLocal = sDevice.equals("rootfs") || sDevice.startsWith("/dev/") || sDevice.startsWith("rpool/");
                    if (!sFs.equals("lofs")) continue;
                    fLocal = Files.isLocal(new File(sDevice), fAssumeLocal);
                }
            }
            return fLocal;
        }
        catch (Throwable e) {
            return fAssumeLocal;
        }
    }
}

