/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.io;

import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.io.Buffers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class DoubleBufferSequence
extends AtomicInteger
implements BufferSequence {
    protected final BufferManager f_manager;
    protected ByteBuffer m_bufferA;
    protected ByteBuffer m_bufferB;
    protected final int f_nPositionA;
    protected final int f_nLimitA;
    protected final int f_nPositionB;
    protected final int f_nLimitB;
    protected IOException m_stackDispose;
    private static final boolean TRACK_DISPOSE = Boolean.getBoolean(BufferSequence.class.getName() + ".trackDispose");

    public DoubleBufferSequence(BufferManager manager, ByteBuffer bufferA, ByteBuffer bufferB) {
        if (bufferA == null || bufferB == null) {
            throw new IllegalArgumentException("buffers cannot be null");
        }
        this.f_manager = manager;
        this.m_bufferA = bufferA;
        this.m_bufferB = bufferB;
        this.f_nPositionA = bufferA.position();
        this.f_nLimitA = bufferA.limit();
        this.f_nPositionB = bufferB.position();
        this.f_nLimitB = bufferB.limit();
    }

    @Override
    public long getLength() {
        return this.f_nLimitA - this.f_nPositionA + (this.f_nLimitB - this.f_nPositionB);
    }

    @Override
    public int getBufferCount() {
        return 2;
    }

    @Override
    public ByteBuffer getBuffer(int iBuffer) {
        switch (iBuffer) {
            case 0: {
                return this.getFirstSafeBuffer();
            }
            case 1: {
                return this.getSecondSafeBuffer();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuffer getUnsafeBuffer(int iBuffer) {
        switch (iBuffer) {
            case 0: {
                return this.m_bufferA;
            }
            case 1: {
                return this.m_bufferB;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getBufferPosition(int iBuffer) {
        switch (iBuffer) {
            case 0: {
                return this.f_nPositionA;
            }
            case 1: {
                return this.f_nPositionB;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getBufferLimit(int iBuffer) {
        switch (iBuffer) {
            case 0: {
                return this.f_nLimitA;
            }
            case 1: {
                return this.f_nLimitB;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getBufferLength(int iBuffer) {
        switch (iBuffer) {
            case 0: {
                return this.f_nLimitA - this.f_nPositionA;
            }
            case 1: {
                return this.f_nLimitB - this.f_nPositionB;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ByteBuffer[] getBuffers() {
        return new ByteBuffer[]{this.getFirstSafeBuffer(), this.getSecondSafeBuffer()};
    }

    @Override
    public void getBuffers(int iBuffer, int cBuffers, ByteBuffer[] abufDest, int iDest) {
        if (cBuffers-- > 0) {
            abufDest[iDest++] = this.getBuffer(iBuffer++);
            if (cBuffers > 0) {
                abufDest[iDest] = this.getBuffer(iBuffer);
            }
        }
    }

    @Override
    public void dispose() {
        ByteBuffer buffA = this.m_bufferA;
        ByteBuffer buffB = this.m_bufferB;
        if (buffA == null) {
            throw new IllegalStateException("already disposed (for location use -D" + BufferSequence.class.getName() + ".trackDispose=true)", this.m_stackDispose);
        }
        if (TRACK_DISPOSE) {
            this.m_stackDispose = new IOException("disposed at");
        }
        this.m_bufferA = null;
        this.m_bufferB = null;
        BufferManager manager = this.f_manager;
        if (manager != null) {
            manager.release(buffA);
            manager.release(buffB);
        }
    }

    @Override
    public String toString() {
        return Buffers.toString(this);
    }

    public boolean isDisposed() {
        return this.m_bufferA == null;
    }

    protected final ByteBuffer getFirstSafeBuffer() {
        ByteBuffer buff = this.m_bufferA;
        int n = this.get();
        if (buff == null) {
            throw new IllegalStateException("disposed (for location use -D" + BufferSequence.class.getName() + ".trackDispose=true)", this.m_stackDispose);
        }
        if ((n & 1) == 0 && this.compareAndSet(n, n | 1)) {
            return buff;
        }
        buff = buff.duplicate();
        buff.limit(this.f_nLimitA).position(this.f_nPositionA);
        return buff;
    }

    protected final ByteBuffer getSecondSafeBuffer() {
        ByteBuffer buff = this.m_bufferB;
        int n = this.get();
        if (buff == null) {
            throw new IllegalStateException("disposed (for location use -D" + BufferSequence.class.getName() + ".trackDispose=true)", this.m_stackDispose);
        }
        if ((n & 0x10) == 0 && this.compareAndSet(n, n | 0x10)) {
            return buff;
        }
        buff = buff.duplicate();
        buff.limit(this.f_nLimitB).position(this.f_nPositionB);
        return buff;
    }
}

