/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.io;

import com.oracle.coherence.common.base.Collector;
import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.io.BufferSequenceInputStream;
import com.oracle.coherence.common.io.CompositeBufferSequence;
import com.oracle.coherence.common.io.DoubleBufferSequence;
import com.oracle.coherence.common.io.MultiBufferSequence;
import com.oracle.coherence.common.io.SingleBufferSequence;
import com.oracle.coherence.common.io.TripleBufferSequence;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;

public class Buffers {
    public static ByteBuffer getEmptyBuffer() {
        return EmptyBuffer.INSTANCE;
    }

    public static ByteBuffer getEmptyDirectBuffer() {
        return EmptyDirectBuffer.INSTANCE;
    }

    public static ByteBuffer[] getEmptyBufferArray() {
        return EmptyBufferArray.INSTANCE;
    }

    public static BufferSequence getEmptyBufferSequence() {
        return EmptySequenceHolder.INSTANCE;
    }

    public static BufferSequence allocateDirect(BufferManager mgr, long cb) {
        if (cb == 0L) {
            return new SingleBufferSequence(null, Buffers.getEmptyDirectBuffer());
        }
        int cbMaxAlligned = 0x7FFFFFF8;
        int cbAttempt = cb > 0x7FFFFFF8L ? 0x7FFFFFF8 : (int)cb;
        LinkedList<ByteBuffer> listBuffers = null;
        ByteBuffer buffer = null;
        long ofLocal = 0L;
        while (ofLocal < cb) {
            try {
                if (mgr == null) {
                    buffer = ByteBuffer.allocateDirect(cbAttempt);
                } else {
                    buffer = mgr.acquirePref(cbAttempt);
                    cbAttempt = buffer.remaining();
                    if (!buffer.isDirect()) {
                        mgr.release(buffer);
                        if (listBuffers != null) {
                            for (ByteBuffer bufRelease : listBuffers) {
                                mgr.release(bufRelease);
                            }
                        }
                        throw new IllegalArgumentException("BufferManager must supply direct ByteBuffers");
                    }
                    if (ofLocal + (long)cbAttempt < cb) {
                        if (cbAttempt < buffer.limit()) {
                            buffer.limit(buffer.limit());
                            cbAttempt = buffer.remaining();
                        }
                        if (cbAttempt % 8 != 0) {
                            buffer.limit(buffer.limit() - cbAttempt % 8);
                            cbAttempt = buffer.remaining();
                        }
                    }
                }
                cbAttempt = (int)Math.min((long)Math.max(0x100000, cbAttempt), cb - (ofLocal += (long)cbAttempt));
                if (listBuffers == null) {
                    if (ofLocal >= cb) continue;
                    listBuffers = new LinkedList<ByteBuffer>();
                    listBuffers.add(buffer);
                    continue;
                }
                listBuffers.add(buffer);
            }
            catch (OutOfMemoryError e) {
                if (cbAttempt <= 1024) {
                    if (listBuffers != null) {
                        for (ByteBuffer bufRelease : listBuffers) {
                            mgr.release(bufRelease);
                        }
                    }
                    throw e;
                }
                if ((cbAttempt /= 2) % 8 == 0) continue;
                cbAttempt += 8 - cbAttempt % 8;
            }
        }
        if (mgr != null) {
            buffer = mgr.truncate(buffer);
            if (listBuffers != null) {
                listBuffers.set(listBuffers.size() - 1, buffer);
            }
        }
        return listBuffers == null ? new SingleBufferSequence(mgr, buffer) : new MultiBufferSequence(mgr, listBuffers.toArray(new ByteBuffer[listBuffers.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int allocate(final BufferManager mgr, Collector<BufferSequence> collBufSeq, int cSeq, int cb, int cBufLimit) {
        Disposable bufferSeq;
        int cSeqAlloc;
        block17: {
            if (cSeq <= 0) {
                return 0;
            }
            if (cBufLimit <= 0) {
                throw new IllegalArgumentException("cBufLimit must be > zero");
            }
            if (cb <= 0) {
                throw new IllegalArgumentException("cb must be > zero");
            }
            cSeqAlloc = 0;
            AtomicLong atlShared = null;
            Buffer bufShared = null;
            int cbWaste = cb / 64;
            bufferSeq = null;
            try {
                for (int i = 0; i < cSeq || bufShared != null && bufShared.remaining() >= cb; ++i) {
                    int cbReq = cb;
                    for (int iBuf = 0; cbReq > 0 && iBuf < cBufLimit; ++iBuf) {
                        BufferSequence bufSeqNew = null;
                        if (bufShared == null) {
                            ByteBuffer buf;
                            ByteBuffer byteBuffer = buf = iBuf == cBufLimit - 1 ? mgr.acquire(cbReq) : mgr.acquirePref(cbReq);
                            if (buf.capacity() - cbReq > cbWaste) {
                                bufShared = buf;
                                atlShared = new AtomicLong(1L);
                            } else {
                                bufSeqNew = new SingleBufferSequence(mgr, buf);
                            }
                        } else {
                            ((ByteBuffer)bufShared).limit(Math.min(bufShared.capacity(), bufShared.position() + cbReq));
                        }
                        if (bufSeqNew == null) {
                            Buffer bufDispose = bufShared;
                            AtomicLong atlDispose = atlShared;
                            if (atlDispose.incrementAndGet() <= 0L) {
                                throw new IllegalStateException();
                            }
                            bufSeqNew = new SingleBufferSequence(null, ((ByteBuffer)bufDispose).slice(), (ByteBuffer)bufDispose, atlDispose){
                                final /* synthetic */ ByteBuffer val$bufDispose;
                                final /* synthetic */ AtomicLong val$atlDispose;
                                {
                                    this.val$bufDispose = byteBuffer;
                                    this.val$atlDispose = atomicLong;
                                    super(manager, buffer);
                                }

                                @Override
                                public void dispose() {
                                    super.dispose();
                                    Buffers.safeRelease(mgr, this.val$bufDispose, this.val$atlDispose);
                                }
                            };
                            ((ByteBuffer)bufShared).position(bufShared.limit()).limit(bufShared.capacity());
                            if (bufShared.remaining() == 0 || cBufLimit == 1 && bufShared.remaining() < cb) {
                                Buffers.safeRelease(mgr, (ByteBuffer)bufShared, atlShared);
                                bufShared = null;
                                atlShared = null;
                            }
                        }
                        bufferSeq = bufferSeq == null ? bufSeqNew : new CompositeBufferSequence((BufferSequence)bufferSeq, bufSeqNew);
                        cbReq = (int)((long)cbReq - bufSeqNew.getLength());
                    }
                    collBufSeq.add((BufferSequence)bufferSeq);
                    bufferSeq = null;
                    ++cSeqAlloc;
                }
                if (atlShared == null) break block17;
            }
            catch (Throwable throwable) {
                if (atlShared != null) {
                    Buffers.safeRelease(mgr, bufShared, atlShared);
                }
                if (bufferSeq != null) {
                    bufferSeq.dispose();
                }
                throw throwable;
            }
            Buffers.safeRelease(mgr, (ByteBuffer)bufShared, atlShared);
        }
        if (bufferSeq != null) {
            bufferSeq.dispose();
        }
        return cSeqAlloc;
    }

    private static void safeRelease(BufferManager mgr, ByteBuffer bufShared, AtomicLong counter) {
        long c = counter.decrementAndGet();
        if (c == 0L) {
            mgr.release(bufShared);
        } else if (c < 0L) {
            throw new IllegalStateException();
        }
    }

    public static BufferSequence createBufferSequence(BufferManager manager, ByteBuffer buffer) {
        return new SingleBufferSequence(manager, buffer);
    }

    public static BufferSequence createBufferSequence(BufferManager manager, ByteBuffer bufferA, ByteBuffer bufferB) {
        return new DoubleBufferSequence(manager, bufferA, bufferB);
    }

    public static BufferSequence createBufferSequence(BufferManager manager, ByteBuffer bufferA, ByteBuffer bufferB, ByteBuffer bufferC) {
        return new TripleBufferSequence(manager, bufferA, bufferB, bufferC);
    }

    public static BufferSequence createBufferSequence(BufferManager manager, ByteBuffer ... aBuffer) {
        switch (aBuffer.length) {
            case 0: {
                return Buffers.getEmptyBufferSequence();
            }
            case 1: {
                return new SingleBufferSequence(manager, aBuffer[0]);
            }
            case 2: {
                return new DoubleBufferSequence(manager, aBuffer[0], aBuffer[1]);
            }
            case 3: {
                return new TripleBufferSequence(manager, aBuffer[0], aBuffer[1], aBuffer[2]);
            }
        }
        return new MultiBufferSequence(manager, aBuffer);
    }

    public static ByteBuffer slice(BufferSequence bufseq, long of, int cb) {
        if (of < 0L || cb < 0) {
            throw new IllegalArgumentException();
        }
        int c = bufseq.getBufferCount();
        for (int i = 0; i < c; ++i) {
            ByteBuffer buffer = bufseq.getBuffer(i);
            int cbBuf = buffer.remaining();
            if (of - (long)cbBuf <= 0L) {
                buffer.position((int)of).limit(cb);
                return buffer.slice();
            }
            of -= (long)cbBuf;
        }
        throw new IllegalArgumentException();
    }

    public static void copy(BufferSequence bufseqSrc, BufferSequence bufseqDest) {
        ByteBuffer bufSrc = Buffers.getEmptyBuffer();
        ByteBuffer bufDst = Buffers.getEmptyBuffer();
        int iSrc = 0;
        int iDst = 0;
        int cSrc = bufseqSrc.getBufferCount();
        int cDst = bufseqDest.getBufferCount();
        while (iSrc < cSrc) {
            if (!bufSrc.hasRemaining()) {
                bufSrc = bufseqSrc.getBuffer(iSrc++);
            }
            while (!bufDst.hasRemaining()) {
                if (iDst == cDst) {
                    return;
                }
                bufDst = bufseqDest.getBuffer(iDst++);
            }
            bufDst.put(bufSrc);
        }
    }

    public static void copy(ByteBuffer src, int ofSrc, int cb, ByteBuffer dst) {
        if (src.hasArray()) {
            dst.put(src.array(), src.arrayOffset() + ofSrc, cb);
        } else if (cb > 128) {
            src = src.duplicate();
            src.position(ofSrc).limit(ofSrc + cb);
            dst.put(src);
        } else if (src.order() == dst.order()) {
            int nPos = dst.position();
            while (cb >= 8) {
                dst.putLong(nPos, src.getLong(ofSrc));
                cb -= 8;
                nPos += 8;
                ofSrc += 8;
            }
            if (cb >= 4) {
                dst.putInt(nPos, src.getInt(ofSrc));
                cb -= 4;
                nPos += 4;
                ofSrc += 4;
            }
            if (cb >= 2) {
                dst.putShort(nPos, src.getShort(ofSrc));
                cb -= 2;
                nPos += 2;
                ofSrc += 2;
            }
            if (cb > 0) {
                dst.put(nPos, src.get(ofSrc));
            }
            dst.position(nPos);
        } else {
            while (cb-- > 0) {
                dst.put(src.get(ofSrc++));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equals(BufferSequence bufseqA, BufferSequence bufseqB) {
        if (bufseqA == bufseqB) {
            return true;
        }
        if (bufseqA == null || bufseqB == null) {
            return false;
        }
        long cb = bufseqA.getLength();
        if (cb == bufseqB.getLength()) {
            if (bufseqA.getBufferCount() == 1 && bufseqB.getBufferCount() == 1) {
                return bufseqA.getBuffer(0).equals(bufseqB.getBuffer(0));
            }
            BufferSequenceInputStream streamA = new BufferSequenceInputStream(bufseqA);
            BufferSequenceInputStream streamB = new BufferSequenceInputStream(bufseqB);
            try {
                while (cb > 0L && ((InputStream)streamA).read() == ((InputStream)streamB).read()) {
                    --cb;
                }
                boolean bl = cb == 0L;
                return bl;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    ((InputStream)streamA).close();
                    ((InputStream)streamB).close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static boolean equals(ByteBuffer bufA, int ofA, ByteBuffer bufB, int ofB, int cb) {
        while (cb-- > 0) {
            if (bufA.get(ofA++) == bufB.get(ofB++)) continue;
            return false;
        }
        return true;
    }

    public static void zero(ByteBuffer buffer) {
        int of = buffer.position();
        int ofEnd = buffer.limit();
        ByteOrder order = null;
        if (of == 0 && ofEnd == buffer.capacity()) {
            order = buffer.order();
            buffer.order(ByteOrder.nativeOrder());
        }
        while (ofEnd - of >= 8) {
            buffer.putLong(of, 0L);
            of += 8;
        }
        if (ofEnd - of >= 4) {
            buffer.putInt(of, 0);
            of += 4;
        }
        if (ofEnd - of >= 2) {
            buffer.putShort(of, (short)0);
            of += 2;
        }
        if (ofEnd - of == 1) {
            buffer.put(of, (byte)0);
        }
        if (order != null) {
            buffer.order(order);
        }
    }

    public static String toString(ByteBuffer buf) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int e = buf.limit();
        for (int i = buf.position(); i < e; ++i) {
            sb.append(String.format(" %02X", buf.get(i) & 0xFF));
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static String toString(ByteBuffer buf, int cbLimit) {
        return Buffers.toString(new SingleBufferSequence(null, buf), false, cbLimit);
    }

    public static String toString(BufferSequence bufseq) {
        return Buffers.toString(bufseq, false);
    }

    public static String toString(BufferSequence bufseq, boolean fBufDelimit) {
        return Buffers.toString(bufseq, fBufDelimit, Long.MAX_VALUE);
    }

    public static String toString(BufferSequence bufseq, boolean fBufDelimit, long cbLimit) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        long cb = bufseq.getLength();
        for (ByteBuffer buf : bufseq.getBuffers()) {
            int e = buf.limit();
            for (int i = buf.position(); i < e && --cbLimit >= 0L; ++i) {
                sb.append(String.format(" %02X", buf.get(i) & 0xFF));
                --cb;
            }
            if (cbLimit == 0L && cb > 0L) {
                sb.append(" ... " + cb + " bytes truncated]");
                return sb.toString();
            }
            if (!fBufDelimit) continue;
            sb.append(';');
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static int getInt(ByteBuffer[] aBuffer, int of) {
        ByteBuffer buff = aBuffer[of];
        if (buff.remaining() >= 4) {
            return buff.getInt();
        }
        int nResult = 0;
        for (int n = 24; n >= 0; n -= 8) {
            while (!buff.hasRemaining()) {
                buff = aBuffer[++of];
            }
            nResult |= (buff.get() & 0xFF) << n;
        }
        return nResult;
    }

    public static long getLong(ByteBuffer[] aBuffer, int of) {
        ByteBuffer buff = aBuffer[of];
        if (buff.remaining() >= 8) {
            return buff.getLong();
        }
        long lResult = 0L;
        for (int n = 56; n >= 0; n -= 8) {
            while (!buff.hasRemaining()) {
                buff = aBuffer[++of];
            }
            lResult |= ((long)buff.get() & 0xFFL) << n;
        }
        return lResult;
    }

    public static int updateCrc(CRC32 crc32, ByteBuffer buf) {
        int nPos = buf.position();
        crc32.update(buf);
        buf.position(nPos);
        return (int)crc32.getValue();
    }

    public static int updateCrc(CRC32 crc32, ByteBuffer[] aBuf, int of, long cb) {
        while (cb > 0L) {
            ByteBuffer buf = aBuf[of];
            if ((long)buf.remaining() > cb) {
                Buffers.updateCrc(crc32, buf, cb);
                break;
            }
            Buffers.updateCrc(crc32, buf);
            cb -= (long)buf.remaining();
            ++of;
        }
        return (int)crc32.getValue();
    }

    public static int updateCrc(CRC32 crc32, ByteBuffer buf, long cb) {
        int nLimit = buf.limit();
        buf.limit(buf.position() + (int)cb);
        int lCrc = Buffers.updateCrc(crc32, buf);
        buf.limit(nLimit);
        return lCrc;
    }

    private static class EmptyBuffer {
        public static ByteBuffer INSTANCE = ByteBuffer.allocate(0);

        private EmptyBuffer() {
        }
    }

    private static class EmptyDirectBuffer {
        public static ByteBuffer INSTANCE = ByteBuffer.allocateDirect(0);

        private EmptyDirectBuffer() {
        }
    }

    private static class EmptyBufferArray {
        public static ByteBuffer[] INSTANCE = new ByteBuffer[0];

        private EmptyBufferArray() {
        }
    }

    private static class EmptySequenceHolder {
        public static BufferSequence INSTANCE = new BufferSequence(){

            @Override
            public long getLength() {
                return 0L;
            }

            @Override
            public int getBufferCount() {
                return 0;
            }

            @Override
            public ByteBuffer getBuffer(int iBuffer) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public ByteBuffer getUnsafeBuffer(int iBuffer) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int getBufferPosition(int iBuffer) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int getBufferLimit(int iBuffer) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int getBufferLength(int iBuffer) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public ByteBuffer[] getBuffers() {
                return Buffers.getEmptyBufferArray();
            }

            @Override
            public void getBuffers(int iBuffer, int cBuffers, ByteBuffer[] abufDest, int iDest) {
                if (iBuffer < 0 || cBuffers != 0 || iDest >= abufDest.length) {
                    throw new IndexOutOfBoundsException();
                }
            }

            @Override
            public void dispose() {
            }
        };

        private EmptySequenceHolder() {
        }
    }
}

