/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.util;

import com.oracle.coherence.common.base.Disposable;

public abstract class TimerTask
implements Runnable,
Comparable<TimerTask>,
Disposable {
    final Object lock = new Object();
    int state = 0;
    static final int VIRGIN = 0;
    static final int SCHEDULED = 1;
    static final int EXECUTED = 2;
    static final int CANCELLED = 3;
    long nextExecutionTime;
    long period = 0L;
    long scheduleOrder;

    protected TimerTask() {
    }

    @Override
    public abstract void run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        Object object = this.lock;
        synchronized (object) {
            boolean result = this.state == 1;
            this.state = 3;
            return result;
        }
    }

    @Override
    public void dispose() {
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long scheduledExecutionTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.period < 0L ? this.nextExecutionTime + this.period : this.nextExecutionTime - this.period;
        }
    }

    @Override
    public int compareTo(TimerTask that) {
        long nextExecutionTimeThis = this.nextExecutionTime;
        long nextExecutionTimeThat = that.nextExecutionTime;
        if (nextExecutionTimeThis == nextExecutionTimeThat) {
            long scheduleOrderThis = this.scheduleOrder;
            long scheduleOrderThat = that.scheduleOrder;
            return scheduleOrderThis == scheduleOrderThat ? 0 : (scheduleOrderThis < scheduleOrderThat ? -1 : 1);
        }
        return nextExecutionTimeThis == nextExecutionTimeThat ? 0 : (nextExecutionTimeThis < nextExecutionTimeThat ? -1 : 1);
    }
}

