/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.util;

import com.oracle.coherence.common.base.Logger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class LoggingBridge {
    protected static final int FINEST = Level.FINEST.intValue();
    protected static final int FINER = Level.FINER.intValue();
    protected static final int FINE = Level.FINE.intValue();
    protected static final int CONFIG = Level.CONFIG.intValue();
    protected static final int INFO = Level.INFO.intValue();
    protected static final int WARNING = Level.WARNING.intValue();

    public static java.util.logging.Logger createBridge() {
        java.util.logging.Logger logger = java.util.logging.Logger.getAnonymousLogger();
        Level level = Logger.isEnabled(7) ? Level.FINEST : (Logger.isEnabled(6) ? Level.FINER : (Logger.isEnabled(5) ? Level.FINE : (Logger.isEnabled(4) ? Level.CONFIG : (Logger.isEnabled(3) ? Level.INFO : (Logger.isEnabled(2) ? Level.WARNING : Level.SEVERE)))));
        logger.setLevel(level);
        logger.setUseParentHandlers(false);
        logger.addHandler(new StreamHandler(){

            @Override
            public void publish(LogRecord record) {
                int nLevelDst;
                int nLevelSrc = record.getLevel().intValue();
                int n = nLevelSrc <= FINEST ? 7 : (nLevelSrc <= FINER ? 6 : (nLevelSrc <= FINE ? 5 : (nLevelSrc <= CONFIG ? 4 : (nLevelSrc <= INFO ? 3 : (nLevelDst = nLevelSrc <= WARNING ? 2 : 1)))));
                if (Logger.isEnabled(nLevelDst)) {
                    Throwable ex = record.getThrown();
                    if (ex == null) {
                        Logger.log(this.getFormatter().formatMessage(record), nLevelDst);
                    } else {
                        Logger.log(this.getFormatter().formatMessage(record), ex, nLevelDst);
                    }
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        return logger;
    }
}

