/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.util;

public class CanonicalNames {
    public static final String VALUE_EXTRACTOR_METHOD_SUFFIX = "()";
    public static final String[] VALUE_EXTRACTOR_BEAN_ACCESSOR_PREFIXES = new String[]{"get", "is"};

    public static String computeValueExtractorCanonicalName(String sName, Object[] aoParam) {
        int nMethodSuffixLength = VALUE_EXTRACTOR_METHOD_SUFFIX.length();
        if (aoParam != null && aoParam.length > 0) {
            return null;
        }
        Object sNameCanonical = sName;
        int nNameLength = sName.length();
        for (String sPrefix : VALUE_EXTRACTOR_BEAN_ACCESSOR_PREFIXES) {
            int nPrefixLength = sPrefix.length();
            if (nNameLength <= nPrefixLength || !sName.startsWith(sPrefix)) continue;
            int nSuffixLength = sName.endsWith(VALUE_EXTRACTOR_METHOD_SUFFIX) ? nMethodSuffixLength : 0;
            sNameCanonical = Character.toLowerCase(sName.charAt(nPrefixLength)) + sName.substring(nPrefixLength + 1, nNameLength - nSuffixLength);
            break;
        }
        return sNameCanonical;
    }

    public static String computeValueExtractorCanonicalName(String sName) {
        return CanonicalNames.computeValueExtractorCanonicalName(sName, null);
    }
}

