/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net.ssl;

import com.oracle.coherence.common.internal.net.WrapperServerSocketChannel;
import com.oracle.coherence.common.internal.net.ssl.SSLSelectorProvider;
import com.oracle.coherence.common.internal.net.ssl.SSLSocketChannel;
import com.oracle.coherence.common.net.SSLSocketProvider;
import java.io.IOException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class SSLServerSocketChannel
extends WrapperServerSocketChannel {
    protected final SSLSocketProvider m_providerSocket;
    protected boolean m_fBlocking;

    public SSLServerSocketChannel(ServerSocketChannel channel, SSLSocketProvider provider) throws IOException {
        super(channel, new SSLSelectorProvider(channel.provider()));
        this.m_providerSocket = provider;
        this.m_fBlocking = channel.isBlocking();
    }

    @Override
    public SocketChannel accept() throws IOException {
        if (this.m_fBlocking) {
            throw new IllegalBlockingModeException();
        }
        SocketChannel chan = this.f_delegate.accept();
        return chan == null ? null : new SSLSocketChannel(chan, this.getSocketProvider());
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        if (block) {
            throw new IllegalBlockingModeException();
        }
        this.f_delegate.configureBlocking(block);
        this.m_fBlocking = block;
    }

    public String toString() {
        return "SSLServerSocketChannel(" + String.valueOf(this.socket()) + ")";
    }

    protected SSLSocketProvider getSocketProvider() {
        return this.m_providerSocket;
    }
}

