/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net.socketbus;

import com.oracle.coherence.common.base.Hasher;
import com.oracle.coherence.common.internal.net.socketbus.SocketMessageBus;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferManagers;
import com.oracle.coherence.common.net.InetSocketAddressHasher;
import com.oracle.coherence.common.net.SelectionService;
import com.oracle.coherence.common.net.SelectionServices;
import com.oracle.coherence.common.net.SocketProvider;
import com.oracle.coherence.common.net.exabus.Bus;
import com.oracle.coherence.common.net.exabus.Depot;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.net.exabus.spi.Driver;
import com.oracle.coherence.common.net.exabus.util.UrlEndPoint;
import com.oracle.coherence.common.util.Duration;
import com.oracle.coherence.common.util.MemorySize;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOptions;
import java.util.logging.Logger;

public class SocketBusDriver
implements Driver {
    private static Logger LOGGER = Logger.getLogger(SocketBusDriver.class.getName());
    protected Depot m_depot;
    protected Dependencies m_dependencies;

    public SocketBusDriver(Dependencies deps) {
        this.m_dependencies = this.copyDependencies(deps).validate();
    }

    @Override
    public void setDepot(Depot depot) {
        this.m_depot = depot;
    }

    @Override
    public Depot getDepot() {
        return this.m_depot;
    }

    @Override
    public EndPoint resolveEndPoint(String sName) {
        block5: {
            if (sName == null) {
                return null;
            }
            Dependencies deps = this.getDependencies();
            String sMsg = deps.getMessageBusProtocol();
            String sMem = deps.getMemoryBusProtocol();
            if (sName.startsWith(sMsg) || sName.startsWith(sMem)) {
                try {
                    UrlEndPoint point = this.resolveSocketEndPoint(sName);
                    String sProtocol = point.getProtocol();
                    if (sProtocol.equals(sMsg) || sProtocol.equals(sMem)) {
                        return point;
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!sName.startsWith(sMsg + "://") && !sName.startsWith(sMem + "://")) break block5;
                    throw e;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isSupported(EndPoint point) {
        if (point == null) {
            return true;
        }
        if (point instanceof UrlEndPoint) {
            Dependencies deps = this.getDependencies();
            String sProtocol = ((UrlEndPoint)point).getProtocol();
            return sProtocol.equals(deps.getMessageBusProtocol()) || sProtocol.equals(deps.getMemoryBusProtocol());
        }
        return false;
    }

    @Override
    public Bus createBus(EndPoint pointLocal) {
        if (this.isSupported(pointLocal)) {
            try {
                Dependencies deps = this.getDependencies();
                UrlEndPoint pointSocket = (UrlEndPoint)pointLocal;
                String sProtocol = pointSocket.getProtocol();
                if (sProtocol.equals(deps.getMessageBusProtocol())) {
                    return new SocketMessageBus(this, pointSocket);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating SocketBus instance for " + String.valueOf(pointLocal), e);
            }
        }
        throw new IllegalArgumentException("unsupported EndPoint " + String.valueOf(pointLocal));
    }

    public UrlEndPoint resolveSocketEndPoint(String sName) {
        Dependencies deps = this.getDependencies();
        return new UrlEndPoint(sName, deps.getSocketProvider(), deps.getSocketAddressHasher());
    }

    public UrlEndPoint resolveBindPoint(UrlEndPoint pointLocal, ServerSocket socket) {
        Dependencies deps = this.getDependencies();
        SocketProvider provider = deps.getSocketProvider();
        String sQuery = pointLocal.getQueryString();
        return new UrlEndPoint(pointLocal.getProtocol() + "://" + provider.getAddressString(socket) + (String)(sQuery == null ? "" : "?" + sQuery), provider, deps.getSocketAddressHasher());
    }

    public Dependencies getDependencies() {
        return this.m_dependencies;
    }

    protected DefaultDependencies copyDependencies(Dependencies deps) {
        return new DefaultDependencies(deps);
    }

    public static interface Dependencies {
        public String getMessageBusProtocol();

        public String getMemoryBusProtocol();

        public SelectionService getSelectionService();

        public SocketProvider getSocketProvider();

        public Hasher<? super SocketAddress> getSocketAddressHasher();

        public SocketOptions getSocketOptions();

        public BufferManager getBufferManager();

        public Logger getLogger();

        public long getMaximumReceiptDelayMillis();

        public long getAckTimeoutMillis();

        default public long getDefaultAckTimeoutMillis() {
            return this.getAckTimeoutMillis();
        }

        public long getAckFatalTimeoutMillis();

        public long getSocketReconnectDelayMillis();

        public int getSocketReconnectLimit();

        public long getHeartbeatMillis();

        public long getAutoFlushThreshold();

        public long getReceiptRequestThreshold();

        public int getDirectWriteThreadThreshold();

        public int getDropRatio();

        public int getCorruptionRatio();

        public boolean isCrcEnabled();
    }

    public static class DefaultDependencies
    implements Dependencies {
        protected SocketProvider m_provider;
        protected Hasher<? super SocketAddress> m_hasher;
        protected SelectionService m_service;
        protected String m_sProtocolMessageBus;
        protected String m_sProtocolMemoryBus;
        protected SocketOptions m_options;
        protected BufferManager m_bufferManager;
        protected Logger m_logger;
        protected long m_cReconnectDelayMillis = new Duration(System.getProperty(SocketBusDriver.class.getName() + ".reconnectDelayMillis", "200ms")).getNanos() / 1000000L;
        protected int m_cReconnectLimit = Integer.parseInt(System.getProperty(SocketBusDriver.class.getName() + ".reconnectLimit", "3"));
        protected long m_cMaxReceiptDelayMillis = new Duration(System.getProperty(SocketBusDriver.class.getName() + ".maxReceiptDelayMillis", "500ms")).getNanos() / 1000000L;
        protected long m_cAckTimeoutMillis;
        protected long m_cDefaultAckTimeoutMillis = 10000L;
        protected long m_cAckFatalTimeoutMillis = new Duration(System.getProperty(SocketBusDriver.class.getName() + ".fatalTimeoutMillis", "10m")).getNanos() / 1000000L;
        protected long m_cHeartbeatDelayMillis = new Duration(System.getProperty(SocketBusDriver.class.getName() + ".heartbeatInterval", "0s")).getNanos() / 1000000L;
        protected long m_cbAutoFlush = DefaultDependencies.getSafeMemorySize(System.getProperty(SocketBusDriver.class.getName() + ".autoFlushThreshold"));
        protected long m_cbReceiptRequest = DefaultDependencies.getSafeMemorySize(System.getProperty(SocketBusDriver.class.getName() + ".receiptRequestThreshold"));
        protected int m_cThreadsDirect = Integer.parseInt(System.getProperty(SocketBusDriver.class.getName() + ".directWriteThreadThreshold", "4"));
        protected int m_nDropRatio = Integer.parseInt(System.getProperty(SocketBusDriver.class.getName() + ".dropRatio", "0"));
        protected int m_nCorruptionRatio = Integer.parseInt(System.getProperty(SocketBusDriver.class.getName() + ".corruptionRatio", "0"));
        protected boolean m_fCrc = Boolean.parseBoolean(System.getProperty(SocketBusDriver.class.getName() + ".crc", "false"));
        public static final BufferManager DEFAULT_BUFFER_MANAGER;
        public static final SocketOptions DEFAULT_OPTIONS;

        public DefaultDependencies() {
        }

        public DefaultDependencies(Dependencies deps) {
            if (deps != null) {
                this.m_provider = deps.getSocketProvider();
                this.m_hasher = deps.getSocketAddressHasher();
                this.m_service = deps.getSelectionService();
                this.m_sProtocolMessageBus = deps.getMessageBusProtocol();
                this.m_sProtocolMemoryBus = deps.getMemoryBusProtocol();
                this.m_options = deps.getSocketOptions();
                this.m_bufferManager = deps.getBufferManager();
                this.m_logger = deps.getLogger();
                this.m_cMaxReceiptDelayMillis = deps.getMaximumReceiptDelayMillis();
                this.m_cReconnectLimit = deps.getSocketReconnectLimit();
                this.m_cReconnectDelayMillis = deps.getSocketReconnectDelayMillis();
                this.m_cHeartbeatDelayMillis = deps.getHeartbeatMillis();
                this.m_cAckTimeoutMillis = deps.getAckTimeoutMillis();
                this.m_cDefaultAckTimeoutMillis = deps.getDefaultAckTimeoutMillis();
                this.m_cAckFatalTimeoutMillis = deps.getAckFatalTimeoutMillis();
                this.m_cbAutoFlush = deps.getAutoFlushThreshold();
                this.m_cbReceiptRequest = deps.getReceiptRequestThreshold();
                this.m_cThreadsDirect = deps.getDirectWriteThreadThreshold();
                this.m_nDropRatio = deps.getDropRatio();
                this.m_nCorruptionRatio = deps.getCorruptionRatio();
                this.m_fCrc = deps.isCrcEnabled();
            }
        }

        @Override
        public String getMessageBusProtocol() {
            return this.m_sProtocolMessageBus;
        }

        public DefaultDependencies setMessageBusProtocol(String sProtocol) {
            this.m_sProtocolMessageBus = sProtocol;
            return this;
        }

        @Override
        public String getMemoryBusProtocol() {
            return this.m_sProtocolMemoryBus;
        }

        public DefaultDependencies setMemoryBusProtocol(String sProtocol) {
            this.m_sProtocolMemoryBus = sProtocol;
            return this;
        }

        @Override
        public SelectionService getSelectionService() {
            SelectionService svc = this.m_service;
            return svc == null ? SelectionServices.getDefaultService() : svc;
        }

        public DefaultDependencies setSelectionService(SelectionService service) {
            this.m_service = service;
            return this;
        }

        @Override
        public SocketProvider getSocketProvider() {
            return this.m_provider;
        }

        public DefaultDependencies setSocketProvider(SocketProvider provider) {
            this.m_provider = provider;
            return this;
        }

        @Override
        public Hasher<? super SocketAddress> getSocketAddressHasher() {
            Hasher<? super SocketAddress> hasher = this.m_hasher;
            if (hasher == null) {
                return InetSocketAddressHasher.INSTANCE;
            }
            return hasher;
        }

        public DefaultDependencies setSocketAddressHahser(Hasher<? super SocketAddress> hasher) {
            this.m_hasher = hasher;
            return this;
        }

        @Override
        public SocketOptions getSocketOptions() {
            SocketOptions options = this.m_options;
            return options == null ? DEFAULT_OPTIONS : options;
        }

        public DefaultDependencies setSocketOptions(SocketOptions options) {
            this.m_options = options;
            return this;
        }

        @Override
        public BufferManager getBufferManager() {
            BufferManager manager = this.m_bufferManager;
            return manager == null ? DEFAULT_BUFFER_MANAGER : manager;
        }

        public DefaultDependencies setBufferManager(BufferManager manager) {
            this.m_bufferManager = manager;
            return this;
        }

        @Override
        public Logger getLogger() {
            Logger logger = this.m_logger;
            return logger == null ? LOGGER : logger;
        }

        public DefaultDependencies setLogger(Logger logger) {
            this.m_logger = logger;
            return this;
        }

        @Override
        public long getMaximumReceiptDelayMillis() {
            return this.m_cMaxReceiptDelayMillis;
        }

        public DefaultDependencies setMaximumReceiptDelayMillis(long cDelayMillis) {
            this.m_cMaxReceiptDelayMillis = cDelayMillis;
            return this;
        }

        @Override
        public long getAckTimeoutMillis() {
            return this.m_cAckTimeoutMillis;
        }

        public DefaultDependencies setAckTimeoutMillis(long cAckTimeoutMillis) {
            this.m_cAckTimeoutMillis = cAckTimeoutMillis;
            return this;
        }

        @Override
        public long getAckFatalTimeoutMillis() {
            return this.m_cAckFatalTimeoutMillis;
        }

        public DefaultDependencies setAckFatalTimeoutMillis(long cAckFatalTimeoutMillis) {
            this.m_cAckFatalTimeoutMillis = cAckFatalTimeoutMillis;
            return this;
        }

        @Override
        public long getDefaultAckTimeoutMillis() {
            return this.m_cDefaultAckTimeoutMillis;
        }

        public DefaultDependencies setDefaultAckTimeoutMillis(long cAckTimeoutMillis) {
            this.m_cDefaultAckTimeoutMillis = cAckTimeoutMillis;
            return this;
        }

        @Override
        public long getSocketReconnectDelayMillis() {
            return this.m_cReconnectDelayMillis;
        }

        public DefaultDependencies setSocketReconnectDelayMillis(long cDelayMillis) {
            this.m_cReconnectDelayMillis = cDelayMillis;
            return this;
        }

        @Override
        public int getSocketReconnectLimit() {
            return this.m_cReconnectLimit;
        }

        public DefaultDependencies setSocketReconnectLimit(int cReconnectLimit) {
            this.m_cReconnectLimit = cReconnectLimit;
            return this;
        }

        @Override
        public long getHeartbeatMillis() {
            return this.m_cHeartbeatDelayMillis;
        }

        public DefaultDependencies setHeartbeatMillis(long cMillis) {
            this.m_cHeartbeatDelayMillis = cMillis;
            return this;
        }

        @Override
        public long getAutoFlushThreshold() {
            return this.m_cbAutoFlush;
        }

        public DefaultDependencies setAutoFlushThreshold(long cbThreshold) {
            this.m_cbAutoFlush = cbThreshold;
            return this;
        }

        @Override
        public long getReceiptRequestThreshold() {
            return this.m_cbReceiptRequest;
        }

        public DefaultDependencies setReceiptRequestThreshold(long cbRequest) {
            this.m_cbReceiptRequest = cbRequest;
            return this;
        }

        @Override
        public int getDirectWriteThreadThreshold() {
            return this.m_cThreadsDirect;
        }

        public DefaultDependencies setDirectWriteThreadThreshold(int cThreads) {
            this.m_cThreadsDirect = cThreads;
            return this;
        }

        @Override
        public int getDropRatio() {
            return this.m_nDropRatio;
        }

        public DefaultDependencies setDropRatio(int nDropRatio) {
            this.m_nDropRatio = nDropRatio;
            return this;
        }

        @Override
        public int getCorruptionRatio() {
            return this.m_nCorruptionRatio;
        }

        public DefaultDependencies setCorruptionRatio(int nCorruptionRatio) {
            this.m_nCorruptionRatio = nCorruptionRatio;
            return this;
        }

        @Override
        public boolean isCrcEnabled() {
            return this.m_fCrc;
        }

        public DefaultDependencies isCrcEnabled(boolean fCrc) {
            this.m_fCrc = fCrc;
            return this;
        }

        protected DefaultDependencies validate() {
            DefaultDependencies.ensureArgument(this.getMemoryBusProtocol(), "MemoryBusProtocol");
            DefaultDependencies.ensureArgument(this.getMessageBusProtocol(), "MessageBusProtocol");
            DefaultDependencies.ensureArgument(this.getSelectionService(), "SelectionService");
            DefaultDependencies.ensureArgument(this.getSocketAddressHasher(), "SocketAddressHasher");
            DefaultDependencies.ensureArgument(this.getSocketProvider(), "SocketProvider");
            if (this.getMemoryBusProtocol().equals(this.getMessageBusProtocol())) {
                throw new IllegalArgumentException("memory and mess bus protocols cannot use the sane names");
            }
            this.m_cAckTimeoutMillis = new Duration(System.getProperty(SocketBusDriver.class.getName() + ".ackTimeoutMillis", this.getDefaultAckTimeoutMillis() + "ms")).getNanos() / 1000000L;
            return this;
        }

        protected static void ensureArgument(Object o, String sName) {
            if (o == null) {
                throw new IllegalArgumentException(sName + " cannot be null");
            }
        }

        private static long getSafeMemorySize(String sValue) {
            if (sValue == null) {
                return -1L;
            }
            return new MemorySize(sValue).getByteCount();
        }

        static {
            String sManager;
            switch (sManager = System.getProperty(SocketBusDriver.class.getName() + ".bufferManager", "network")) {
                case "heap": {
                    DEFAULT_BUFFER_MANAGER = BufferManagers.getHeapManager();
                    break;
                }
                case "direct": {
                    DEFAULT_BUFFER_MANAGER = BufferManagers.getDirectManager();
                    break;
                }
                case "network": {
                    DEFAULT_BUFFER_MANAGER = BufferManagers.getNetworkDirectManager();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown BufferManager: " + sManager);
                }
            }
            DEFAULT_OPTIONS = new SocketOptions(){
                final int RX_BUFFER_SIZE = (int)DefaultDependencies.getSafeMemorySize(System.getProperty(SocketBusDriver.class.getName() + ".socketRxBuffer"));
                final int TX_BUFFER_SIZE = (int)DefaultDependencies.getSafeMemorySize(System.getProperty(SocketBusDriver.class.getName() + ".socketTxBuffer"));

                @Override
                public void setOption(int optID, Object value) throws SocketException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Object getOption(int optID) throws SocketException {
                    switch (optID) {
                        case 1: {
                            return true;
                        }
                        case 128: {
                            return 0;
                        }
                        case 4098: {
                            return this.RX_BUFFER_SIZE == -1 ? null : Integer.valueOf(this.RX_BUFFER_SIZE);
                        }
                        case 4097: {
                            return this.TX_BUFFER_SIZE == -1 ? null : Integer.valueOf(this.TX_BUFFER_SIZE);
                        }
                    }
                    return null;
                }
            };
        }
    }
}

