/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net;

import com.oracle.coherence.common.internal.net.WrapperSelector;
import com.oracle.coherence.common.internal.net.WrapperServerSocket;
import com.oracle.coherence.common.internal.net.WrapperSocketChannel;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;

public class WrapperServerSocketChannel
extends ServerSocketChannel
implements WrapperSelector.WrapperSelectableChannel {
    protected final ServerSocketChannel f_delegate;
    protected final ServerSocket f_socket;

    public WrapperServerSocketChannel(ServerSocketChannel channel, SelectorProvider provider) throws IOException {
        super(provider);
        this.f_delegate = channel;
        this.f_socket = this.wrapSocket(channel.socket());
    }

    protected ServerSocket wrapSocket(ServerSocket socket) throws IOException {
        return new WrapperServerSocket(socket){

            @Override
            public Socket accept() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public ServerSocketChannel getChannel() {
                return WrapperServerSocketChannel.this;
            }
        };
    }

    public static ServerSocketChannel open() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerSocket socket() {
        return this.f_socket;
    }

    @Override
    public SocketChannel accept() throws IOException {
        SocketChannel channel = this.f_delegate.accept();
        return channel == null ? null : new WrapperSocketChannel(channel, this.provider());
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.f_delegate.close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.f_delegate.configureBlocking(block);
    }

    @Override
    public ServerSocketChannel bind(SocketAddress local, int backlog) throws IOException {
        return this.f_delegate.bind(local, backlog);
    }

    @Override
    public <T> ServerSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        return this.f_delegate.setOption((SocketOption)name, (Object)value);
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.f_delegate.getLocalAddress();
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.f_delegate.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.f_delegate.supportedOptions();
    }

    @Override
    public WrapperSelector.WrapperSelectionKey registerInternal(WrapperSelector selector, int ops, Object att) throws IOException {
        return new WrapperSelector.WrapperSelectionKey(selector, this.f_delegate.register(selector.getDelegate(), ops), att){

            @Override
            public SelectableChannel channel() {
                return WrapperServerSocketChannel.this;
            }
        };
    }
}

