/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SocketChannel;

public class SocketChannelInputStream
extends InputStream {
    protected final SocketChannel f_channel;

    public SocketChannelInputStream(SocketChannel channel) {
        this.f_channel = channel;
    }

    @Override
    public int read(byte[] ab, int off, int len) throws IOException {
        Object object = this.f_channel.blockingLock();
        synchronized (object) {
            if (this.f_channel.isBlocking()) {
                return this.f_channel.read(ByteBuffer.wrap(ab, off, len));
            }
            throw new IllegalBlockingModeException();
        }
    }

    @Override
    public void close() throws IOException {
        this.f_channel.close();
    }

    @Override
    public int read() throws IOException {
        byte[] ab = new byte[1];
        return this.read(ab) < 0 ? -1 : ab[0];
    }
}

