/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.NonBlocking;
import com.oracle.coherence.common.collections.ConcurrentLinkedQueue;
import com.oracle.coherence.common.net.SelectionService;
import com.oracle.coherence.common.util.Timers;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class RunnableSelectionService
implements SelectionService,
Runnable {
    private static final Runnable EOS = () -> {};
    private volatile Selector m_selector;
    private final Map<SelectableChannel, SelectionService.Handler> f_mapRegistrations = new HashMap<SelectableChannel, SelectionService.Handler>();
    private final Queue<Runnable> f_tasks = new ConcurrentLinkedQueue<Runnable>();
    private volatile boolean m_fPendingRegistrations;
    private long m_cMillisTimeout;

    @Override
    public synchronized void register(SelectableChannel chan, SelectionService.Handler handler) throws IOException {
        if (chan.isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        this.ensureSelector(chan);
        this.f_mapRegistrations.put(chan, handler);
        if (!this.m_fPendingRegistrations) {
            this.m_fPendingRegistrations = true;
            this.wakeup();
        }
    }

    @Override
    public void invoke(final SelectableChannel chan, final Runnable runnable, long cMillis) throws IOException {
        this.ensureSelector(chan);
        if (cMillis == 0L) {
            boolean fEmpty = this.f_tasks.isEmpty();
            this.f_tasks.add(runnable);
            if (fEmpty) {
                this.wakeup();
            }
        } else {
            Timers.scheduleNonBlockingTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        RunnableSelectionService.this.invoke(chan, runnable, 0L);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, cMillis);
        }
    }

    protected void wakeup() {
        Selector selector = this.m_selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Selector ensureSelector(SelectableChannel chan) throws IOException {
        Selector selector = this.m_selector;
        if (selector == null) {
            RunnableSelectionService runnableSelectionService = this;
            synchronized (runnableSelectionService) {
                selector = this.m_selector;
                if (selector == null) {
                    this.m_selector = selector = chan.provider().openSelector();
                    this.notifyAll();
                }
            }
        }
        if (!selector.isOpen()) {
            throw new ClosedSelectorException();
        }
        if (!chan.provider().equals(selector.provider())) {
            throw new IllegalSelectorException();
        }
        return selector;
    }

    protected synchronized int getChannelCount() {
        Selector selector = this.m_selector;
        return selector == null ? this.f_mapRegistrations.size() : Math.max(this.f_mapRegistrations.size(), selector.keys().size());
    }

    protected int getActiveChannelCount() {
        Selector selector = this.m_selector;
        return selector == null ? 0 : selector.keys().size();
    }

    @Override
    public void associate(SelectableChannel chanParent, SelectableChannel chanChild) throws IOException {
        this.register(chanChild, null);
    }

    @Override
    public synchronized void shutdown() {
        Selector selector = this.m_selector;
        if (selector != null) {
            try {
                selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public RunnableSelectionService setIdleTimeout(long cMillis) {
        this.m_cMillisTimeout = cMillis;
        return this;
    }

    public long getIdleTimeout() {
        return this.m_cMillisTimeout;
    }

    public synchronized boolean isIdle() {
        Selector selector = this.m_selector;
        return selector == null || !selector.isOpen() || selector.keys().isEmpty() && this.f_mapRegistrations.isEmpty() && this.f_tasks.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block13: {
            Selector selector = null;
            try {
                RunnableSelectionService runnableSelectionService = this;
                synchronized (runnableSelectionService) {
                    while ((selector = this.m_selector) == null) {
                        long cWait = this.getIdleTimeout();
                        Blocking.wait(this, cWait);
                        if (cWait == 0L || this.m_selector != null) continue;
                        return;
                    }
                }
                this.process();
                runnableSelectionService = this;
                synchronized (runnableSelectionService) {
                    if (this.isIdle()) {
                        this.m_selector = null;
                        selector.close();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
            }
            catch (ClosedSelectorException e) {
            }
            catch (IOException e) {
                if (!selector.isOpen()) break block13;
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized String toString() {
        return "SelectionService(channels=" + this.getChannelCount() + ", selector=" + String.valueOf(this.m_selector) + ", id=" + System.identityHashCode(this) + ")";
    }

    protected void process() throws IOException {
        Selector selector = this.m_selector;
        Set<SelectionKey> setReg = selector.keys();
        Set<SelectionKey> setReady = selector.selectedKeys();
        boolean fImmediate = false;
        try (NonBlocking nonBlocking = new NonBlocking();){
            int i = 0;
            while (true) {
                block23: {
                    block22: {
                        if (!fImmediate) {
                            this.processRunnables();
                            if (this.m_fPendingRegistrations) {
                                fImmediate |= this.processRegistrations();
                            }
                        }
                        try {
                            if (!fImmediate && !this.m_fPendingRegistrations && this.f_tasks.isEmpty()) {
                                long cMillisTimeout = (this.getIdleTimeout() + 1L) / 2L;
                                if (Blocking.select(selector, cMillisTimeout) == 0 && cMillisTimeout != 0L && setReg.isEmpty() && this.isIdle() && Blocking.select(selector, cMillisTimeout) == 0 && this.isIdle()) {
                                    return;
                                }
                                break block22;
                            }
                            selector.selectNow();
                            fImmediate = false;
                            break block23;
                        }
                        catch (CancelledKeyException e) {
                            fImmediate = true;
                        }
                    }
                    boolean fEager = true;
                    for (int iSpin = 0; fEager && iSpin < 4; ++iSpin) {
                        fEager = false;
                        Iterator<SelectionKey> iter = setReady.iterator();
                        while (iter.hasNext()) {
                            SelectionKey key = iter.next();
                            try {
                                int nInterest = key.interestOps();
                                int nReady = key.readyOps();
                                int nInterestNew = ((SelectionService.Handler)key.attachment()).onReady(iSpin > 0 ? SelectionService.Handler.OP_EAGER | nInterest : nReady);
                                if ((nInterestNew & SelectionService.Handler.OP_EAGER) == 0) {
                                    iter.remove();
                                } else {
                                    fEager = true;
                                    nInterestNew &= ~SelectionService.Handler.OP_EAGER;
                                }
                                if (nInterestNew == nInterest) continue;
                                key.interestOps(nInterestNew);
                            }
                            catch (Throwable t) {
                                key.cancel();
                                fImmediate = true;
                                try {
                                    iter.remove();
                                }
                                catch (IllegalStateException illegalStateException) {}
                            }
                        }
                    }
                    if (fEager && (i & 0xF) == 0) {
                        setReady.clear();
                    }
                }
                ++i;
            }
        }
    }

    protected synchronized boolean processRegistrations() throws IOException {
        boolean fImmediate = false;
        Map<SelectableChannel, SelectionService.Handler> mapReg = this.f_mapRegistrations;
        Selector selector = this.m_selector;
        for (Map.Entry<SelectableChannel, SelectionService.Handler> entry : mapReg.entrySet()) {
            SelectableChannel chan = entry.getKey();
            SelectionService.Handler handler = entry.getValue();
            if (handler == null) {
                SelectionKey key = chan.keyFor(selector);
                if (key == null) continue;
                fImmediate = true;
                key.cancel();
                continue;
            }
            try {
                chan.register(selector, chan.validOps(), handler);
            }
            catch (IOException e) {
                fImmediate = true;
            }
            catch (CancelledKeyException e) {
                fImmediate = true;
            }
        }
        mapReg.clear();
        this.m_fPendingRegistrations = false;
        return fImmediate;
    }

    protected void processRunnables() {
        this.f_tasks.add(EOS);
        Runnable task = this.f_tasks.poll();
        while (task != EOS) {
            try {
                task.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            task = this.f_tasks.poll();
        }
    }
}

