/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.internal.net.RunnableSelectionService;
import com.oracle.coherence.common.net.SelectionService;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResumableSelectionService
extends RunnableSelectionService {
    protected final ThreadFactory m_factory;
    protected volatile Thread m_thread;
    protected boolean m_fUsed;

    public ResumableSelectionService(ThreadFactory factory) {
        this.m_factory = factory;
    }

    @Override
    public synchronized void register(SelectableChannel chan, SelectionService.Handler handler) throws IOException {
        super.register(chan, handler);
        this.ensureThread();
    }

    @Override
    public synchronized void invoke(SelectableChannel chan, Runnable runnable, long cMillis) throws IOException {
        super.invoke(chan, runnable, cMillis);
        this.ensureThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Thread ensureThread() {
        Thread thread = this.m_thread;
        if (thread == null) {
            ResumableSelectionService resumableSelectionService = this;
            synchronized (resumableSelectionService) {
                thread = this.m_thread;
                if (thread == null) {
                    this.m_thread = thread = this.m_factory.newThread(this);
                    thread.setName(this.toString());
                    thread.start();
                }
            }
        }
        return thread;
    }

    @Override
    protected boolean processRegistrations() throws IOException {
        int cChanPre = this.getActiveChannelCount();
        boolean fSelect = super.processRegistrations();
        if (this.getActiveChannelCount() != cChanPre) {
            this.ensureThread().setName(this.toString());
        }
        return fSelect;
    }

    @Override
    protected void wakeup() {
        if (Thread.currentThread() != this.ensureThread()) {
            super.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (Thread.currentThread() != this.m_thread) {
            throw new UnsupportedOperationException();
        }
        Logger.getLogger(this.getClass().getName()).log(Level.FINER, (this.m_fUsed ? "Resuming " : "Starting ") + String.valueOf(this));
        this.m_fUsed = true;
        try {
            while (true) {
                try {
                    super.run();
                }
                catch (Throwable e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Unhandled exception in " + String.valueOf(this) + ", attempting to continue", e);
                    try {
                        Blocking.sleep(1000L);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                    }
                }
                ResumableSelectionService resumableSelectionService = this;
                synchronized (resumableSelectionService) {
                    if (this.isIdle()) {
                        this.m_thread = null;
                        return;
                    }
                }
            }
        }
        finally {
            Logger.getLogger(this.getClass().getName()).log(Level.FINER, "Suspending " + String.valueOf(this));
        }
    }
}

