/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.collections.UnmodifiableSetCollection;
import com.oracle.coherence.common.internal.net.SocketChannelInputStream;
import com.oracle.coherence.common.internal.net.SocketChannelOutputStream;
import com.oracle.coherence.common.internal.net.WrapperSelector;
import com.oracle.coherence.common.internal.net.WrapperServerSocketChannel;
import com.oracle.coherence.common.internal.net.WrapperSocket;
import com.oracle.coherence.common.internal.net.WrapperSocketChannel;
import com.oracle.coherence.common.io.Buffers;
import com.oracle.coherence.common.net.InetAddressComparator;
import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.oracle.coherence.common.net.SafeSelectionHandler;
import com.oracle.coherence.common.net.SelectionService;
import com.oracle.coherence.common.net.SelectionServices;
import com.oracle.coherence.common.net.SocketProvider;
import com.oracle.coherence.common.net.TcpSocketProvider;
import com.oracle.coherence.common.util.Duration;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MultiplexedSocketProvider
implements SocketProvider {
    protected static final int PROTOCOL_ID = 1522655232;
    public static final int WELL_KNOWN_SUB_PORT_END = 1023;
    protected static final int EPHEMERAL_SUB_PORT_START = 32768;
    private static Logger LOGGER = Logger.getLogger(MultiplexedSocketProvider.class.getName());
    static final Set<SocketOption<?>> SERVER_OPTIONS;
    protected final Dependencies m_dependencies;
    protected final ConcurrentMap<InetSocketAddress, Listener> m_mapListener = new ConcurrentHashMap<InetSocketAddress, Listener>();
    protected int m_nPortEphemeralLow = Integer.MAX_VALUE;
    protected int m_nPortEphemeralHi = Integer.MIN_VALUE;

    public MultiplexedSocketProvider(Dependencies deps) {
        this.m_dependencies = this.copyDependencies(deps).validate();
    }

    public Dependencies getDependencies() {
        return this.m_dependencies;
    }

    @Override
    public SocketAddress resolveAddress(String sAddr) {
        int ofPort;
        int ofAddrEnd;
        if (sAddr.startsWith("[")) {
            ofAddrEnd = sAddr.lastIndexOf("]:") + 1;
            if (ofAddrEnd == 2) {
                throw new IllegalArgumentException("address does not contain an hostname or ip");
            }
            if (ofAddrEnd == -1) {
                throw new IllegalArgumentException("address does not contain a port");
            }
            ofPort = ofAddrEnd + 1;
        } else {
            ofAddrEnd = sAddr.lastIndexOf(58);
            if (ofAddrEnd == 0) {
                throw new IllegalArgumentException("address does not contain an hostname of ip");
            }
            if (ofAddrEnd == -1) {
                throw new IllegalArgumentException("address does not contain a port");
            }
            ofPort = ofAddrEnd + 1;
        }
        String sHost = sAddr.substring(0, ofAddrEnd);
        int ofPortSub = sAddr.indexOf(46, ofPort);
        if (ofPortSub == -1) {
            int nPort = Integer.parseInt(sAddr.substring(ofPort));
            return new InetSocketAddress32(sHost, nPort);
        }
        int nPortBase = Integer.parseInt(sAddr.substring(ofPort, ofPortSub));
        int nPortSub = Integer.parseInt(sAddr.substring(ofPortSub + 1));
        return new InetSocketAddress32(sHost, MultiplexedSocketProvider.getPort(nPortBase, nPortSub));
    }

    @Override
    public String getAddressString(Socket socket) {
        int nPort;
        InetAddress addr = socket.getInetAddress();
        if (addr == null) {
            return null;
        }
        Object sAddr = addr.getHostAddress();
        if (((String)sAddr).contains(":")) {
            sAddr = "[" + (String)sAddr + "]";
        }
        return (String)sAddr + ":" + String.valueOf(MultiplexedSocketProvider.isPortExtended(nPort = socket.getPort()) ? MultiplexedSocketProvider.getBasePort(nPort) + "." + MultiplexedSocketProvider.getSubPort(nPort) : Integer.valueOf(nPort));
    }

    @Override
    public String getAddressString(ServerSocket socket) {
        int nPort;
        Object sAddr;
        InetAddress addr = socket.getInetAddress();
        boolean fAny = addr.isAnyLocalAddress();
        if (fAny) {
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            sAddr = addr.getHostName();
        } else {
            sAddr = addr.getHostAddress();
        }
        if (((String)sAddr).contains(":")) {
            sAddr = "[" + (String)sAddr + "]";
        }
        return (String)sAddr + ":" + String.valueOf(MultiplexedSocketProvider.isPortExtended(nPort = socket.getLocalPort()) ? MultiplexedSocketProvider.getBasePort(nPort) + "." + MultiplexedSocketProvider.getSubPort(nPort) : Integer.valueOf(nPort));
    }

    @Override
    public ServerSocketChannel openServerSocketChannel() throws IOException {
        return new MultiplexedServerSocketChannel(this);
    }

    @Override
    public ServerSocket openServerSocket() throws IOException {
        return this.openServerSocketChannel().socket();
    }

    @Override
    public SocketChannel openSocketChannel() throws IOException {
        return new MultiplexedSocketChannel(this.getDependencies().getDelegateProvider().openSocketChannel(), null, null);
    }

    @Override
    public Socket openSocket() throws IOException {
        return new MultiplexedSocket(this.getDependencies().getDelegateProvider().openSocket(), null);
    }

    @Override
    public SocketProvider getDelegate() {
        return this.getDependencies().getDelegateProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InetSocketAddress32 open(InetSocketAddress32 addr, MultiplexedServerSocketChannel server, Set<Integer> setBaseExclude) throws IOException {
        if (addr == null) {
            addr = new InetSocketAddress32(InetAddress.getLocalHost(), 0);
        } else if (addr.isUnresolved()) {
            throw new SocketException(addr.getHostName());
        }
        InetSocketAddress addrListen = MultiplexedSocketProvider.getTransportAddress(addr);
        InetAddress addrIp = addr.getAddress();
        int nPort = addr.getPort();
        ServerSocket socket = server.socket();
        int nPortSub = MultiplexedSocketProvider.getSubPort(nPort);
        if (nPortSub > 0 && nPortSub <= 1023) {
            boolean fKnown = false;
            for (WellKnownSubPorts port : WellKnownSubPorts.values()) {
                if (port.getSubPort() != nPortSub) continue;
                fKnown = true;
                break;
            }
            if (!fKnown) {
                throw new IOException("attempt to bind to unassigned sub-port " + nPortSub + " in well known subport range");
            }
        }
        if (addrIp != null && InetAddresses.isNatLocalAddress(addrIp, nPort)) {
            addrIp = InetAddresses.ADDR_ANY;
        }
        if (addrIp != null && addrIp.isAnyLocalAddress()) {
            boolean fEphemeral = MultiplexedSocketProvider.getSubPort(nPort) == 0 || MultiplexedSocketProvider.getBasePort(nPort) == 0;
            HashSet<InetSocketAddress32> setAddrAcquired = new HashSet<InetSocketAddress32>();
            TreeSet<InetAddress> setIpAll = new TreeSet<InetAddress>(InetAddressComparator.INSTANCE);
            Iterator iter = NetworkInterface.getNetworkInterfaces();
            while (iter.hasMoreElements()) {
                NetworkInterface nic = iter.nextElement();
                Enumeration<InetAddress> iterAddr = nic.getInetAddresses();
                while (iterAddr.hasMoreElements()) {
                    setIpAll.add(iterAddr.nextElement());
                }
                Enumeration<NetworkInterface> iterSub = nic.getSubInterfaces();
                while (iterSub.hasMoreElements()) {
                    Enumeration<InetAddress> iterAddr2 = iterSub.nextElement().getInetAddresses();
                    while (iterAddr2.hasMoreElements()) {
                        setIpAll.add(iterAddr2.nextElement());
                    }
                }
            }
            try {
                iter = setIpAll.iterator();
                while (iter.hasNext()) {
                    InetAddress addrNext = (InetAddress)iter.next();
                    if (addrNext.isAnyLocalAddress()) continue;
                    try {
                        InetSocketAddress32 addrAdd = this.open(new InetSocketAddress32(addrNext, nPort), server, setBaseExclude);
                        setAddrAcquired.add(addrAdd);
                        if (MultiplexedSocketProvider.getSubPort(nPort) != 0 && MultiplexedSocketProvider.getBasePort(nPort) != 0) continue;
                        nPort = addrAdd.getPort();
                    }
                    catch (IOException e) {
                        try {
                            this.close(this.open(new InetSocketAddress32(addrNext, 0), server, setBaseExclude));
                        }
                        catch (IOException e2) {
                            continue;
                        }
                        if (fEphemeral && nPort != addr.getPort()) {
                            nPort = addr.getPort();
                            iter = setIpAll.iterator();
                            if (setBaseExclude == null) {
                                setBaseExclude = new HashSet<Integer>();
                            }
                            setBaseExclude.add(MultiplexedSocketProvider.getBasePort(nPort));
                            continue;
                        }
                        throw e;
                    }
                }
                iter = setAddrAcquired.iterator();
                while (iter.hasNext()) {
                    InetSocketAddress32 addr32 = (InetSocketAddress32)iter.next();
                    if (addr32.getPort() != nPort) continue;
                    iter.remove();
                }
                iter = fEphemeral ? new InetSocketAddress32(addr.getAddress(), nPort) : addr;
                return iter;
            }
            finally {
                for (InetSocketAddress32 addrDrop : setAddrAcquired) {
                    try {
                        this.close(addrDrop);
                    }
                    catch (IOException e2) {}
                }
            }
        }
        int nPortEphemeralLow = this.m_nPortEphemeralLow;
        int nPortEphemeralHi = this.m_nPortEphemeralHi;
        ConcurrentMap<InetSocketAddress, Listener> mapListener = this.m_mapListener;
        if (MultiplexedSocketProvider.getBasePort(nPort) == 0 && !mapListener.isEmpty()) {
            for (Map.Entry entry : mapListener.entrySet()) {
                int nPortUsed = ((InetSocketAddress)entry.getKey()).getPort();
                if (setBaseExclude != null && !setBaseExclude.contains(nPortUsed) || nPortUsed < nPortEphemeralLow || nPortUsed > nPortEphemeralHi || !((InetSocketAddress)entry.getKey()).getAddress().equals(addrIp)) continue;
                try {
                    return this.open(new InetSocketAddress32(addrIp, MultiplexedSocketProvider.getPort(nPortUsed, MultiplexedSocketProvider.getSubPort(nPort))), server, null);
                }
                catch (IOException e2) {
                }
            }
        }
        AbstractInterruptibleChannel chanGarbage = null;
        while (true) {
            Listener listener;
            if ((listener = (Listener)mapListener.get(addrListen)) == null) {
                ListenChannel chanListen = new ListenChannel(this.getDependencies().getDelegateProvider().openServerSocketChannel());
                try {
                    ServerSocket socketListen = ((ServerSocketChannel)chanListen).socket();
                    socketListen.setReceiveBufferSize(socket.getReceiveBufferSize());
                    socketListen.bind(addrListen, this.getDependencies().getBacklog());
                    if (MultiplexedSocketProvider.getBasePort(nPort) == 0) {
                        int nPortBind = ((ServerSocketChannel)chanListen).socket().getLocalPort();
                        if (nPortBind == 65535) {
                            chanGarbage = chanListen;
                            continue;
                        }
                        if (nPortBind < nPortEphemeralLow) {
                            this.m_nPortEphemeralLow = nPortBind;
                        }
                        if (nPortBind > nPortEphemeralHi) {
                            this.m_nPortEphemeralHi = nPortBind;
                        }
                        addrListen = (InetSocketAddress)((ServerSocketChannel)chanListen).socket().getLocalSocketAddress();
                    }
                    chanListen.configureBlocking(false);
                    listener = new Listener(chanListen);
                    this.getDependencies().getSelectionService().register(chanListen, listener);
                    mapListener.put(addrListen, listener);
                }
                catch (IOException e) {
                    chanListen.close();
                    if (chanGarbage != null) {
                        chanGarbage.close();
                    }
                    throw e;
                }
            }
            if (chanGarbage != null) {
                chanGarbage.close();
                chanGarbage = null;
            }
            Listener listener2 = listener;
            synchronized (listener2) {
                ServerSocketChannel chanListen = (ServerSocketChannel)listener.getChannel();
                if (chanListen.isOpen()) {
                    return listener.register(MultiplexedSocketProvider.getSubPort(nPort), server);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(InetSocketAddress32 addr) throws IOException {
        InetAddress addrIp = addr.getAddress();
        int nPort = addr.getPort();
        if (addrIp != null && addrIp.isAnyLocalAddress()) {
            Enumeration<NetworkInterface> iter = NetworkInterface.getNetworkInterfaces();
            while (iter.hasMoreElements()) {
                Enumeration<InetAddress> iterAddr = iter.nextElement().getInetAddresses();
                while (iterAddr.hasMoreElements()) {
                    try {
                        InetAddress addrIface = iterAddr.nextElement();
                        if (addrIface.isAnyLocalAddress()) continue;
                        this.close(new InetSocketAddress32(addrIface, addr.getPort()));
                    }
                    catch (IOException addrIface) {}
                }
            }
            return;
        }
        ConcurrentMap<InetSocketAddress, Listener> mapListener = this.m_mapListener;
        InetSocketAddress addrListen = MultiplexedSocketProvider.getTransportAddress(addr);
        Listener listener = (Listener)mapListener.get(addrListen);
        if (listener == null) {
            throw new IOException("not bound");
        }
        Listener listener2 = listener;
        synchronized (listener2) {
            if (listener.deregister(MultiplexedSocketProvider.getSubPort(nPort))) {
                ((ServerSocketChannel)listener.getChannel()).close();
                mapListener.remove(addrListen);
            }
        }
    }

    public static InetSocketAddress getTransportAddress(InetSocketAddress32 addr) {
        if (addr == null) {
            return null;
        }
        return new InetSocketAddress(addr.getAddress(), MultiplexedSocketProvider.getBasePort(addr.getPort()));
    }

    public static boolean isPortExtended(int nPort) {
        return (nPort & 0xFFFF0000) != 0;
    }

    public static int getBasePort(int nPort) {
        return MultiplexedSocketProvider.isPortExtended(nPort) ? ~nPort >>> 16 : nPort;
    }

    public static int getSubPort(int nPort) {
        return MultiplexedSocketProvider.isPortExtended(nPort) ? ~nPort & 0xFFFF : -1;
    }

    public static int getPort(int nPortBase, int nPortSub) {
        if (nPortBase < 0 || nPortBase > 65535) {
            throw new IllegalArgumentException("base port " + nPortBase + " is out of range");
        }
        if (nPortSub < -1 || nPortSub > 65535) {
            throw new IllegalArgumentException("sub port " + nPortSub + " is out of range");
        }
        if (nPortBase == 65535 && nPortSub >= 0) {
            throw new IllegalArgumentException("base port of 65535 does not support sub ports");
        }
        return nPortSub == -1 ? nPortBase : ~(nPortBase << 16 | nPortSub);
    }

    protected DefaultDependencies copyDependencies(Dependencies deps) {
        return new DefaultDependencies(deps);
    }

    static {
        HashSet<SocketOption<Constable>> setOpt = new HashSet<SocketOption<Constable>>();
        setOpt.add(StandardSocketOptions.SO_RCVBUF);
        setOpt.add(StandardSocketOptions.SO_REUSEADDR);
        SERVER_OPTIONS = Collections.unmodifiableSet(setOpt);
    }

    public static interface Dependencies {
        public SocketProvider getDelegateProvider();

        public SelectionService getSelectionService();

        public int getBacklog();

        public long getIdentificationTimeoutMillis();

        public Logger getLogger();
    }

    public static class DefaultDependencies
    implements Dependencies {
        protected static final int s_nBacklogDefault;
        protected static final long s_cMillisIdentifyDefault;
        protected SocketProvider m_provider;
        protected SelectionService m_service;
        protected int m_nBacklog = s_nBacklogDefault;
        protected long m_cMillisIdentify = s_cMillisIdentifyDefault;
        protected Logger m_logger;

        public DefaultDependencies() {
            this(null);
        }

        public DefaultDependencies(Dependencies deps) {
            if (deps != null) {
                this.m_provider = deps.getDelegateProvider();
                this.m_service = deps.getSelectionService();
                this.m_nBacklog = deps.getBacklog();
                this.m_cMillisIdentify = deps.getIdentificationTimeoutMillis();
                this.m_logger = deps.getLogger();
            }
        }

        protected DefaultDependencies validate() {
            return this;
        }

        @Override
        public SocketProvider getDelegateProvider() {
            SocketProvider provider = this.m_provider;
            if (provider == null) {
                this.m_provider = provider = TcpSocketProvider.INSTANCE;
            }
            return provider;
        }

        public DefaultDependencies setDelegateProvider(SocketProvider provider) {
            this.m_provider = provider;
            return this;
        }

        @Override
        public SelectionService getSelectionService() {
            SelectionService service = this.m_service;
            if (service == null) {
                this.m_service = service = SelectionServices.getDefaultService();
            }
            return service;
        }

        public DefaultDependencies setSelectionService(SelectionService service) {
            this.m_service = service;
            return this;
        }

        @Override
        public int getBacklog() {
            return this.m_nBacklog;
        }

        public DefaultDependencies setBacklog(int nBacklog) {
            this.m_nBacklog = nBacklog;
            return this;
        }

        @Override
        public long getIdentificationTimeoutMillis() {
            return this.m_cMillisIdentify;
        }

        public DefaultDependencies setIdentificationTimeoutMillis(long cMillis) {
            this.m_cMillisIdentify = cMillis;
            return this;
        }

        @Override
        public Logger getLogger() {
            Logger logger = this.m_logger;
            return logger == null ? LOGGER : logger;
        }

        public DefaultDependencies setLogger(Logger logger) {
            this.m_logger = logger;
            return this;
        }

        static {
            int nBacklog = Integer.MAX_VALUE;
            try {
                nBacklog = Integer.parseInt(System.getProperty(MultiplexedSocketProvider.class.getName() + ".server.backlog", Integer.toString(nBacklog)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            s_nBacklogDefault = nBacklog;
            long cMillisId = 0L;
            try {
                cMillisId = new Duration(System.getProperty(MultiplexedSocketProvider.class.getName() + ".server.identification.timeout", "1m")).as(Duration.Magnitude.MILLI);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            s_cMillisIdentifyDefault = cMillisId;
        }
    }

    protected static class MultiplexedServerSocketChannel
    extends ServerSocketChannel
    implements MultiplexedChannel {
        protected final BlockingQueue<SocketChannel> m_queue = new LinkedBlockingDeque<SocketChannel>();
        protected ServerSocket m_socket;
        protected ServerSelectionKey m_keyHead;
        protected MultiplexedSocketProvider m_provider;
        protected boolean m_fClosed;
        protected static final SocketChannel SERVER_CHANNEL_CLOSED_MARKER = new SocketChannel(null){

            @Override
            public Socket socket() {
                return null;
            }

            @Override
            public boolean isConnected() {
                return false;
            }

            @Override
            public boolean isConnectionPending() {
                return false;
            }

            @Override
            public boolean connect(SocketAddress remote) throws IOException {
                return false;
            }

            @Override
            public boolean finishConnect() throws IOException {
                return false;
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return 0;
            }

            @Override
            public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
                return 0L;
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return 0;
            }

            @Override
            public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                return 0L;
            }

            @Override
            protected void implCloseSelectableChannel() throws IOException {
            }

            @Override
            protected void implConfigureBlocking(boolean block) throws IOException {
            }

            @Override
            public SocketChannel bind(SocketAddress local) throws IOException {
                return null;
            }

            @Override
            public <T> SocketChannel setOption(SocketOption<T> name, T value) throws IOException {
                return null;
            }

            @Override
            public SocketChannel shutdownInput() throws IOException {
                return null;
            }

            @Override
            public SocketChannel shutdownOutput() throws IOException {
                return null;
            }

            @Override
            public SocketAddress getRemoteAddress() throws IOException {
                return null;
            }

            @Override
            public SocketAddress getLocalAddress() throws IOException {
                return null;
            }

            @Override
            public <T> T getOption(SocketOption<T> name) throws IOException {
                return null;
            }

            @Override
            public Set<SocketOption<?>> supportedOptions() {
                return null;
            }
        };

        public MultiplexedServerSocketChannel(MultiplexedSocketProvider provider) throws IOException {
            super(new MultiplexedSelectorProvider(provider.getDependencies().getDelegateProvider()));
            this.m_provider = provider;
            this.m_socket = this.createServerSocket();
        }

        protected ServerSocket createServerSocket() throws IOException {
            return new ServerSocket(){
                InetSocketAddress32 m_address;

                @Override
                public void bind(SocketAddress endpoint) throws IOException {
                    this.bind(endpoint, 0);
                }

                @Override
                public void bind(SocketAddress endpoint, int backlog) throws IOException {
                    if (this.isBound()) {
                        throw new IOException("already bound");
                    }
                    if (endpoint != null && !(endpoint instanceof InetSocketAddress32)) {
                        throw new IllegalArgumentException("unsupported SocketAddress type");
                    }
                    InetSocketAddress32 addr = (InetSocketAddress32)endpoint;
                    this.m_address = m_provider.open(addr, this, null);
                }

                @Override
                public InetAddress getInetAddress() {
                    return this.m_address.getAddress();
                }

                @Override
                public int getLocalPort() {
                    return this.m_address.getPort();
                }

                @Override
                public SocketAddress getLocalSocketAddress() {
                    return this.m_address;
                }

                @Override
                public ServerSocketChannel getChannel() {
                    return this;
                }

                @Override
                public boolean isBound() {
                    return this.m_address != null;
                }

                @Override
                public boolean isClosed() {
                    return m_fClosed;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    boolean fClosed;
                    BlockingQueue<SocketChannel> queue;
                    BlockingQueue<SocketChannel> blockingQueue = queue = m_queue;
                    synchronized (blockingQueue) {
                        super.close();
                        fClosed = m_fClosed;
                        m_fClosed = true;
                    }
                    if (!fClosed) {
                        InetSocketAddress32 addr = (InetSocketAddress32)this.getLocalSocketAddress();
                        if (addr != null) {
                            m_provider.close(addr);
                        }
                        ServerSelectionKey key = m_keyHead;
                        while (key != null) {
                            key.cancel();
                            key = key.m_next;
                        }
                        SocketChannel chan = (SocketChannel)queue.poll();
                        while (chan != null) {
                            try {
                                chan.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            chan = (SocketChannel)queue.poll();
                        }
                        queue.add(SERVER_CHANNEL_CLOSED_MARKER);
                    }
                }

                @Override
                public Socket accept() throws IOException {
                    ServerSocketChannel chanServer = this.getChannel();
                    if (chanServer.isBlocking()) {
                        SocketChannel channel = chanServer.accept();
                        long cMillis = chanServer.socket().getSoTimeout();
                        if (channel == null && cMillis > 0L) {
                            throw new SocketTimeoutException("SocketTimeout after configured SO_TIMEOUT " + cMillis + "ms");
                        }
                        return channel.socket();
                    }
                    throw new IllegalBlockingModeException();
                }

                @Override
                public String toString() {
                    if (this.isBound()) {
                        return "MultiplexedServerSocket[addr=" + String.valueOf(this.m_address.getAddress()) + ",port=" + MultiplexedSocketProvider.getBasePort(this.m_address.getPort()) + ",subport=" + MultiplexedSocketProvider.getSubPort(this.m_address.getPort()) + "]";
                    }
                    return "MultiplexedServerSocket[unbound]";
                }
            };
        }

        protected ServerSocketChannel getChannel() {
            return this;
        }

        @Override
        public ServerSocket socket() {
            return this.m_socket;
        }

        @Override
        public SocketChannel accept() throws IOException {
            if (!this.socket().isBound()) {
                throw new IOException("not bound");
            }
            try {
                long cMillis;
                BlockingQueue<SocketChannel> queue = this.m_queue;
                SocketChannel chan = this.isBlocking() ? ((cMillis = (long)this.socket().getSoTimeout()) == 0L ? queue.take() : queue.poll(cMillis, TimeUnit.MILLISECONDS)) : (SocketChannel)queue.poll();
                if (chan == null) {
                    return chan;
                }
                if (chan == SERVER_CHANNEL_CLOSED_MARKER) {
                    queue.add(SERVER_CHANNEL_CLOSED_MARKER);
                    throw new IOException("socket closed");
                }
                try {
                    chan.socket().setReceiveBufferSize(this.socket().getReceiveBufferSize());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return chan;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }

        @Override
        protected void implCloseSelectableChannel() throws IOException {
            this.socket().close();
        }

        @Override
        protected void implConfigureBlocking(boolean block) throws IOException {
        }

        @Override
        public ServerSocketChannel bind(SocketAddress local, int backlog) throws IOException {
            this.m_socket.bind(local, backlog);
            return this;
        }

        @Override
        public <T> ServerSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
            if (name == StandardSocketOptions.SO_RCVBUF) {
                this.socket().setReceiveBufferSize((Integer)value);
            } else if (name == StandardSocketOptions.SO_REUSEADDR) {
                this.socket().setReuseAddress((Boolean)value);
            } else {
                throw new UnsupportedOperationException(name.toString());
            }
            return this;
        }

        @Override
        public SocketAddress getLocalAddress() throws IOException {
            return this.socket().getLocalSocketAddress();
        }

        @Override
        public <T> T getOption(SocketOption<T> name) throws IOException {
            if (name == StandardSocketOptions.SO_RCVBUF) {
                return (T)Integer.valueOf(this.socket().getReceiveBufferSize());
            }
            if (name == StandardSocketOptions.SO_REUSEADDR) {
                return (T)Boolean.valueOf(this.socket().getReuseAddress());
            }
            throw new UnsupportedOperationException(name.toString());
        }

        @Override
        public Set<SocketOption<?>> supportedOptions() {
            return SERVER_OPTIONS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean add(SocketChannel chan) {
            BlockingQueue<SocketChannel> queue;
            BlockingQueue<SocketChannel> blockingQueue = queue = this.m_queue;
            synchronized (blockingQueue) {
                if (!this.m_fClosed && queue.offer(chan)) {
                    ServerSelectionKey key = this.m_keyHead;
                    while (key != null) {
                        MultiplexedSelector selectorMultiplexed = (MultiplexedSelector)key.selector();
                        selectorMultiplexed.addPendingKey(key);
                        selectorMultiplexed.wakeup();
                        key = key.m_next;
                    }
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SelectionKey makeKey(Selector selector) {
            ServerSelectionKey key = new ServerSelectionKey(selector);
            BlockingQueue<SocketChannel> blockingQueue = this.m_queue;
            synchronized (blockingQueue) {
                key.m_next = this.m_keyHead;
                this.m_keyHead = key;
            }
            return key;
        }

        @Override
        public int readyOps() {
            return this.m_queue.isEmpty() ? 0 : 16;
        }

        public String toString() {
            return "MultiplexedServerSocketChannel(" + String.valueOf(this.socket()) + ")";
        }

        class ServerSelectionKey
        extends SelectionKey {
            protected Selector m_selector;
            protected boolean m_fCanceled;
            protected int m_nInterest;
            protected ServerSelectionKey m_next;

            ServerSelectionKey(Selector selector) {
                this.m_selector = selector;
            }

            @Override
            public SelectableChannel channel() {
                return MultiplexedServerSocketChannel.this.getChannel();
            }

            @Override
            public Selector selector() {
                return this.m_selector;
            }

            @Override
            public boolean isValid() {
                return !this.m_fCanceled;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                this.m_fCanceled = true;
                ((MultiplexedSelector)this.m_selector).m_setCancelled.add(this);
                BlockingQueue<SocketChannel> blockingQueue = MultiplexedServerSocketChannel.this.m_queue;
                synchronized (blockingQueue) {
                    ServerSelectionKey keyLast = null;
                    ServerSelectionKey key = MultiplexedServerSocketChannel.this.m_keyHead;
                    while (key != null) {
                        if (key == this) {
                            if (keyLast == null) {
                                MultiplexedServerSocketChannel.this.m_keyHead = this.m_next;
                                break;
                            }
                            keyLast.m_next = this.m_next;
                            break;
                        }
                        keyLast = key;
                        key = key.m_next;
                    }
                }
            }

            @Override
            public int interestOps() {
                this.ensureValid();
                return this.m_nInterest;
            }

            @Override
            public SelectionKey interestOps(int ops) {
                this.ensureValid();
                if (ops == 0 || ops == 16) {
                    this.m_nInterest = ops;
                    return this;
                }
                throw new IllegalArgumentException();
            }

            @Override
            public int readyOps() {
                return 16;
            }

            protected void ensureValid() {
                if (this.m_fCanceled) {
                    throw new CancelledKeyException();
                }
            }
        }
    }

    protected static class MultiplexedSocketChannel
    extends WrapperSocketChannel
    implements MultiplexedChannel {
        protected InetSocketAddress32 m_addrPeer;
        protected InetSocketAddress32 m_addrLocal;
        protected ByteBuffer m_bufHeaderOut;
        protected ByteBuffer m_bufHeaderIn;

        public MultiplexedSocketChannel(SocketChannel delegate, SocketAddress addrLocal, ByteBuffer bufIn) {
            super(delegate, new MultiplexedSelectorProvider(delegate.provider()));
            this.m_addrLocal = addrLocal instanceof InetSocketAddress32 ? (InetSocketAddress32)addrLocal : null;
            this.m_bufHeaderIn = bufIn;
        }

        protected SocketChannel delegate() {
            return this.f_delegate;
        }

        @Override
        protected Socket wrapSocket(Socket socket) {
            return new MultiplexedSocket(socket, this);
        }

        @Override
        public boolean isConnected() {
            return super.isConnected() && this.m_bufHeaderOut == null;
        }

        @Override
        public boolean isConnectionPending() {
            return super.isConnectionPending() || this.m_bufHeaderOut != null;
        }

        @Override
        public boolean connect(SocketAddress remote) throws IOException {
            if (!(remote instanceof InetSocketAddress32)) {
                throw new IllegalArgumentException("unsupported SocketAddress type");
            }
            InetSocketAddress32 addrPeer = (InetSocketAddress32)remote;
            if (addrPeer.isUnresolved()) {
                throw new UnresolvedAddressException();
            }
            int nPort = addrPeer.getPort();
            boolean fConnected = super.connect(MultiplexedSocketProvider.getTransportAddress(addrPeer));
            this.m_addrPeer = addrPeer;
            if (MultiplexedSocketProvider.isPortExtended(nPort)) {
                ByteBuffer buf = this.m_bufHeaderOut = ByteBuffer.allocate(8);
                buf.putInt(1522655232).putInt(MultiplexedSocketProvider.getSubPort(nPort)).flip();
                return this.finishConnect();
            }
            return fConnected;
        }

        @Override
        public boolean finishConnect() throws IOException {
            ByteBuffer buf;
            boolean fResult = super.finishConnect();
            if (fResult && (buf = this.m_bufHeaderOut) != null) {
                this.delegate().write(buf);
                if (buf.hasRemaining()) {
                    LOGGER.log(Level.FINEST, "{0} physical connection established, {2} of multiplexed protocol header pending for logical connection to be established", new Object[]{this, buf.remaining()});
                    return false;
                }
                LOGGER.log(Level.FINEST, "{0} multiplexed connection established", new Object[]{this});
                this.m_bufHeaderOut = null;
            }
            return fResult;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.m_bufHeaderOut == null || this.finishConnect() ? super.write(src) : 0;
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.m_bufHeaderOut == null || this.finishConnect() ? super.write(srcs, offset, length) : 0L;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (this.m_bufHeaderIn == null) {
                return super.read(dst);
            }
            if (this.socket().isClosed()) {
                throw new ClosedChannelException();
            }
            return this.readHeader(new ByteBuffer[]{dst}, 0, 1);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            if (this.m_bufHeaderIn == null) {
                return super.read(dsts, offset, length);
            }
            if (this.socket().isClosed()) {
                throw new ClosedChannelException();
            }
            return this.readHeader(dsts, offset, length);
        }

        @Override
        protected void implCloseSelectableChannel() throws IOException {
            super.implCloseSelectableChannel();
            this.m_bufHeaderIn = null;
        }

        @Override
        public int readyOps() {
            return this.m_bufHeaderIn == null ? 0 : 1;
        }

        public String toString() {
            return "MultiplexedSocketChannel(" + String.valueOf(this.socket()) + ")";
        }

        protected int readHeader(ByteBuffer[] aBufDst, int offset, int length) {
            ByteBuffer bufIn = this.m_bufHeaderIn;
            int cbIn = bufIn.remaining();
            int cb = 0;
            for (int i = 0; i < length && cbIn > 0; ++i) {
                ByteBuffer bufOut = aBufDst[offset + i];
                int cbOut = bufOut.remaining();
                int c = Math.min(cbOut, cbIn);
                for (int j = 0; j < c; ++j) {
                    bufOut.put(bufIn.get());
                    ++cb;
                    --cbIn;
                }
            }
            if (cbIn == 0) {
                this.m_bufHeaderIn = null;
            }
            return cb;
        }

        @Override
        public WrapperSelector.WrapperSelectionKey registerInternal(WrapperSelector selector, int ops, Object att) throws IOException {
            SocketSelectionKey key = new SocketSelectionKey(selector, this.f_delegate.register(selector.getDelegate(), 0), att);
            ((WrapperSelector.WrapperSelectionKey)key).interestOps(ops);
            return key;
        }

        protected class SocketSelectionKey
        extends WrapperSelector.WrapperSelectionKey {
            protected int m_nOpsInterest;

            public SocketSelectionKey(WrapperSelector selector, SelectionKey key, Object att) {
                super(selector, key, att);
            }

            @Override
            public SelectableChannel channel() {
                return MultiplexedSocketChannel.this;
            }

            @Override
            public SelectionKey interestOps(int ops) {
                boolean fConnecting = MultiplexedSocketChannel.this.m_bufHeaderOut != null && !MultiplexedSocketChannel.this.delegate().isConnectionPending() && (ops & 8) != 0 && (ops & 4) == 0;
                super.interestOps(fConnecting ? (ops | 4) & 0xFFFFFFF7 : ops);
                this.m_nOpsInterest = ops;
                return this;
            }

            @Override
            public int interestOps() {
                return this.m_nOpsInterest;
            }

            @Override
            public int readyOps() {
                return (super.readyOps() | MultiplexedSocketChannel.this.readyOps()) & this.interestOps();
            }

            @Override
            public String toString() {
                return "MultiplexedSocketChannel{" + String.valueOf(MultiplexedSocketChannel.this.delegate()) + "}";
            }
        }
    }

    protected static class MultiplexedSocket
    extends WrapperSocket {
        protected final MultiplexedSocketChannel f_channel;
        protected final SocketChannelOutputStream f_out;
        protected final SocketChannelInputStream f_in;
        protected InetSocketAddress32 m_addrLocal;
        protected InetSocketAddress32 m_addrPeer;

        public MultiplexedSocket(Socket delegate, MultiplexedSocketChannel channel) {
            super(delegate);
            this.f_channel = channel;
            if (channel == null) {
                this.f_out = null;
                this.f_in = null;
            } else {
                this.f_out = new SocketChannelOutputStream(this.f_channel);
                this.f_in = new SocketChannelInputStream(this.f_channel);
            }
        }

        @Override
        public SocketChannel getChannel() {
            return this.f_channel;
        }

        @Override
        public void connect(SocketAddress addr) throws IOException {
            this.connect(addr, 0);
        }

        @Override
        public void connect(SocketAddress addr, int cMillis) throws IOException {
            if (!(addr instanceof InetSocketAddress32)) {
                throw new IllegalArgumentException("unsupported SocketAddress type");
            }
            InetSocketAddress32 addr32 = (InetSocketAddress32)addr;
            super.connect(MultiplexedSocketProvider.getTransportAddress(addr32), cMillis);
            this.m_addrPeer = addr32;
            if (MultiplexedSocketProvider.isPortExtended(addr32.getPort())) {
                ByteBuffer buff = ByteBuffer.allocate(8);
                buff.putInt(1522655232).putInt(MultiplexedSocketProvider.getSubPort(addr32.getPort())).flip();
                this.getOutputStream().write(buff.array());
                this.getOutputStream().flush();
            }
        }

        @Override
        public void bind(SocketAddress addr) throws IOException {
            InetSocketAddress32 addrBind;
            if (addr == null || addr instanceof InetSocketAddress32) {
                int nSub;
                addrBind = (InetSocketAddress32)addr;
                if (addrBind != null && (nSub = MultiplexedSocketProvider.getSubPort(addrBind.getPort())) != 0 && nSub != -1) {
                    throw new IOException("cannot bind client sockets to non-zero sub-ports");
                }
                if (addrBind == null) {
                    super.bind(null);
                    addrBind = new InetSocketAddress32(super.getLocalAddress(), super.getLocalPort());
                } else {
                    super.bind(MultiplexedSocketProvider.getTransportAddress(addrBind));
                }
            } else {
                throw new IllegalArgumentException("unsupported SocketAddress type");
            }
            this.m_addrLocal = addrBind;
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            InetSocketAddress32 addr = this.m_addrLocal;
            if (addr == null) {
                InetSocketAddress addrReal;
                if (this.f_channel != null) {
                    addr = this.m_addrLocal = this.f_channel.m_addrLocal;
                }
                if (addr == null && (addrReal = (InetSocketAddress)super.getLocalSocketAddress()) != null) {
                    addr = this.m_addrLocal = new InetSocketAddress32(addrReal.getAddress(), addrReal.getPort());
                }
            }
            return addr;
        }

        @Override
        public InetAddress getLocalAddress() {
            InetSocketAddress32 addr = (InetSocketAddress32)this.getLocalSocketAddress();
            return addr == null ? InetAddresses.ADDR_ANY : addr.getAddress();
        }

        @Override
        public int getLocalPort() {
            InetSocketAddress32 addr = (InetSocketAddress32)this.getLocalSocketAddress();
            return addr == null ? -1 : addr.getPort();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            InetSocketAddress32 addr = this.m_addrPeer;
            if (addr == null) {
                InetSocketAddress addrReal;
                if (this.f_channel != null) {
                    addr = this.m_addrPeer = this.f_channel.m_addrPeer;
                }
                if (addr == null && (addrReal = (InetSocketAddress)super.getRemoteSocketAddress()) != null) {
                    addr = this.m_addrPeer = new InetSocketAddress32(addrReal.getAddress(), addrReal.getPort());
                }
            }
            return addr;
        }

        @Override
        public int getPort() {
            InetSocketAddress32 addr = (InetSocketAddress32)this.getRemoteSocketAddress();
            return addr == null ? 0 : addr.getPort();
        }

        @Override
        public boolean isInputShutdown() {
            MultiplexedSocketChannel chan = this.f_channel;
            return chan == null ? super.isInputShutdown() : chan.m_bufHeaderIn == null && super.isInputShutdown();
        }

        @Override
        public void shutdownInput() throws IOException {
            super.shutdownInput();
            MultiplexedSocketChannel chan = this.f_channel;
            if (chan != null) {
                chan.m_bufHeaderIn = null;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.f_in == null ? super.getInputStream() : this.f_in;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.f_out == null ? super.getOutputStream() : this.f_out;
        }

        @Override
        public void close() throws IOException {
            super.close();
            MultiplexedSocketChannel chan = this.f_channel;
            if (chan != null) {
                chan.m_bufHeaderIn = null;
            }
        }

        @Override
        public String toString() {
            return "MultiplexedSocket{" + super.toString() + "}";
        }
    }

    public static enum WellKnownSubPorts {
        COHERENCE_TCP_RING(1),
        COHERENCE_TCMP_DATAGRAM(2),
        COHERENCE_NAME_SERVICE(3);

        private final int m_nSubPort;

        private WellKnownSubPorts(int subPort) {
            this.m_nSubPort = subPort;
        }

        public int getSubPort() {
            return this.m_nSubPort;
        }

        public int getPort(int nPortBase) {
            return MultiplexedSocketProvider.getPort(nPortBase, this.m_nSubPort);
        }
    }

    protected class Listener
    extends SafeSelectionHandler<ServerSocketChannel> {
        protected final ConcurrentNavigableMap<Integer, MultiplexedServerSocketChannel> m_mapBindings;
        protected final SortedSet<Integer> m_setEphemeral;

        public Listener(ServerSocketChannel chan) throws IOException {
            super(chan);
            this.m_mapBindings = new ConcurrentSkipListMap<Integer, MultiplexedServerSocketChannel>();
            this.m_setEphemeral = this.m_mapBindings.descendingKeySet();
        }

        @Override
        protected int onReadySafe(int nOps) throws IOException {
            SocketChannel chan;
            SelectionService svc = MultiplexedSocketProvider.this.getDependencies().getSelectionService();
            while ((chan = ((ServerSocketChannel)this.getChannel()).accept()) != null) {
                try {
                    chan.configureBlocking(false);
                    svc.register(chan, new Switcher(chan));
                }
                catch (IOException e) {
                    try {
                        chan.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return 16;
        }

        @Override
        protected int onException(Throwable t) {
            if (((ServerSocketChannel)this.getChannel()).isOpen()) {
                LogRecord rec = new LogRecord(Level.WARNING, "unhandled exception; continuing");
                rec.setThrown(t);
                MultiplexedSocketProvider.this.getDependencies().getLogger().log(rec);
                return 16;
            }
            return 0;
        }

        protected InetSocketAddress32 register(int nPortSub, MultiplexedServerSocketChannel server) throws IOException {
            ConcurrentNavigableMap<Integer, MultiplexedServerSocketChannel> map = this.m_mapBindings;
            ServerSocket socket = ((ServerSocketChannel)this.getChannel()).socket();
            if (nPortSub == 0) {
                nPortSub = 32768 + System.identityHashCode(server) % Short.MAX_VALUE;
                if (map.putIfAbsent(nPortSub, server) == null) {
                    return new InetSocketAddress32(socket.getInetAddress(), MultiplexedSocketProvider.getPort(socket.getLocalPort(), nPortSub));
                }
                nPortSub = 65535;
                Iterator iter = this.m_setEphemeral.iterator();
                while (nPortSub >= 32768) {
                    int nPortUsed = Math.max(Short.MAX_VALUE, iter.hasNext() ? (Integer)iter.next() : 0);
                    while (nPortSub > nPortUsed) {
                        if (map.putIfAbsent(nPortSub, server) == null) {
                            return new InetSocketAddress32(socket.getInetAddress(), MultiplexedSocketProvider.getPort(socket.getLocalPort(), nPortSub));
                        }
                        --nPortSub;
                    }
                    nPortSub = nPortUsed - 1;
                }
                throw new IOException("no available ephemeral sub-ports within base port " + socket.getLocalPort());
            }
            if (map.putIfAbsent(nPortSub, server) != null) {
                throw new IOException("address already in use: " + MultiplexedSocketProvider.this.getAddressString(socket) + "." + nPortSub);
            }
            return new InetSocketAddress32(socket.getInetAddress(), MultiplexedSocketProvider.getPort(socket.getLocalPort(), nPortSub));
        }

        protected boolean deregister(int nPortSub) throws IOException {
            ConcurrentNavigableMap<Integer, MultiplexedServerSocketChannel> map = this.m_mapBindings;
            if (map.remove(nPortSub) == null) {
                throw new IOException("not bound");
            }
            return map.isEmpty();
        }

        public class Switcher
        extends SafeSelectionHandler<SocketChannel> {
            protected ByteBuffer m_buf;
            protected Runnable m_timer;

            public Switcher(SocketChannel chan) {
                super(chan);
                this.m_buf = ByteBuffer.allocate(8);
            }

            @Override
            protected int onReadySafe(int nOps) throws IOException {
                ByteBuffer buf;
                final SocketChannel chan = (SocketChannel)this.getChannel();
                if (chan.read(buf = this.m_buf) < 0) {
                    this.accept();
                    return 0;
                }
                boolean fStandard = false;
                switch (buf.position()) {
                    default: {
                        fStandard |= buf.get(3) != 0;
                    }
                    case 3: {
                        fStandard |= buf.get(2) != -32;
                    }
                    case 2: {
                        fStandard |= buf.get(1) != -63;
                    }
                    case 1: {
                        fStandard |= buf.get(0) != 90;
                    }
                    case 0: 
                }
                ConcurrentNavigableMap<Integer, MultiplexedServerSocketChannel> mapBindings = Listener.this.m_mapBindings;
                if (fStandard || !buf.hasRemaining() || mapBindings.containsKey(-1) && mapBindings.size() == 1) {
                    this.accept();
                    return 0;
                }
                if (this.m_timer == null) {
                    final Dependencies deps = MultiplexedSocketProvider.this.getDependencies();
                    Runnable timer = this.m_timer = new Runnable(){

                        @Override
                        public void run() {
                            if (Switcher.this.isPending()) {
                                try {
                                    switch (chan.read(buf)) {
                                        case -1: {
                                            LOGGER.log(Level.WARNING, "{0} handling delayed close of accepted connection from {1} after {2} ms", new Object[]{((ServerSocketChannel)Listener.this.getChannel()).socket().getLocalSocketAddress(), chan.socket().getRemoteSocketAddress(), deps.getIdentificationTimeoutMillis()});
                                            break;
                                        }
                                        case 0: {
                                            LOGGER.log(Level.WARNING, "{0} failed to identify protocol from {1} bytes for connection from {2} after {3} ms, handling as non-multiplexed", new Object[]{((ServerSocketChannel)Listener.this.getChannel()).socket().getLocalSocketAddress(), buf.position(), chan.socket().getRemoteSocketAddress(), deps.getIdentificationTimeoutMillis()});
                                            break;
                                        }
                                        default: {
                                            LOGGER.log(Level.WARNING, "{0} handling delayed read on accepted connection from {1} after {2} ms", new Object[]{((ServerSocketChannel)Listener.this.getChannel()).socket().getLocalSocketAddress(), chan.socket().getRemoteSocketAddress(), deps.getIdentificationTimeoutMillis()});
                                        }
                                    }
                                    Switcher.this.accept();
                                }
                                catch (IOException e) {
                                    Switcher.this.onException(e);
                                }
                            }
                        }
                    };
                    deps.getSelectionService().invoke(chan, timer, deps.getIdentificationTimeoutMillis());
                }
                return 1;
            }

            @Override
            protected int onException(Throwable t) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LogRecord record = new LogRecord(Level.FINEST, "{0} exception while waiting for multiplexed header on {1}");
                    record.setParameters(new Object[]{((ServerSocketChannel)Listener.this.getChannel()).socket().getLocalSocketAddress(), ((SocketChannel)this.getChannel()).socket().getRemoteSocketAddress()});
                    record.setThrown(t);
                    LOGGER.log(record);
                }
                return super.onException(t);
            }

            protected void accept() throws IOException {
                int nSubPort;
                SocketChannel chan = (SocketChannel)this.getChannel();
                ByteBuffer buf = this.m_buf;
                if (!buf.hasRemaining() && buf.getInt(0) == 1522655232) {
                    nSubPort = buf.getInt(4);
                    buf = null;
                } else {
                    nSubPort = -1;
                    if (!buf.flip().hasRemaining()) {
                        buf = null;
                    }
                }
                final SelectionService svc = MultiplexedSocketProvider.this.getDependencies().getSelectionService();
                svc.register(chan, null);
                final int nFinSubPort = nSubPort;
                final ByteBuffer bufFin = buf;
                final SocketChannel chanFin = chan;
                svc.invoke(chan, new Runnable(){

                    @Override
                    public void run() {
                        SocketChannel chan = chanFin;
                        try {
                            try {
                                chan.configureBlocking(true);
                            }
                            catch (IllegalBlockingModeException e) {
                                svc.invoke(chan, this, 0L);
                                return;
                            }
                            MultiplexedServerSocketChannel server = (MultiplexedServerSocketChannel)Listener.this.m_mapBindings.get(nFinSubPort);
                            if (server != null) {
                                SocketAddress addrSrv = server.getLocalAddress();
                                InetAddress addrSrvIP = InetAddresses.getAddress(addrSrv);
                                InetAddress addrLocal = InetAddresses.isNatLocalAddress(addrSrv) ? addrSrvIP : (addrSrvIP.isAnyLocalAddress() && InetAddresses.hasNatLocalAddress() ? InetAddresses.getRoutes(InetAddresses.getLocalBindableAddresses(), Collections.singleton(chan.socket().getInetAddress())).iterator().next() : chan.socket().getLocalAddress());
                                chan = new MultiplexedSocketChannel(((MultiplexedSocketChannel)chan).delegate(), new InetSocketAddress32(addrLocal, chan.socket().getLocalPort()), bufFin);
                            }
                            if (server == null || !server.add(chan)) {
                                LogRecord record = new LogRecord(Level.FINE, "{0} rejecting connection from {1} to subport {2} due to {3}, header {4}");
                                record.setParameters(new Object[]{((ServerSocketChannel)Listener.this.getChannel()).socket().getLocalSocketAddress(), chan.socket().getRemoteSocketAddress(), nFinSubPort, server == null ? "absence of corresponding MultiplexedServerSocket" : "backlogged MultiplexedServerSocket", bufFin == null ? null : Buffers.toString(bufFin)});
                                LOGGER.log(record);
                                chan.close();
                            }
                        }
                        catch (IOException e) {
                            try {
                                chan.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }, 0L);
                this.m_buf = null;
            }

            protected boolean isPending() {
                return ((SocketChannel)this.getChannel()).isOpen() && this.m_buf != null;
            }
        }
    }

    protected class ListenChannel
    extends WrapperServerSocketChannel
    implements MultiplexedChannel {
        public ListenChannel(ServerSocketChannel delegate) throws IOException {
            super(delegate, new MultiplexedSelectorProvider(delegate.provider()));
        }

        @Override
        public SocketChannel accept() throws IOException {
            SocketChannel chan = this.f_delegate.accept();
            return chan == null ? null : new MultiplexedSocketChannel(chan, this.socket().getLocalSocketAddress(), null);
        }

        @Override
        public int readyOps() {
            return 0;
        }
    }

    protected static interface MultiplexedChannel {
        public int readyOps();
    }

    protected static class MultiplexedSelector
    extends WrapperSelector {
        protected Set<SelectionKey> m_setKeys = new HashSet<SelectionKey>();
        protected Set<SelectionKey> m_setKeysRO;
        protected Set<SelectionKey> m_setReady = new HashSet<SelectionKey>();
        protected Set<SelectionKey> m_setPending = new HashSet<SelectionKey>();
        protected Set<SelectionKey> m_setCancelled = Collections.newSetFromMap(new ConcurrentHashMap());

        protected MultiplexedSelector(Selector delegate, SelectorProvider provider) throws IOException {
            super(delegate, provider);
            this.m_setKeysRO = new UnmodifiableSetCollection<SelectionKey>(this.m_setKeys, super.keys());
        }

        @Override
        public Set<SelectionKey> keys() {
            Set<SelectionKey> setKeys = this.m_setKeysRO;
            this.ensureOpen();
            return setKeys;
        }

        @Override
        public Set<SelectionKey> selectedKeys() {
            Set<SelectionKey> setReady = this.m_setReady;
            this.ensureOpen();
            return setReady;
        }

        @Override
        public int selectNow() throws IOException {
            return this.select(-1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int select(long cMillisTimeout) throws IOException {
            Set<SelectionKey> setKeys = this.m_setKeys;
            Set<SelectionKey> setKeysRO = this.m_setKeysRO;
            Set<SelectionKey> setReady = this.m_setReady;
            Set<SelectionKey> setPend = this.m_setPending;
            Selector delegate = this.m_delegate;
            this.ensureOpen();
            Set<SelectionKey> set = setKeysRO;
            synchronized (set) {
                Set<SelectionKey> set2 = setReady;
                synchronized (set2) {
                    int cNew;
                    block19: {
                        Set<SelectionKey> set3 = setPend;
                        synchronized (set3) {
                            if (!this.m_setCancelled.isEmpty()) {
                                Iterator<SelectionKey> iter = this.m_setCancelled.iterator();
                                while (iter.hasNext()) {
                                    SelectionKey key = iter.next();
                                    setKeys.remove(key);
                                    setPend.remove(key);
                                    iter.remove();
                                }
                            }
                            cNew = this.processPendingKeys();
                        }
                        try {
                            if (cMillisTimeout >= 0L && cNew == 0) {
                                Blocking.select(delegate, cMillisTimeout);
                                set3 = setPend;
                                synchronized (set3) {
                                    cNew = this.processPendingKeys();
                                    break block19;
                                }
                            }
                            delegate.selectNow();
                        }
                        finally {
                            this.cleanupCancelledKeys();
                        }
                    }
                    Set<SelectionKey> setClient = delegate.selectedKeys();
                    for (SelectionKey key : setClient) {
                        if (!setReady.add((SelectionKey)key.attachment())) continue;
                        ++cNew;
                    }
                    setClient.clear();
                    return cNew;
                }
            }
        }

        @Override
        public int select() throws IOException {
            return this.select(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void implCloseSelector() throws IOException {
            Set<SelectionKey> setKeys = this.m_setKeys;
            Set<SelectionKey> setKeysRO = this.m_setKeysRO;
            Set<SelectionKey> setReady = this.m_setReady;
            super.implCloseSelector();
            MultiplexedSelector multiplexedSelector = this;
            synchronized (multiplexedSelector) {
                Set<SelectionKey> set = setKeysRO;
                synchronized (set) {
                    Set<SelectionKey> set2 = setReady;
                    synchronized (set2) {
                        Set<SelectionKey> set3 = setKeys;
                        synchronized (set3) {
                            Iterator<SelectionKey> iter = setKeys.iterator();
                            while (iter.hasNext()) {
                                SelectionKey key = iter.next();
                                if (key.isValid()) {
                                    key.cancel();
                                }
                                iter.remove();
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
            Set<SelectionKey> setKeys;
            Set<SelectionKey> set = setKeys = this.m_setKeys;
            synchronized (set) {
                SelectionKey key;
                if (ch instanceof MultiplexedServerSocketChannel) {
                    key = ((MultiplexedServerSocketChannel)ch).makeKey(this);
                    key.interestOps(ops);
                    key.attach(att);
                    setKeys.add(key);
                } else {
                    key = super.register(ch, ops, att);
                }
                if (((MultiplexedChannel)((Object)ch)).readyOps() != 0) {
                    this.addPendingKey(key);
                }
                return key;
            }
        }

        public String toString() {
            return "MultiplexedSelector(" + String.valueOf(this.m_delegate) + ")";
        }

        protected void ensureOpen() {
            if (!this.isOpen()) {
                throw new ClosedSelectorException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addPendingKey(SelectionKey key) {
            Set<SelectionKey> set;
            Set<SelectionKey> set2 = set = this.m_setPending;
            synchronized (set2) {
                set.add(key);
            }
        }

        protected int processPendingKeys() {
            Set<SelectionKey> setPend = this.m_setPending;
            Set<SelectionKey> setReady = this.m_setReady;
            int cNew = 0;
            if (!setPend.isEmpty()) {
                Iterator<SelectionKey> iter = setPend.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    int nOps = ((MultiplexedChannel)((Object)key.channel())).readyOps();
                    if (nOps == 0) {
                        iter.remove();
                        continue;
                    }
                    if ((key.interestOps() & nOps) == 0 || !setReady.add(key)) continue;
                    ++cNew;
                }
            }
            return cNew;
        }
    }

    protected static class MultiplexedSelectorProvider
    extends SelectorProvider {
        protected SelectorProvider m_delegate;

        public MultiplexedSelectorProvider(SelectorProvider delegate) {
            this.m_delegate = delegate;
        }

        public MultiplexedSelectorProvider(SocketProvider providerSocket) throws IOException {
            ServerSocketChannel chan = providerSocket.openServerSocketChannel();
            this.m_delegate = chan.provider();
            chan.close();
        }

        @Override
        public DatagramChannel openDatagramChannel() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DatagramChannel openDatagramChannel(ProtocolFamily family) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Pipe openPipe() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public AbstractSelector openSelector() throws IOException {
            return new MultiplexedSelector(this.m_delegate.openSelector(), this);
        }

        @Override
        public ServerSocketChannel openServerSocketChannel() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public SocketChannel openSocketChannel() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof MultiplexedSelectorProvider) {
                return this.m_delegate.equals(((MultiplexedSelectorProvider)o).m_delegate);
            }
            return false;
        }

        public int hashCode() {
            return this.m_delegate.hashCode();
        }
    }
}

