/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net;

import com.oracle.coherence.common.base.Factory;
import com.oracle.coherence.common.net.SelectionService;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MultiProviderSelectionService
implements SelectionService {
    protected Factory<? extends SelectionService> m_factory;
    protected ConcurrentMap<SelectorProvider, SelectionService> m_mapServices = new ConcurrentHashMap<SelectorProvider, SelectionService>();

    public MultiProviderSelectionService(Factory<? extends SelectionService> factory) {
        this.m_factory = factory;
    }

    @Override
    public void register(SelectableChannel chan, SelectionService.Handler handler) throws IOException {
        this.getSelectionService(chan).register(chan, handler);
    }

    @Override
    public void invoke(SelectableChannel chan, Runnable runnable, long cMillis) throws IOException {
        this.getSelectionService(chan).invoke(chan, runnable, cMillis);
    }

    @Override
    public void associate(SelectableChannel chanParent, SelectableChannel chanChild) throws IOException {
        if (chanParent != null && chanParent.provider() != chanChild.provider()) {
            throw new IllegalArgumentException("parent and child must use the same SelectorProvider");
        }
        this.getSelectionService(chanChild).associate(chanParent, chanChild);
    }

    @Override
    public void shutdown() {
        ConcurrentMap<SelectorProvider, SelectionService> map = this.m_mapServices;
        this.m_mapServices = null;
        for (SelectionService svc : map.values()) {
            svc.shutdown();
        }
    }

    protected SelectionService getSelectionService(SelectableChannel chan) {
        ConcurrentMap<SelectorProvider, SelectionService> map = this.m_mapServices;
        if (map == null) {
            throw new IllegalStateException("the service has been shutdown");
        }
        if (chan == null) {
            throw new IllegalArgumentException("null channel");
        }
        SelectorProvider provider = chan.provider();
        SelectionService svc = (SelectionService)map.get(provider);
        if (svc == null) {
            SelectionService svcNew = this.m_factory.create();
            svc = map.putIfAbsent(provider, svcNew);
            if (svc == null) {
                svc = svcNew;
            } else {
                svcNew.shutdown();
            }
        }
        return svc;
    }
}

