/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.io;

import com.oracle.coherence.common.collections.WeakIdentityHashMap;
import com.oracle.coherence.common.internal.io.SegmentedBufferManager;
import com.oracle.coherence.common.io.BufferManagers;
import com.oracle.coherence.common.util.SafeClock;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.logging.Level;

public class SlabBufferManager
extends SegmentedBufferManager {
    public SlabBufferManager(SegmentedBufferManager.BufferAllocator allocator, int cbBufferMin, long cbMax) {
        super(allocator, cbBufferMin, cbMax);
    }

    public SlabBufferManager(SegmentedBufferManager.BufferAllocator allocator, long cbMax) {
        super(allocator, cbMax);
    }

    public SlabBufferManager(SegmentedBufferManager.BufferAllocator allocator, int cSegments, long cbSegment, int cbBufferMin, int nGrowthFactor) {
        super(allocator, cSegments, cbSegment, cbBufferMin, nGrowthFactor);
    }

    @Override
    protected SegmentedBufferManager.Segment allocateSegment(int cbBuffer, int cBuffers) {
        return new SlabSegment(cbBuffer, cBuffers);
    }

    protected class SlabSegment
    extends SegmentedBufferManager.Segment {
        protected final Slab[] f_aSlabs;
        protected final Map<ByteBuffer, Slab> f_mapBufSlabUnpooled;
        protected Slab m_slabUnpooledHead;
        protected Slab m_slabUnpooledTail;
        protected final AtomicLong f_cReclaimed;
        private volatile GcTracker[] m_aGcInfo;
        private volatile boolean m_fShrinkable;
        private long m_ldtShrinkableEval;

        protected SlabSegment(int cbBuffer, int cBuffers) {
            super(SlabBufferManager.this, cbBuffer, cBuffers);
            this.f_aSlabs = new Slab[15];
            this.f_mapBufSlabUnpooled = new WeakIdentityHashMap<ByteBuffer, Slab>();
            this.f_cReclaimed = new AtomicLong();
            int c = this.f_aSlabs.length;
            for (int i = 0; i < c; ++i) {
                this.f_aSlabs[i] = this.instantiateSlab(this.encodeGeneration(i));
            }
        }

        @Override
        protected int getAcquired() {
            return Math.max(0, super.getAcquired() - (int)this.f_cReclaimed.get());
        }

        @Override
        protected boolean allocateGenerationBuffers(int nGen, int cbBuffer) {
            for (int i = 0; i < nGen; ++i) {
                if (!this.f_aSlabs[i].ensure()) continue;
                this.f_cReclaimed.addAndGet(this.getGenerationSize());
                SegmentedBufferManager.LOGGER.log(Level.WARNING, SlabBufferManager.this.getName() + " replenished leaked segment '" + this.getBufferSize() + "' slab for generation " + i + "; set the com.oracle.common.io.BufferManagers.checked system property to true to help identify leak suspects");
            }
            Slab slab = this.f_aSlabs[nGen];
            if (!slab.ensure()) {
                SegmentedBufferManager.LOGGER.log(Level.FINE, SlabBufferManager.this.getName() + " reviving segment '" + this.getBufferSize() + "' slab for generation " + nGen);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ByteBuffer allocateNonPooledBuffer() {
            Map<ByteBuffer, Slab> map = this.f_mapBufSlabUnpooled;
            synchronized (map) {
                Slab slab = this.m_slabUnpooledHead;
                while (slab != null) {
                    Slab slabPrev = slab.m_slabPrev;
                    if (slab.isLeaked()) {
                        this.removeSlabFromList(slab);
                        if (!slab.f_afOutstanding.isEmpty()) {
                            SegmentedBufferManager.LOGGER.log(Level.WARNING, SlabBufferManager.this.getName() + " detected leaked segment '" + this.getBufferSize() + "' slab for generation 15; " + slab.f_afOutstanding.cardinality() + " of " + this.f_cBufferGen + " buffers were leaked; set the com.oracle.common.io.BufferManagers.checked system property to true to help identify leak suspects");
                        }
                    }
                    slab = slabPrev;
                }
                ByteBuffer buff = null;
                do {
                    Slab slabRevive;
                    if ((slabRevive = this.m_slabUnpooledHead) != null) {
                        if (!slabRevive.ensure()) {
                            SegmentedBufferManager.LOGGER.log(Level.FINE, SlabBufferManager.this.getName() + " reviving segment '" + this.getBufferSize() + "' slab for generation 15");
                        }
                        if ((buff = (ByteBuffer)this.f_stackBuf.pop()) != null) {
                            return buff;
                        }
                    }
                    this.f_cNonPooledAllocations.incrementAndGet();
                    this.instantiateSlab(this.f_cbUnpooledBuffer).ensure();
                    SegmentedBufferManager.LOGGER.log(Level.FINE, SlabBufferManager.this.getName() + " allocating unpooled slab for segment '" + this.getBufferSize());
                } while ((buff = (ByteBuffer)this.f_stackBuf.pop()) == null);
                return buff;
            }
        }

        @Override
        protected boolean isShrinkable() {
            long ldtNow = SafeClock.INSTANCE.getSafeTimeMillis();
            if (this.m_ldtShrinkableEval < ldtNow - SegmentedBufferManager.CLEANUP_FREQUENCY_MILLIS) {
                this.m_ldtShrinkableEval = ldtNow;
                GcTracker[] aInfo = this.m_aGcInfo;
                if (aInfo != null) {
                    for (GcTracker info : aInfo) {
                        if (info == null || info.hasGCd()) continue;
                        this.m_fShrinkable = false;
                        return false;
                    }
                }
                this.m_fShrinkable = true;
                return true;
            }
            return this.m_fShrinkable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dropBuffer(ByteBuffer buffer) {
            int nGen = SlabBufferManager.this.decodeGeneration(buffer.capacity());
            if (nGen == 15) {
                Map<ByteBuffer, Slab> map = this.f_mapBufSlabUnpooled;
                synchronized (map) {
                    Slab slab = this.f_mapBufSlabUnpooled.remove(buffer);
                    if (slab == null) {
                        SegmentedBufferManager.LOGGER.log(Level.WARNING, SlabBufferManager.this.getName() + " detected release of unknown ByteBuffer for segment '" + this.getBufferSize() + "' generation " + nGen + "; set the com.oracle.common.io.BufferManagers.checked system property to true to help identify suspects");
                    } else if (slab.releaseSlice(buffer)) {
                        this.f_cNonPooledAllocations.decrementAndGet();
                    }
                }
            } else {
                this.f_aSlabs[nGen].releaseSlice(buffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            int cUnpooledSlabs;
            Map<ByteBuffer, Slab> map = this.f_mapBufSlabUnpooled;
            synchronized (map) {
                cUnpooledSlabs = new HashSet<Slab>(this.f_mapBufSlabUnpooled.values()).size();
            }
            return super.toString() + "/" + (this.f_cGeneration.get() + 1 + cUnpooledSlabs);
        }

        protected void removeSlabFromList(Slab slabToRemove) {
            Slab slabNext = slabToRemove.m_slabNext;
            Slab slabPrev = slabToRemove.m_slabPrev;
            if (slabNext == null) {
                this.m_slabUnpooledHead = slabPrev;
            } else {
                slabNext.m_slabPrev = slabPrev;
            }
            if (slabPrev == null) {
                this.m_slabUnpooledTail = slabNext;
            } else {
                slabPrev.m_slabNext = slabNext;
            }
            slabToRemove.m_slabPrev = null;
            slabToRemove.m_slabNext = null;
        }

        protected Slab instantiateSlab(int cbBuffer) {
            return new Slab(cbBuffer);
        }

        protected class Slab
        implements Comparable<Slab> {
            protected final int f_cbSlice;
            protected final BitSet f_afOutstanding;
            protected WeakReference<ByteBuffer> m_weakBuf;
            protected Slab m_slabNext;
            protected Slab m_slabPrev;

            public Slab(int cbBuffer) {
                this.f_afOutstanding = new BitSet(SlabSegment.this.getGenerationSize());
                this.f_cbSlice = cbBuffer;
            }

            public String toString() {
                return "Slab " + System.identityHashCode(this) + ", bufSize " + this.f_cbSlice + ", leaked " + this.isLeaked() + ", outstanding " + this.f_afOutstanding.cardinality() + "/" + SlabSegment.this.getGenerationSize();
            }

            public synchronized boolean isLeaked() {
                return this.m_weakBuf == null || this.m_weakBuf.get() == null;
            }

            public ByteBuffer getSlabBuffer() {
                WeakReference<ByteBuffer> weakBuf = this.m_weakBuf;
                return weakBuf == null ? null : (ByteBuffer)this.m_weakBuf.get();
            }

            public synchronized boolean releaseSlice(ByteBuffer buffer) {
                ByteBuffer bufSlab = this.getSlabBuffer();
                int nPosition = this.getSlicePosition(buffer);
                if (nPosition >= 0 && this.f_afOutstanding.get(nPosition) && bufSlab != null) {
                    Slab slabNext;
                    this.f_afOutstanding.clear(nPosition);
                    if (this.f_afOutstanding.isEmpty()) {
                        SegmentedBufferManager.LOGGER.log(Level.FINE, SlabBufferManager.this.getName() + " releasing segment '" + SlabSegment.this.getBufferSize() + "' slab for generation " + SlabBufferManager.this.decodeGeneration(this.f_cbSlice));
                        SlabBufferManager.this.getAllocator().release(bufSlab);
                        this.m_weakBuf.clear();
                        this.m_weakBuf = null;
                        if (this.f_cbSlice == SlabSegment.this.f_cbUnpooledBuffer) {
                            SlabSegment.this.removeSlabFromList(this);
                        }
                        return true;
                    }
                    if (this.f_cbSlice == SlabSegment.this.f_cbUnpooledBuffer && (slabNext = this.m_slabNext) != null && this.compareTo(slabNext) < 0) {
                        Slab slabPrev = this.m_slabPrev;
                        this.m_slabNext = slabNext.m_slabNext;
                        if (this.m_slabNext != null) {
                            this.m_slabNext.m_slabPrev = this;
                        }
                        slabNext.m_slabPrev = slabPrev;
                        slabNext.m_slabNext = this;
                        this.m_slabPrev = slabNext;
                        if (slabPrev == null) {
                            SlabSegment.this.m_slabUnpooledTail = slabNext;
                        } else {
                            slabPrev.m_slabNext = slabNext;
                        }
                        if (SlabSegment.this.m_slabUnpooledHead == slabNext) {
                            SlabSegment.this.m_slabUnpooledHead = this;
                        }
                    }
                } else {
                    SegmentedBufferManager.LOGGER.log(Level.WARNING, SlabBufferManager.this.getName() + " double release of '" + SlabSegment.this.getBufferSize() + "' buffer in generation " + SlabBufferManager.this.decodeGeneration(this.f_cbSlice) + "; set the com.oracle.common.io.BufferManagers.checked system property to true to help identify suspects");
                }
                return false;
            }

            public synchronized boolean ensure() {
                boolean fAlloc;
                int cBufGen = SlabSegment.this.getGenerationSize();
                ByteBuffer bufSlab = this.getSlabBuffer();
                boolean bl = fAlloc = bufSlab == null;
                if (fAlloc) {
                    bufSlab = SlabBufferManager.this.getAllocator().allocate(this.f_cbSlice * cBufGen);
                    this.m_weakBuf = new WeakReference<ByteBuffer>(bufSlab);
                    this.f_afOutstanding.clear();
                    List<GarbageCollectorMXBean> listGc = ManagementFactory.getGarbageCollectorMXBeans();
                    GarbageCollectorMXBean[] aGc = listGc.toArray(new GarbageCollectorMXBean[listGc.size()]);
                    GcTracker[] aInfo = new GcTracker[aGc.length];
                    for (int i = 0; i < aGc.length && aGc[i] != null; ++i) {
                        aInfo[i] = new GcTracker(aGc[i]);
                    }
                    SlabSegment.this.m_aGcInfo = aInfo;
                } else if (this.f_afOutstanding.cardinality() == cBufGen) {
                    return false;
                }
                if (this.f_cbSlice == SlabSegment.this.f_cbUnpooledBuffer) {
                    Slab slabNext = this.m_slabNext;
                    Slab slabPrev = this.m_slabPrev;
                    if (slabNext != null) {
                        slabNext.m_slabPrev = slabPrev;
                    } else if (SlabSegment.this.m_slabUnpooledHead == this) {
                        SlabSegment.this.m_slabUnpooledHead = slabPrev;
                    }
                    if (slabPrev != null) {
                        slabPrev.m_slabNext = slabNext;
                    } else if (SlabSegment.this.m_slabUnpooledTail == this) {
                        SlabSegment.this.m_slabUnpooledTail = slabNext;
                    }
                    Slab slabTail = SlabSegment.this.m_slabUnpooledTail;
                    SlabSegment.this.m_slabUnpooledTail = this;
                    this.m_slabNext = slabTail;
                    this.m_slabPrev = null;
                    if (slabTail == null) {
                        SlabSegment.this.m_slabUnpooledHead = this;
                    } else {
                        slabTail.m_slabPrev = this;
                    }
                }
                int i = this.f_afOutstanding.nextClearBit(0);
                while (i < cBufGen) {
                    int ofStart = i * this.f_cbSlice;
                    int ofEnd = ofStart + this.f_cbSlice;
                    bufSlab.limit(ofEnd).position(ofStart);
                    ByteBuffer bufSlice = bufSlab.slice();
                    if (this.f_cbSlice == SlabSegment.this.f_cbUnpooledBuffer) {
                        SlabSegment.this.f_mapBufSlabUnpooled.put(bufSlice, this);
                    }
                    this.f_afOutstanding.set(i);
                    SlabSegment.this.f_stackBuf.push(bufSlice);
                    i = this.f_afOutstanding.nextClearBit(i);
                }
                bufSlab.clear();
                return fAlloc;
            }

            protected synchronized int getSlicePosition(ByteBuffer buffSlice) {
                ByteBuffer buffSlab = this.getSlabBuffer();
                if (buffSlab == null) {
                    return -1;
                }
                if (buffSlice.hasArray() && buffSlab.hasArray()) {
                    return buffSlice.array() == buffSlab.array() ? buffSlice.arrayOffset() / buffSlice.capacity() : -1;
                }
                if (buffSlice.isDirect()) {
                    long lRand;
                    int cbSlice = buffSlice.capacity();
                    ThreadLocalRandom tlRandom = ThreadLocalRandom.current();
                    long lThreadId = Thread.currentThread().getId();
                    while ((lRand = tlRandom.nextLong()) == 0L) {
                    }
                    buffSlice.putLong(0, lRand);
                    int nPosition = this.f_afOutstanding.nextSetBit(0);
                    while (nPosition >= 0) {
                        int ofSlab = nPosition * cbSlice;
                        if (buffSlab.getLong(ofSlab) == lRand) {
                            long lUnique = (long)nPosition << 32 | lThreadId;
                            buffSlice.putLong(0, lUnique);
                            if (buffSlab.getLong(ofSlab) == lUnique) {
                                if (BufferManagers.ZERO_ON_RELEASE) {
                                    buffSlice.putLong(0, 0L);
                                }
                                return nPosition;
                            }
                            buffSlice.putLong(0, lRand);
                        }
                        nPosition = this.f_afOutstanding.nextSetBit(nPosition + 1);
                    }
                    return -1;
                }
                throw new IllegalStateException();
            }

            @Override
            public int compareTo(Slab that) {
                return this.f_afOutstanding.cardinality() - that.f_afOutstanding.cardinality();
            }
        }

        protected class GcTracker {
            private final long f_cGcLast;
            private final GarbageCollectorMXBean f_bean;

            GcTracker(GarbageCollectorMXBean bean) {
                this.f_cGcLast = bean.getCollectionCount();
                this.f_bean = bean;
            }

            public boolean hasGCd() {
                return this.f_cGcLast != this.f_bean.getCollectionCount();
            }
        }
    }

    public static class DirectBufferAllocator
    implements SegmentedBufferManager.BufferAllocator {
        private static final Consumer<ByteBuffer> VOID_CLEANER = bb -> {};
        private static final Consumer<ByteBuffer> REFLECTION_CLEANER = new Consumer<ByteBuffer>(){
            private Method m_methCleaner;
            private Method m_methClean;

            @Override
            public void accept(ByteBuffer buff) {
                try {
                    Object oCleaner;
                    Method methClean = this.m_methClean;
                    if (methClean == null) {
                        Method methCleaner = this.m_methCleaner = buff.getClass().getDeclaredMethod("cleaner", null);
                        methCleaner.setAccessible(true);
                        oCleaner = methCleaner.invoke((Object)buff, new Object[0]);
                        this.m_methClean = methClean = oCleaner.getClass().getDeclaredMethod("clean", null);
                    } else {
                        oCleaner = this.m_methCleaner.invoke((Object)buff, new Object[0]);
                    }
                    methClean.invoke(oCleaner, null);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    this.m_methClean = null;
                    this.m_methCleaner = null;
                    throw new RuntimeException(e);
                }
            }
        };
        private static Consumer<ByteBuffer> m_cleaner;

        @Override
        public ByteBuffer allocate(int cb) {
            return ByteBuffer.allocateDirect(cb);
        }

        @Override
        public void release(ByteBuffer buff) {
            if (!buff.isDirect()) {
                throw new IllegalArgumentException();
            }
            DirectBufferAllocator.clean(buff);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        protected static void clean(ByteBuffer buff) {
            Consumer<ByteBuffer> consumerClean = m_cleaner;
            if (consumerClean == null) {
                Class<DirectBufferAllocator> clazz = DirectBufferAllocator.class;
                // MONITORENTER : com.oracle.coherence.common.internal.io.SlabBufferManager$DirectBufferAllocator.class
                consumerClean = m_cleaner;
                if (consumerClean == null) {
                    Consumer<ByteBuffer> consumerTmp = REFLECTION_CLEANER;
                    try {
                        consumerTmp.accept(buff);
                    }
                    catch (Throwable t) {
                        consumerTmp = VOID_CLEANER;
                    }
                    finally {
                        m_cleaner = consumerTmp;
                    }
                }
                // MONITOREXIT : clazz
            }
            if (consumerClean == null) return;
            consumerClean.accept(buff);
        }
    }
}

