/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.continuations;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.internal.continuations.Continuations;
import com.oracle.coherence.common.internal.continuations.WrapperContinuation;

public abstract class AbstractContinuationFrame<R>
implements Runnable {
    private Continuation<? super Throwable> m_continuationFail;
    private Continuation<? super R> m_continuation;

    public AbstractContinuationFrame(Continuation<? super Void> continuationFinally) {
        this(null, continuationFinally, null);
    }

    public AbstractContinuationFrame(Continuation<? super Throwable> continuationFail, Continuation<? super R> continuation) {
        this(continuationFail, null, continuation);
    }

    public AbstractContinuationFrame(AbstractContinuationFrame<? super R> that) {
        this(that.getFailureContinuation(), that.getContinuation());
    }

    public AbstractContinuationFrame(Continuation<? super Throwable> continuationFail, final Continuation<? super Void> continuationFinally, Continuation<? super R> continuation) {
        if (continuationFinally != null) {
            continuationFail = new WrapperContinuation<Throwable>(continuationFail){

                @Override
                public void proceed(Throwable e) {
                    try {
                        super.proceed(e);
                    }
                    finally {
                        Continuations.proceed(continuationFinally, null);
                    }
                }
            };
            continuation = new WrapperContinuation<R>(continuation){

                @Override
                public void proceed(R result) {
                    try {
                        Continuations.proceed(continuationFinally, null);
                    }
                    finally {
                        super.proceed(result);
                    }
                }
            };
        }
        this.m_continuationFail = continuationFail;
        this.m_continuation = continuation;
    }

    @Override
    public final void run() {
        try {
            R result = this.call();
            this.m_continuationFail = null;
            Continuations.proceed(this.m_continuation, result);
        }
        catch (Throwable e) {
            Continuations.proceed(this.m_continuationFail, e);
        }
    }

    protected abstract R call() throws Exception;

    protected Continuation<? super R> getContinuation() {
        return this.m_continuation;
    }

    protected Continuation<? super Throwable> getFailureContinuation() {
        return this.m_continuationFail;
    }

    protected R continueAsync() {
        this.m_continuationFail = null;
        this.m_continuation = null;
        return null;
    }
}

