/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;

public class Platform {
    private final boolean f_fExaEnabled;
    private final int f_cProcFair;
    private static Platform INSTANCE = new Platform();

    private Platform() {
        boolean fExa = false;
        try {
            fExa = new File("/opt/exalogic").exists() || new File("/opt/exalogic-java").exists();
        }
        catch (SecurityException e) {
            try {
                fExa = Class.forName("com.oracle.exalogic.ExaManager") != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.f_fExaEnabled = Boolean.parseBoolean(System.getProperty("com.oracle.exa", fExa ? "true" : "false")) || Boolean.parseBoolean(System.getProperty("com.oracle.exalogic")) || Boolean.parseBoolean(System.getProperty("com.oracle.exadata")) || Boolean.parseBoolean(System.getProperty("com.oracle.ssc"));
        int cProcFair = Math.max(1, (int)Math.ceil((double)Runtime.getRuntime().availableProcessors() * Math.min(1.0, (double)Runtime.getRuntime().maxMemory() / (double)this.getTotalPhysicalMemorySize())));
        this.f_cProcFair = Integer.parseInt(System.getProperty(Platform.class.getName() + ".fairShareProcessors", String.valueOf(cProcFair)));
    }

    public static Platform getPlatform() {
        return INSTANCE;
    }

    public final boolean isExaEnabled() {
        return this.f_fExaEnabled;
    }

    public long getTotalPhysicalMemorySize() {
        try {
            return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
        }
        catch (Throwable e) {
            return Runtime.getRuntime().maxMemory();
        }
    }

    public int getFairShareProcessors() {
        return this.f_cProcFair;
    }
}

