/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.collections;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakIdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    int modCount;
    static final int ALTERNATIVE_HASHING_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    transient boolean useAltHashing;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;
    protected transient Set<K> keySet;
    protected transient Collection<V> values;

    private Entry<K, V>[] newTable(int n) {
        return new Entry[n];
    }

    public WeakIdentityHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.table = this.newTable(capacity);
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.useAltHashing = capacity >= Integer.MAX_VALUE;
    }

    public WeakIdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakIdentityHashMap() {
        this(16, 0.75f);
    }

    public WeakIdentityHashMap(Map<? extends K, ? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(m);
    }

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    private static boolean eq(Object x, Object y) {
        return x == y;
    }

    static int hash(Object k) {
        int h = System.identityHashCode(k);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<Object> x;
        while ((x = this.queue.poll()) != null) {
            ReferenceQueue<Object> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                Entry<K, V> prev;
                Entry e = (Entry)x;
                int i = WeakIdentityHashMap.indexFor(e.hash, this.table.length);
                Entry<K, V> p = prev = this.table[i];
                while (p != null) {
                    Entry next = p.next;
                    if (p == e) {
                        if (prev == e) {
                            this.table[i] = next;
                        } else {
                            prev.next = next;
                        }
                        e.value = null;
                        --this.size;
                        break;
                    }
                    prev = p;
                    p = next;
                }
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object key) {
        Object k = WeakIdentityHashMap.maskNull(key);
        int h = WeakIdentityHashMap.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int index = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == h && WeakIdentityHashMap.eq(k, e.get())) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    Entry<K, V> getEntry(Object key) {
        Object k = WeakIdentityHashMap.maskNull(key);
        int h = WeakIdentityHashMap.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int index = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry<K, V> e = tab[index];
        while (!(e == null || e.hash == h && WeakIdentityHashMap.eq(k, e.get()))) {
            e = e.next;
        }
        return e;
    }

    @Override
    public V put(K key, V value) {
        Object k = WeakIdentityHashMap.maskNull(key);
        int h = WeakIdentityHashMap.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int i = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry<K, V> e = tab[i];
        while (e != null) {
            if (h == e.hash && WeakIdentityHashMap.eq(k, e.get())) {
                Object oldValue = e.value;
                if (value != oldValue) {
                    e.value = value;
                }
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        e = tab[i];
        tab[i] = new Entry<K, V>(k, value, this.queue, h, e);
        if (++this.size >= this.threshold) {
            this.resize(tab.length * 2);
        }
        return null;
    }

    void resize(int newCapacity) {
        Entry<K, V>[] oldTable = this.getTable();
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry<K, V>[] newTable = this.newTable(newCapacity);
        boolean oldAltHashing = this.useAltHashing;
        this.useAltHashing |= newCapacity >= Integer.MAX_VALUE;
        boolean rehash = oldAltHashing ^ this.useAltHashing;
        this.transfer(oldTable, newTable, rehash);
        this.table = newTable;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable, false);
            this.table = oldTable;
        }
    }

    private void transfer(Entry<K, V>[] src, Entry<K, V>[] dest, boolean rehash) {
        for (int j = 0; j < src.length; ++j) {
            Entry<K, V> e = src[j];
            src[j] = null;
            while (e != null) {
                Entry next = e.next;
                Object key = e.get();
                if (key == null) {
                    e.next = null;
                    e.value = null;
                    --this.size;
                } else {
                    if (rehash) {
                        e.hash = WeakIdentityHashMap.hash(key);
                    }
                    int i = WeakIdentityHashMap.indexFor(e.hash, dest.length);
                    e.next = dest[i];
                    dest[i] = e;
                }
                e = next;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> prev;
        Object k = WeakIdentityHashMap.maskNull(key);
        int h = WeakIdentityHashMap.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int i = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry<K, V> e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == e.hash && WeakIdentityHashMap.eq(k, e.get())) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    boolean removeMapping(Object o) {
        Entry<K, V> prev;
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Entry<K, V>[] tab = this.getTable();
        Map.Entry entry = (Map.Entry)o;
        Object k = WeakIdentityHashMap.maskNull(entry.getKey());
        int h = WeakIdentityHashMap.hash(k);
        int i = WeakIdentityHashMap.indexFor(h, tab.length);
        Entry<K, V> e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == e.hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return true;
            }
            prev = e;
            e = next;
        }
        return false;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private static class Entry<K, V>
    extends WeakReference<Object>
    implements Map.Entry<K, V> {
        V value;
        int hash;
        Entry<K, V> next;

        Entry(Object key, V value, ReferenceQueue<Object> queue, int hash, Entry<K, V> next) {
            super(key, queue);
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)WeakIdentityHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return k1 == (k2 = e.getKey()) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return (k == null ? 0 : WeakIdentityHashMap.hash(k)) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
        }
    }

    private static class Holder {
        static final int ALTERNATIVE_HASHING_THRESHOLD = Integer.MAX_VALUE;

        private Holder() {
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakIdentityHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (WeakIdentityHashMap.this.containsKey(o)) {
                WeakIdentityHashMap.this.remove(o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakIdentityHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = WeakIdentityHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return WeakIdentityHashMap.this.removeMapping(o);
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        private List<Map.Entry<K, V>> deepCopy() {
            ArrayList list = new ArrayList(this.size());
            for (Map.Entry e : this) {
                list.add(new AbstractMap.SimpleEntry(e));
            }
            return list;
        }

        @Override
        public Object[] toArray() {
            return this.deepCopy().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.deepCopy().toArray(a);
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        private int index;
        private Entry<K, V> entry = null;
        private Entry<K, V> lastReturned = null;
        private int expectedModCount;
        private Object nextKey;
        private Object currentKey;

        HashIterator() {
            this.expectedModCount = WeakIdentityHashMap.this.modCount;
            this.nextKey = null;
            this.currentKey = null;
            this.index = WeakIdentityHashMap.this.isEmpty() ? 0 : WeakIdentityHashMap.this.table.length;
        }

        @Override
        public boolean hasNext() {
            Entry<K, V>[] t = WeakIdentityHashMap.this.table;
            while (this.nextKey == null) {
                Entry e = this.entry;
                int i = this.index;
                while (e == null && i > 0) {
                    e = t[--i];
                }
                this.entry = e;
                this.index = i;
                if (e == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = e.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakIdentityHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakIdentityHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }
}

