/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.collections;

import com.oracle.coherence.common.base.Collector;
import com.oracle.coherence.common.base.Notifier;
import com.oracle.coherence.common.base.SingleWaiterCooperativeNotifier;
import com.oracle.coherence.common.collections.ConcurrentLinkedQueue;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class SingleConsumerBlockingQueue<V>
extends ConcurrentLinkedQueue<V>
implements BlockingQueue<V> {
    protected final Notifier f_notifier = new SingleWaiterCooperativeNotifier();
    protected final Collector<V> f_collector = new Collector<V>(){

        @Override
        public void add(V value) {
            SingleConsumerBlockingQueue.super.offer(value);
        }

        @Override
        public void flush() {
            SingleConsumerBlockingQueue.this.f_notifier.signal();
            SingleWaiterCooperativeNotifier.flush();
        }
    };
    protected final Collector<V> f_collectorCooperative = new Collector<V>(){

        @Override
        public void add(V value) {
            SingleConsumerBlockingQueue.super.offer(value);
            SingleConsumerBlockingQueue.this.f_notifier.signal();
        }

        @Override
        public void flush() {
            SingleWaiterCooperativeNotifier.flush();
        }
    };

    public Collector<V> getCollector() {
        return this.f_collector;
    }

    public Collector<V> getCooperativeCollector() {
        return this.f_collectorCooperative;
    }

    @Override
    public boolean add(V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        super.add(value);
        this.f_collector.flush();
        return true;
    }

    @Override
    public boolean offer(V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        super.offer(value);
        this.f_collector.flush();
        return true;
    }

    @Override
    public void put(V value) throws InterruptedException {
        this.add(value);
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.add(e);
    }

    @Override
    public V take() throws InterruptedException {
        Object value;
        while ((value = this.poll()) == null) {
            this.f_notifier.await();
        }
        return (V)value;
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object e = this.poll();
        if (e == null) {
            this.f_notifier.await(unit.toMillis(timeout));
            e = this.poll();
        }
        return (V)e;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        Object value;
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int cV = 0;
        while ((value = this.poll()) != null) {
            c.add(value);
            ++cV;
        }
        return cV;
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        Object value;
        int cV;
        if (c == this) {
            throw new IllegalArgumentException();
        }
        for (cV = 0; cV < maxElements && (value = this.poll()) != null; ++cV) {
            c.add(value);
        }
        return cV;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        if (c.contains(null)) {
            throw new NullPointerException();
        }
        super.addAll(c);
        this.f_collector.flush();
        return false;
    }
}

