/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.collections;

import com.oracle.coherence.common.base.Predicate;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PredicateIterator<T>
implements Iterator<T> {
    protected Iterator<T> m_iter;
    protected Predicate<T> m_test;
    protected boolean m_fNext;
    protected boolean m_fPrev;
    protected T m_next;

    public PredicateIterator(Iterator<T> iter, Predicate<T> test) {
        this.m_iter = iter;
        this.m_test = test;
        this.m_fNext = false;
    }

    @Override
    public boolean hasNext() {
        boolean fNext = this.m_fNext;
        if (fNext) {
            return true;
        }
        Iterator<T> iter = this.m_iter;
        Predicate<T> test = this.m_test;
        while (iter.hasNext()) {
            T next = iter.next();
            if (!test.evaluate(next)) continue;
            this.m_next = next;
            fNext = true;
            break;
        }
        this.m_fPrev = false;
        this.m_fNext = fNext;
        return fNext;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            this.m_fNext = false;
            this.m_fPrev = true;
            return this.m_next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (!this.m_fPrev) {
            throw new IllegalStateException();
        }
        this.m_fPrev = false;
        this.m_iter.remove();
    }
}

