/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.collections;

import com.oracle.coherence.common.base.Nullable;
import com.oracle.coherence.common.base.SimpleHolder;
import com.oracle.coherence.common.collections.NullableConcurrentMap;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObservableNullableConcurrentMap<K, V>
extends NullableConcurrentMap<K, V>
implements ObservableMap<K, V> {
    protected final transient MapListenerSupport f_listenerSupport = new MapListenerSupport();

    public ObservableNullableConcurrentMap() {
    }

    public ObservableNullableConcurrentMap(int cInitialCapacity) {
        super(cInitialCapacity);
    }

    public ObservableNullableConcurrentMap(int cInitialCapacity, float flLoadFactor) {
        super(cInitialCapacity, flLoadFactor);
    }

    public ObservableNullableConcurrentMap(Map<? extends K, ? extends V> map) {
        super(map);
    }

    @Override
    public V put(K key, V value) {
        SimpleHolder result = new SimpleHolder();
        this.getMap().compute(Nullable.of(key), (k, v) -> {
            Object valueOld = Nullable.get(v);
            result.set(valueOld);
            this.dispatchEvent(() -> new MapEvent(this, v == null ? 1 : 2, k.get(), valueOld, value));
            return Nullable.of(value);
        });
        return result.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (this.f_listenerSupport == null) {
            super.putAll(map);
        } else {
            for (Map.Entry<K, V> e : map.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        SimpleHolder<Boolean> fInserted = new SimpleHolder<Boolean>(false);
        Nullable result = this.getMap().computeIfAbsent(Nullable.of(key), k -> {
            fInserted.set(true);
            this.dispatchEvent(() -> new MapEvent<Object, Object>(this, 1, key, null, value));
            return Nullable.of(value);
        });
        return (Boolean)fInserted.get() != false ? null : (V)result.get();
    }

    @Override
    public V remove(Object oKey) {
        SimpleHolder result = new SimpleHolder();
        this.getMap().compute(Nullable.of(oKey), (k, v) -> {
            result.set(Nullable.get(v));
            if (v != null) {
                this.dispatchEvent(() -> new MapEvent(this, 3, k.get(), v.get(), null));
            }
            return null;
        });
        return result.get();
    }

    @Override
    public boolean remove(Object key, Object value) {
        SimpleHolder<Boolean> result = new SimpleHolder<Boolean>(false);
        this.getMap().compute(Nullable.of(key), (k, v) -> {
            if (v != null && Objects.equals(v.get(), value)) {
                result.set(true);
                this.dispatchEvent(() -> new MapEvent(this, 3, k.get(), v.get(), null));
                return null;
            }
            return v;
        });
        return (Boolean)result.get();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        for (Object key : this.keySet()) {
            this.compute(key, function);
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        SimpleHolder<Boolean> result = new SimpleHolder<Boolean>(false);
        this.getMap().compute(Nullable.of(key), (k, v) -> {
            if (v != null && Objects.equals(v.get(), oldValue)) {
                result.set(true);
                this.dispatchEvent(() -> new MapEvent(this, 2, k.get(), v.get(), newValue));
                return Nullable.of(newValue);
            }
            return v;
        });
        return (Boolean)result.get();
    }

    @Override
    public V replace(K key, V value) {
        SimpleHolder result = new SimpleHolder();
        this.getMap().compute(Nullable.of(key), (k, v) -> {
            if (v != null) {
                result.set(v.get());
                this.dispatchEvent(() -> new MapEvent(this, 2, k.get(), v.get(), value));
                return Nullable.of(value);
            }
            return v;
        });
        return result.get();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return (V)Nullable.get(this.getMap().computeIfAbsent(Nullable.of(key), k -> {
            Object value = mappingFunction.apply((K)k.get());
            if (value != null) {
                this.dispatchEvent(() -> new MapEvent<Object, Object>(this, 1, key, null, value));
                return Nullable.of(value);
            }
            return null;
        }));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        return (V)Nullable.get(this.getMap().computeIfPresent(Nullable.of(key), (k, v) -> {
            Object valueNew = remappingFunction.apply((K)k.get(), (V)v.get());
            if (valueNew != null) {
                this.dispatchEvent(() -> new MapEvent(this, 2, k.get(), v.get(), valueNew));
                return Nullable.of(valueNew);
            }
            this.dispatchEvent(() -> new MapEvent<Object, Object>(this, 3, key, v.get(), null));
            return null;
        }));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        return (V)Nullable.get(this.getMap().compute(Nullable.of(key), (k, v) -> {
            Object valueOld = Nullable.get(v);
            Object valueNew = remappingFunction.apply((K)k.get(), (V)valueOld);
            if (valueNew != null) {
                this.dispatchEvent(() -> new MapEvent<Object, Object>(this, valueOld == null ? 1 : 2, key, valueOld, valueNew));
                return Nullable.of(valueNew);
            }
            if (valueOld != null) {
                this.dispatchEvent(() -> new MapEvent<Object, Object>(this, 3, key, valueOld, null));
            }
            return null;
        }));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(remappingFunction);
        return (V)Nullable.get(this.getMap().compute(Nullable.of(key), (k, v) -> {
            Object valueNew;
            Object valueOld = Nullable.get(v);
            Object object = valueNew = valueOld == null ? value : remappingFunction.apply((V)valueOld, (V)value);
            if (valueNew != null) {
                this.dispatchEvent(() -> new MapEvent<Object, Object>(this, valueOld == null ? 1 : 2, key, valueOld, valueNew));
                return Nullable.of(valueNew);
            }
            this.dispatchEvent(() -> new MapEvent<Object, Object>(this, 3, key, valueOld, null));
            return null;
        }));
    }

    @Override
    public void clear() {
        for (Object key : this.keySet()) {
            this.remove(key);
        }
    }

    @Override
    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    @Override
    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    @Override
    public void addMapListener(MapListener<? super K, ? super V> listener, K key, boolean fLite) {
        Base.azzert(listener != null);
        this.f_listenerSupport.addListener(listener, key, fLite);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V> listener, K key) {
        Base.azzert(listener != null);
        this.f_listenerSupport.removeListener(listener, key);
    }

    @Override
    public void addMapListener(MapListener<? super K, ? super V> listener, Filter filter, boolean fLite) {
        Base.azzert(listener != null);
        this.f_listenerSupport.addListener(listener, filter, fLite);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V> listener, Filter filter) {
        Base.azzert(listener != null);
        this.f_listenerSupport.removeListener(listener, filter);
    }

    public void truncate() {
        super.clear();
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.f_listenerSupport;
    }

    protected void dispatchEvent(Supplier<MapEvent<K, V>> evt) {
        if (!this.f_listenerSupport.isEmpty()) {
            this.f_listenerSupport.fireEvent(evt.get(), false);
        }
    }
}

