/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.collections;

import com.oracle.coherence.common.base.Nullable;
import com.tangosol.util.SimpleMapEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class NullableConcurrentMap<K, V>
implements ConcurrentMap<K, V> {
    public static final Map<?, ?> EMPTY = Collections.unmodifiableMap(new NullableConcurrentMap(1, 1.0f));
    private final ConcurrentHashMap<Nullable<K>, Nullable<V>> f_map;

    public NullableConcurrentMap() {
        this(new ConcurrentHashMap());
    }

    public NullableConcurrentMap(int cInitialCapacity) {
        this(new ConcurrentHashMap(cInitialCapacity));
    }

    public NullableConcurrentMap(int cInitialCapacity, float flLoadFactor) {
        this(new ConcurrentHashMap(cInitialCapacity, flLoadFactor));
    }

    public NullableConcurrentMap(Map<? extends K, ? extends V> map) {
        this.f_map = new ConcurrentHashMap(map.size());
        this.putAll(map);
    }

    ConcurrentHashMap<Nullable<K>, Nullable<V>> getMap() {
        return this.f_map;
    }

    public Map.Entry<K, V> getEntry(K key) {
        Nullable<K> nullableKey = Nullable.of(key);
        Nullable<V> value = this.f_map.get(nullableKey);
        return value == null ? null : new NullableEntry(new SimpleMapEntry<Nullable<K>, Nullable<V>>(nullableKey, value));
    }

    @Override
    public int size() {
        return this.f_map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.f_map.isEmpty();
    }

    @Override
    public V get(Object key) {
        return Nullable.get(this.f_map.get(Nullable.of(key)));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.f_map.containsKey(Nullable.of(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.f_map.containsValue(Nullable.of(value));
    }

    @Override
    public V put(K key, V value) {
        return Nullable.get(this.f_map.put(Nullable.of(key), Nullable.of(value)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.f_map.putAll(NullableConcurrentMap.convertMap(map));
    }

    @Override
    public V remove(Object key) {
        return Nullable.get(this.f_map.remove(Nullable.of(key)));
    }

    @Override
    public void clear() {
        this.f_map.clear();
    }

    @Override
    public Set<K> keySet() {
        return new NullableSet(this.f_map.keySet(Nullable.empty()));
    }

    @Override
    public Collection<V> values() {
        return new NullableCollection(this.f_map.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new NullableEntrySet(this.f_map.entrySet());
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return Nullable.get(this.f_map.putIfAbsent(Nullable.of(key), Nullable.of(value)));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.f_map.remove(Nullable.of(key), Nullable.of(value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.f_map.replace(Nullable.of(key), Nullable.of(oldValue), Nullable.of(newValue));
    }

    @Override
    public V replace(K key, V value) {
        return Nullable.get(this.f_map.replace(Nullable.of(key), Nullable.of(value)));
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return Nullable.get(this.f_map.getOrDefault(Nullable.of(key), Nullable.of(defaultValue)));
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.f_map.forEach((key, value) -> action.accept((Object)Nullable.get(key), (Object)Nullable.get(value)));
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.f_map.replaceAll((key, value) -> Nullable.of(function.apply((Object)Nullable.get(key), (Object)Nullable.get(value))));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return (V)Nullable.get(this.f_map.computeIfAbsent(Nullable.of(key), k -> {
            Object value = mappingFunction.apply((Object)key);
            return value == null ? null : Nullable.of(value);
        }));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)Nullable.get(this.f_map.computeIfPresent(Nullable.of(key), (k, v) -> {
            Object value = remappingFunction.apply((Object)key, (Object)Nullable.get(v));
            return value == null ? null : Nullable.of(value);
        }));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)Nullable.get(this.f_map.compute(Nullable.of(key), (k, v) -> {
            Object value = remappingFunction.apply((Object)key, (Object)Nullable.get(v));
            return value == null ? null : Nullable.of(value);
        }));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(remappingFunction);
        return (V)Nullable.get(this.f_map.merge(Nullable.of(key), Nullable.of(value), (oldValue, ignore) -> {
            Object newValue = remappingFunction.apply((Object)Nullable.get(oldValue), (Object)value);
            return newValue == null ? null : Nullable.of(newValue);
        }));
    }

    @Override
    public int hashCode() {
        return this.f_map.hashCode();
    }

    public String toString() {
        return this.f_map.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return Objects.equals(this.f_map, NullableConcurrentMap.convertMap(that));
    }

    private static <K, V> Map<Nullable<K>, Nullable<V>> convertMap(Map<? extends K, ? extends V> map) {
        HashMap mapConv = new HashMap(map.size());
        map.forEach((key, value) -> mapConv.put(Nullable.of(key), Nullable.of(value)));
        return mapConv;
    }

    private class NullableEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<Nullable<K>, Nullable<V>> entry;

        NullableEntry(Map.Entry<Nullable<K>, Nullable<V>> entry) {
            Objects.requireNonNull(entry);
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return Nullable.get(this.entry.getKey());
        }

        @Override
        public V getValue() {
            return Nullable.get(this.entry.getValue());
        }

        @Override
        public V setValue(V value) {
            return Nullable.get(this.entry.setValue(Nullable.of(value)));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Objects.equals(this.entry, new SimpleMapEntry(Nullable.of(that.getKey()), Nullable.of(that.getValue())));
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }

        public String toString() {
            return this.entry.toString();
        }
    }

    private static class NullableSet<T>
    extends NullableCollection<T>
    implements Set<T> {
        private final Set<Nullable<T>> f_set;

        NullableSet(Set<Nullable<T>> set) {
            super(set);
            this.f_set = set;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Set that = (Set)o;
            return Objects.equals(this.f_set, that.stream().map(Nullable::of).collect(Collectors.toUnmodifiableSet()));
        }
    }

    private static class NullableCollection<T>
    implements Collection<T> {
        private final Collection<Nullable<T>> f_col;

        NullableCollection(Collection<Nullable<T>> col) {
            this.f_col = col;
        }

        @Override
        public int size() {
            return this.f_col.size();
        }

        @Override
        public boolean isEmpty() {
            return this.f_col.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.f_col.contains(Nullable.of(o));
        }

        @Override
        public Iterator<T> iterator() {
            return new NullableIterator<T>(this.f_col.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.f_col.stream().map(k -> Nullable.get(k)).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.f_col.stream().map(k -> Nullable.get(k)).toList().toArray(a);
        }

        @Override
        public boolean add(T key) {
            return this.f_col.add(Nullable.of(key));
        }

        @Override
        public boolean remove(Object o) {
            return this.f_col.remove(Nullable.of(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.f_col.containsAll(c.stream().map(Nullable::of).toList());
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ArrayList listAdd = new ArrayList(c.size());
            c.forEach(e -> listAdd.add(Nullable.of(e)));
            return this.f_col.addAll(listAdd);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.f_col.retainAll(c.stream().map(Nullable::of).toList());
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.f_col.removeAll(c.stream().map(Nullable::of).toList());
        }

        @Override
        public void clear() {
            this.f_col.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Collection)) {
                return false;
            }
            Collection that = (Collection)o;
            return Objects.equals(this.f_col, that.stream().map(Nullable::of).toList());
        }

        @Override
        public int hashCode() {
            return this.f_col.hashCode();
        }

        public String toString() {
            return this.f_col.toString();
        }
    }

    private class NullableEntrySet
    implements Set<Map.Entry<K, V>> {
        private final Set<Map.Entry<Nullable<K>, Nullable<V>>> f_setEntries;

        NullableEntrySet(Set<Map.Entry<Nullable<K>, Nullable<V>>> setEntries) {
            this.f_setEntries = setEntries;
        }

        @Override
        public int size() {
            return this.f_setEntries.size();
        }

        @Override
        public boolean isEmpty() {
            return this.f_setEntries.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return this.f_setEntries.contains(new SimpleMapEntry(Nullable.of(entry.getKey()), Nullable.of(entry.getValue())));
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new NullableEntryIterator(this.f_setEntries.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.f_setEntries.stream().map(x$0 -> new NullableEntry(x$0)).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.f_setEntries.stream().map(x$0 -> new NullableEntry(x$0)).toList().toArray(a);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return this.f_setEntries.add(new SimpleMapEntry(Nullable.of(entry.getKey()), Nullable.of(entry.getValue())));
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return this.f_setEntries.remove(new SimpleMapEntry(Nullable.of(entry.getKey()), Nullable.of(entry.getValue())));
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c != this) {
                for (Object e : c) {
                    if (e != null && this.contains(e)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            Objects.requireNonNull(c);
            ArrayList listAdd = new ArrayList(c.size());
            for (Map.Entry e : c) {
                if (e == null) continue;
                listAdd.add(new SimpleMapEntry(Nullable.of(e.getKey()), Nullable.of(e.getValue())));
            }
            return this.f_setEntries.addAll(listAdd);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Objects.requireNonNull(c);
            ArrayList listRemove = new ArrayList(c.size());
            for (Map.Entry e : c) {
                if (e == null) continue;
                listRemove.add(new SimpleMapEntry(Nullable.of(e.getKey()), Nullable.of(e.getValue())));
            }
            return this.f_setEntries.removeAll(listRemove);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Objects.requireNonNull(c);
            ArrayList listRetain = new ArrayList(c.size());
            for (Map.Entry e : c) {
                if (e == null) continue;
                listRetain.add(new SimpleMapEntry(Nullable.of(e.getKey()), Nullable.of(e.getValue())));
            }
            return this.f_setEntries.retainAll(listRetain);
        }

        @Override
        public void clear() {
            this.f_setEntries.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Set that = (Set)o;
            HashSet setComp = new HashSet(that.size());
            for (Map.Entry e : that) {
                if (e == null) continue;
                setComp.add(new SimpleMapEntry(Nullable.of(e.getKey()), Nullable.of(e.getValue())));
            }
            return Objects.equals(this.f_setEntries, setComp);
        }

        @Override
        public int hashCode() {
            return this.f_setEntries.hashCode();
        }

        public String toString() {
            return this.f_setEntries.toString();
        }
    }

    private class NullableEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<Nullable<K>, Nullable<V>>> f_iterator;

        NullableEntryIterator(Iterator<Map.Entry<Nullable<K>, Nullable<V>>> iterator) {
            this.f_iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.f_iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new NullableEntry(this.f_iterator.next());
        }

        @Override
        public void remove() {
            this.f_iterator.remove();
        }
    }

    private static class NullableIterator<T>
    implements Iterator<T> {
        private final Iterator<Nullable<T>> f_iterator;

        NullableIterator(Iterator<Nullable<T>> iterator) {
            this.f_iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.f_iterator.hasNext();
        }

        @Override
        public T next() {
            return Nullable.get(this.f_iterator.next());
        }

        @Override
        public void remove() {
            this.f_iterator.remove();
        }
    }
}

