/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.collections;

import com.oracle.coherence.common.collections.Stack;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentLinkedStack<V>
implements Stack<V>,
Iterable<V> {
    protected static final Element TAIL = new Element();
    protected final AtomicReference<Element<V>> f_refHead = new AtomicReference<Element>(TAIL);

    @Override
    public void push(V value) {
        Element<V> next;
        Element<V> element = new Element<V>(value);
        do {
            next = this.f_refHead.get();
            element.m_next = next;
            element.m_cHeight = next.m_cHeight + 1;
        } while (!this.f_refHead.compareAndSet(next, element));
    }

    @Override
    public V pop() {
        Element<V> head;
        while ((head = this.f_refHead.get()) != TAIL && !this.f_refHead.compareAndSet(head, head.m_next)) {
        }
        head.m_next = null;
        return head.f_value;
    }

    @Override
    public V peek() {
        return this.f_refHead.get().f_value;
    }

    @Override
    public boolean isEmpty() {
        return this.f_refHead.get() == TAIL;
    }

    @Override
    public int size() {
        return this.f_refHead.get().m_cHeight;
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private Element<V> m_next;
            {
                this.m_next = ConcurrentLinkedStack.this.f_refHead.get();
            }

            @Override
            public boolean hasNext() {
                return this.m_next != TAIL;
            }

            @Override
            public V next() {
                Element current = this.m_next;
                if (current == TAIL) {
                    throw new NoSuchElementException();
                }
                this.m_next = current.m_next;
                return current.f_value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static final class Element<V> {
        protected final V f_value;
        private int m_cHeight;
        private Element<V> m_next;

        Element(V value) {
            this.f_value = value;
        }

        Element() {
            this.f_value = null;
            this.m_next = this;
            this.m_cHeight = 0;
        }
    }
}

