/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.collections;

import com.oracle.coherence.common.collections.AbstractStableIterator;
import java.util.Iterator;

public class ChainedIterator<T>
extends AbstractStableIterator<T> {
    private final Iterator<T>[] m_aIter;
    private int m_iNextIter;
    private Iterator<T> m_iterCurrent;
    private Iterator<T> m_iterPrevious;

    public ChainedIterator(Iterator<T> iterFirst, Iterator<T> iterSecond) {
        this(new Iterator[]{iterFirst, iterSecond});
    }

    public ChainedIterator(Iterator<T>[] aIter) {
        this.m_aIter = aIter;
    }

    @Override
    public T next() {
        Object oNext = super.next();
        this.m_iterPrevious = this.m_iterCurrent;
        return oNext;
    }

    @Override
    protected void advance() {
        Iterator<T> iter = this.m_iterCurrent;
        if (iter == null || !iter.hasNext()) {
            Iterator<T>[] aIter = this.m_aIter;
            int cIters = aIter.length;
            int iNext = this.m_iNextIter;
            do {
                if (iNext < cIters) continue;
                return;
            } while (!(iter = aIter[iNext++]).hasNext());
            this.m_iNextIter = iNext;
            this.m_iterCurrent = iter;
        }
        this.setNext(iter.next());
    }

    @Override
    protected void remove(T oPrev) {
        Iterator<T> iter = this.m_iterPrevious;
        if (iter == null) {
            throw new IllegalStateException();
        }
        iter.remove();
    }
}

