/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.util.SafeClock;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public abstract class TimeHelper {
    private static final Map<String, TimeZone> s_mapTimeZones = new ConcurrentHashMap<String, TimeZone>();
    private static final long s_ldtStartTime = System.currentTimeMillis();
    private static final SafeClock s_safeClock = new SafeClock(s_ldtStartTime);
    private static final Object s_oRuntimeMXBean;
    private static final Method s_methodUptime;

    public static long getUpTimeMillis() {
        Method methodUptime = s_methodUptime;
        if (methodUptime == null) {
            return System.currentTimeMillis() - s_ldtStartTime;
        }
        try {
            return (Long)methodUptime.invoke(s_oRuntimeMXBean, new Object[0]);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            throw Exceptions.ensureRuntimeException(e);
        }
    }

    public static long getSafeTimeMillis() {
        return s_safeClock.getSafeTimeMillis(System.currentTimeMillis());
    }

    public static long getLastSafeTimeMillis() {
        return s_safeClock.getLastSafeTimeMillis();
    }

    public static long computeSafeWaitTime(long ldtTimeout) {
        if (ldtTimeout == Long.MAX_VALUE) {
            return 0L;
        }
        long ldtNow = TimeHelper.getSafeTimeMillis();
        return ldtTimeout == ldtNow ? -1L : ldtTimeout - ldtNow;
    }

    public static TimeZone getTimeZone(String sId) {
        TimeZone timeZone = s_mapTimeZones.get(sId);
        if (timeZone == null) {
            timeZone = TimeZone.getTimeZone(sId);
            s_mapTimeZones.put(sId, timeZone);
        }
        return timeZone;
    }

    static {
        Object oRuntimeMXBean = null;
        Method methodUptime = null;
        try {
            oRuntimeMXBean = Class.forName("java.lang.management.ManagementFactory").getMethod("getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]);
            if (oRuntimeMXBean != null) {
                methodUptime = Class.forName("java.lang.management.RuntimeMXBean").getMethod("getUptime", new Class[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        s_oRuntimeMXBean = oRuntimeMXBean;
        s_methodUptime = methodUptime;
    }
}

