/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.base.Objects;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public abstract class StackTrace {
    public static StackFrame getCallerStackFrame() {
        String sStack = StackTrace.getStackTrace();
        int of = sStack.indexOf(10, sStack.lastIndexOf(".getCallerStackFrame(")) + 1;
        of = sStack.indexOf(10, of) + 1;
        try {
            return new StackFrame(sStack.substring(of, sStack.indexOf(10, of)));
        }
        catch (RuntimeException e) {
            return StackFrame.UNKNOWN;
        }
    }

    public static StackFrame getStackFrame() {
        String sStack = StackTrace.getStackTrace();
        int of = sStack.indexOf(10, sStack.lastIndexOf(".getStackFrame(")) + 1;
        try {
            return new StackFrame(sStack.substring(of, sStack.indexOf(10, of)));
        }
        catch (RuntimeException e) {
            return StackFrame.UNKNOWN;
        }
    }

    public static StackFrame[] getStackFrames() {
        String sStack = StackTrace.getStackTrace();
        LineNumberReader reader = new LineNumberReader(new StringReader(sStack.substring(sStack.indexOf(10, sStack.lastIndexOf(".getStackFrames(")) + 1)));
        try {
            ArrayList<StackFrame> list = new ArrayList<StackFrame>();
            String sLine = reader.readLine();
            while (sLine != null && sLine.length() > 0) {
                StackFrame frame = StackFrame.UNKNOWN;
                try {
                    frame = new StackFrame(sLine);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                list.add(frame);
                sLine = reader.readLine();
            }
            return list.toArray(new StackFrame[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getStackTrace() {
        String s = StackTrace.getStackTrace(new Exception());
        return s.substring(s.indexOf(10, s.indexOf(".getStackTrace(")) + 1);
    }

    public static String getStackTrace(Throwable e) {
        String s = StackTrace.printStackTrace(e);
        if (s.startsWith(e.getClass().getName())) {
            s = s.substring(s.indexOf(10) + 1);
        }
        return s;
    }

    public static String getDeepMessage(Throwable t, String sDelim) {
        StringBuilder sb = new StringBuilder();
        String sMsgLast = null;
        while (t != null) {
            String sMsg = t.getMessage();
            if (!Objects.equals(sMsgLast, sMsg)) {
                if (sMsgLast != null) {
                    sb.append(sDelim);
                }
                sb.append(sMsg);
                sMsgLast = sMsg;
            }
            t = t.getCause();
        }
        return sb.toString();
    }

    public static String printStackTrace(Throwable e) {
        String string;
        CharArrayWriter writerRaw = new CharArrayWriter(1024);
        try {
            try (PrintWriter writerOut = new PrintWriter(writerRaw);){
                e.printStackTrace(writerOut);
            }
            ((Writer)writerRaw).flush();
            string = ((Object)writerRaw).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writerRaw).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException eIO) {
                throw new RuntimeException(eIO);
            }
        }
        ((Writer)writerRaw).close();
        return string;
    }

    public static BigDecimal ensureBigDecimal(Number num) {
        return num instanceof BigDecimal ? (BigDecimal)num : (num instanceof BigInteger ? new BigDecimal((BigInteger)num) : BigDecimal.valueOf(num.doubleValue()));
    }

    public static String getExpression(String sMethod) {
        int of;
        StackFrame[] aFrames = StackTrace.getStackFrames();
        int i = 0;
        while (!aFrames[i].getMethodName().equals(sMethod)) {
            ++i;
        }
        while (aFrames[i].getMethodName().equals(sMethod)) {
            ++i;
        }
        String sLine = aFrames[i].getLine();
        if (sLine != null && (of = sLine.indexOf(sMethod)) >= 0) {
            int ofLParen = sLine.indexOf(40, of);
            int ofRParen = sLine.lastIndexOf(41);
            if (ofLParen > of && ofRParen > ofLParen) {
                return sLine.substring(ofLParen + 1, ofRParen);
            }
        }
        return null;
    }

    public static String getStackTrace(Thread t) {
        StackTraceElement[] arrElement = t.isAlive() ? t.getStackTrace() : null;
        StringBuilder sb = new StringBuilder(System.lineSeparator());
        if (arrElement != null) {
            for (int i = 0; i < arrElement.length; ++i) {
                sb.append("at " + String.valueOf(arrElement[i])).append(System.lineSeparator());
            }
            return "Stack trace for thread " + String.valueOf(t) + ": " + sb.toString();
        }
        return "";
    }

    public static class StackFrame {
        public static final StackFrame UNKNOWN = new StackFrame("unknown", "unknown", "unknown", 0);
        private String m_sFile;
        private String m_sClass;
        private String m_sMethod;
        private int m_nLine;

        public StackFrame(String sExcept) {
            try {
                int of = sExcept.indexOf(40);
                String sLeft = sExcept.substring(sExcept.lastIndexOf(32, of) + 1, of);
                String sRight = sExcept.substring(of + 1, sExcept.lastIndexOf(41));
                of = sLeft.lastIndexOf(46);
                String sClass = sLeft.substring(0, of);
                String sMethod = sLeft.substring(of + 1);
                String sFile = "unknown";
                int nLine = 0;
                of = sRight.lastIndexOf(58);
                if (of >= 0) {
                    sFile = sRight.substring(0, of);
                    try {
                        nLine = Integer.parseInt(sRight.substring(of + 1));
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                this.init(sFile, sClass, sMethod, nLine);
            }
            catch (RuntimeException e) {
                Logger.out("Exception constructing StackFrame for \"" + sExcept + "\"");
                throw e;
            }
        }

        public StackFrame(String sFile, String sClass, String sMethod, int nLine) {
            this.init(sFile, sClass, sMethod, nLine);
        }

        protected void init(String sFile, String sClass, String sMethod, int nLine) {
            this.m_sFile = sFile;
            this.m_sClass = sClass;
            this.m_sMethod = sMethod;
            this.m_nLine = nLine;
        }

        public String getFileName() {
            return this.m_sFile;
        }

        public String getClassName() {
            return this.m_sClass;
        }

        public String getShortClassName() {
            String sClass = this.m_sClass;
            sClass = sClass.substring(sClass.lastIndexOf(46) + 1);
            return sClass.replace('$', '.');
        }

        public String getMethodName() {
            return this.m_sMethod;
        }

        public int getLineNumber() {
            return this.m_nLine;
        }

        public String getLine() {
            block10: {
                String string;
                InputStream stream;
                int nLine = this.getLineNumber();
                if (nLine == 0) {
                    return null;
                }
                String sClass = this.getClassName();
                int of = sClass.indexOf(36);
                if (of >= 0) {
                    sClass = sClass.substring(0, of);
                }
                if ((stream = Class.forName(sClass, false, Classes.getContextClassLoader()).getClassLoader().getResourceAsStream(sClass.replace('.', '/') + ".java")) == null) break block10;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                try {
                    String sLine = null;
                    for (int i = 0; i < nLine; ++i) {
                        sLine = reader.readLine();
                    }
                    string = sLine;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                reader.close();
                return string;
            }
            return null;
        }

        public String toString() {
            int nLine = this.getLineNumber();
            Object sLine = nLine == 0 ? "?" : "" + nLine;
            return this.getClassName() + "." + this.getMethodName() + "(" + this.getFileName() + ":" + (String)sLine + ")";
        }

        public String toShortString() {
            int nLine = this.getLineNumber();
            Object sLine = nLine == 0 ? "?" : "" + nLine;
            return this.getShortClassName() + "." + this.getMethodName() + " [" + (String)sLine + "]";
        }
    }
}

