/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Notifier;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;

public class SingleWaiterMultiNotifier
implements Notifier {
    protected volatile Object m_oState;
    private static final AtomicReferenceFieldUpdater<SingleWaiterMultiNotifier, Object> s_fuState = AtomicReferenceFieldUpdater.newUpdater(SingleWaiterMultiNotifier.class, Object.class, "m_oState");

    @Override
    public void await(long cMillis) throws InterruptedException {
        if (this.m_oState == this) {
            this.consumeSignal();
        } else if (s_fuState.compareAndSet(this, null, Thread.currentThread())) {
            if (cMillis == 0L) {
                Blocking.park(this);
            } else {
                Blocking.parkNanos(this, cMillis * 1000000L);
            }
            if (this.m_oState != this && Blocking.interrupted()) {
                this.consumeSignal();
                throw new InterruptedException();
            }
            this.consumeSignal();
        } else if (this.m_oState == this) {
            this.consumeSignal();
        } else {
            throw new IllegalStateException("unexpected thread '" + String.valueOf(this.m_oState) + "' is also awaiting");
        }
    }

    @Override
    public void signal() {
        LockSupport.unpark(this.signalInternal());
    }

    public String toString() {
        Object oState = this.m_oState;
        return super.toString() + (String)(oState == this ? " signaled" : " unsignaled(" + String.valueOf(oState) + ")");
    }

    public Thread getWaitingThread() {
        Object oState = this.m_oState;
        return oState == null || oState == this ? null : (Thread)oState;
    }

    protected Thread signalInternal() {
        Object oState = this.m_oState;
        if (oState == null) {
            if (s_fuState.compareAndSet(this, null, this)) {
                return null;
            }
            oState = this.m_oState;
        }
        if (oState != this && oState != null && s_fuState.compareAndSet(this, oState, this)) {
            return (Thread)oState;
        }
        return null;
    }

    protected void consumeSignal() {
        this.m_oState = null;
    }
}

