/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.Classes;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ListResourceBundle;

public abstract class Resources
extends ListResourceBundle {
    public String getString(String sKey, String sDefault) {
        return this.getString(sKey, null, sDefault);
    }

    public String getString(String sKey, String[] asParam, String sDefault) {
        Object sBase;
        try {
            sBase = this.getString(sKey);
        }
        catch (Exception e) {
            sBase = sDefault;
        }
        if (asParam != null && asParam.length > 0) {
            try {
                return MessageFormat.format((String)sBase, asParam);
            }
            catch (Exception e) {
                int c = asParam.length;
                for (int i = 0; i < c; ++i) {
                    sBase = (String)sBase + "\n[" + i + "]=\"" + (asParam[i] == null ? "<null>" : asParam[i]) + "\"";
                }
            }
        }
        return sBase;
    }

    public static URL findResource(String sName, ClassLoader loader) {
        URL url = Resources.findRelativeOrAbsoluteResource(sName, loader);
        if (url == null) {
            url = Resources.findRelativeOrAbsoluteResource(sName, Thread.currentThread().getContextClassLoader());
        }
        if (url == null) {
            url = Resources.findRelativeOrAbsoluteResource(sName, Classes.class.getClassLoader());
        }
        if (url == null) {
            url = Resources.findRelativeOrAbsoluteResource(sName, ClassLoader.getSystemClassLoader());
        }
        if (url == null) {
            try {
                url = new URL(sName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    public static URL findRelativeOrAbsoluteResource(String sName, ClassLoader loader) {
        if (loader == null) {
            return null;
        }
        URL url = loader.getResource(sName);
        if (url == null) {
            url = sName.startsWith("/") ? loader.getResource(sName.substring(1)) : loader.getResource("/" + sName);
        }
        return url;
    }

    public static URL getFileURL(String sName) {
        URL url;
        block4: {
            url = null;
            try {
                File file = new File(sName);
                if (!file.exists()) break block4;
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException ioex) {
                    file = file.getAbsoluteFile();
                }
                url = file.toURI().toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    public static URL findFileOrResource(String sName, ClassLoader loader) {
        URL url = Resources.getFileURL(sName);
        return url == null ? Resources.findResource(sName, loader) : url;
    }
}

