/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.Assertions;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;

public abstract class Reads {
    public static int read(InputStream stream, byte[] ab) throws IOException {
        int MAX = ab.length;
        int cb = 0;
        boolean fEOF = false;
        while (!fEOF && cb < MAX) {
            int cbBlock = stream.read(ab, cb, MAX - cb);
            if (cbBlock < 0) {
                fEOF = true;
                continue;
            }
            cb += cbBlock;
        }
        return cb;
    }

    public static byte[] read(InputStream stream) throws IOException {
        int BLOCK = 1024;
        byte[] ab = new byte[1024];
        ByteArrayOutputStream streamBuf = new ByteArrayOutputStream(1024);
        try {
            int cb;
            while ((cb = stream.read(ab, 0, 1024)) >= 0) {
                if (cb <= 0) continue;
                streamBuf.write(ab, 0, cb);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        stream.close();
        return streamBuf.toByteArray();
    }

    public static byte[] read(DataInput stream) throws IOException {
        if (stream instanceof InputStream) {
            return Reads.read((InputStream)((Object)stream));
        }
        int BLOCK = 1024;
        int cb = 0;
        byte[] ab = new byte[1024];
        ByteArrayOutputStream streamBuf = null;
        try {
            while (true) {
                ab[cb++] = stream.readByte();
                if (cb != 1024) continue;
                if (streamBuf == null) {
                    streamBuf = new ByteArrayOutputStream(1024);
                }
                streamBuf.write(ab, 0, cb);
                cb = 0;
            }
        }
        catch (EOFException eOFException) {
            if (streamBuf == null) {
                if (cb == 1024) {
                    return ab;
                }
                byte[] abNew = new byte[cb];
                System.arraycopy(ab, 0, abNew, 0, cb);
                return abNew;
            }
            if (cb != 0) {
                streamBuf.write(ab, 0, cb);
            }
            return streamBuf.toByteArray();
        }
    }

    public static byte[] read(DataInputStream stream) throws IOException {
        return Reads.read((InputStream)stream);
    }

    public static String read(Reader reader) throws IOException {
        int BLOCK = 1024;
        char[] ach = new char[1024];
        CharArrayWriter writer = new CharArrayWriter(1024);
        try {
            int cch;
            while ((cch = reader.read(ach, 0, 1024)) >= 0) {
                if (cch <= 0) continue;
                writer.write(ach, 0, cch);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        reader.close();
        return writer.toString();
    }

    public static byte[] read(File file) throws IOException {
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        long cbFile = file.length();
        Assertions.azzert(cbFile < Integer.MAX_VALUE);
        int cb = (int)cbFile;
        byte[] ab = new byte[cb];
        try (FileInputStream in = new FileInputStream(file);){
            int cbRead = Reads.read(in, ab);
            Assertions.azzert(cb == cbRead);
        }
        return ab;
    }

    public static byte[] read(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        URLConnection con = url.openConnection();
        int cb = con.getContentLength();
        byte[] ab = null;
        try (InputStream in = con.getInputStream();){
            if (cb == -1) {
                ab = Reads.read(in);
            } else {
                ab = new byte[cb];
                int cbRead = Reads.read(in, ab);
                Assertions.azzert(cb == cbRead);
            }
        }
        return ab;
    }
}

