/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import java.util.Arrays;

public abstract class Objects {
    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        try {
            return o1.equals(o2);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean equalsDeep(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.getClass().isArray()) {
            if (o1 instanceof byte[]) {
                return o2 instanceof byte[] && Arrays.equals((byte[])o1, (byte[])o2);
            }
            if (o1 instanceof Object[]) {
                Object[] ao2;
                Object[] ao1;
                int c;
                if (o2 instanceof Object[] && (c = (ao1 = (Object[])o1).length) == (ao2 = (Object[])o2).length) {
                    for (int i = 0; i < c; ++i) {
                        if (Objects.equalsDeep(ao1[i], ao2[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (o1 instanceof int[]) {
                return o2 instanceof int[] && Arrays.equals((int[])o1, (int[])o2);
            }
            if (o1 instanceof char[]) {
                return o2 instanceof char[] && Arrays.equals((char[])o1, (char[])o2);
            }
            if (o1 instanceof long[]) {
                return o2 instanceof long[] && Arrays.equals((long[])o1, (long[])o2);
            }
            if (o1 instanceof double[]) {
                return o2 instanceof double[] && Arrays.equals((double[])o1, (double[])o2);
            }
            if (o1 instanceof boolean[]) {
                return o2 instanceof boolean[] && Arrays.equals((boolean[])o1, (boolean[])o2);
            }
            if (o1 instanceof short[]) {
                return o2 instanceof short[] && Arrays.equals((short[])o1, (short[])o2);
            }
            if (o1 instanceof float[]) {
                return o2 instanceof float[] && Arrays.equals((float[])o1, (float[])o2);
            }
        }
        try {
            return o1.equals(o2);
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

