/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.NullableBoolean;
import com.oracle.coherence.common.base.NullableByte;
import com.oracle.coherence.common.base.NullableDouble;
import com.oracle.coherence.common.base.NullableEmpty;
import com.oracle.coherence.common.base.NullableFloat;
import com.oracle.coherence.common.base.NullableInt;
import com.oracle.coherence.common.base.NullableLong;
import com.oracle.coherence.common.base.NullableShort;
import com.oracle.coherence.common.base.NullableWrapper;

public interface Nullable<T> {
    public static <T> Nullable<T> of(T value) {
        if (value instanceof Nullable) {
            return (Nullable)value;
        }
        if (value == null) {
            return Nullable.empty();
        }
        if (value instanceof Integer) {
            return Nullable.of((int)((Integer)value));
        }
        if (value instanceof Long) {
            return Nullable.of((long)((Long)value));
        }
        if (value instanceof Short) {
            return Nullable.of((short)((Short)value));
        }
        if (value instanceof Byte) {
            return Nullable.of((byte)((Byte)value));
        }
        if (value instanceof Double) {
            return Nullable.of((double)((Double)value));
        }
        if (value instanceof Float) {
            return Nullable.of(((Float)value).floatValue());
        }
        if (value instanceof Boolean) {
            return Nullable.of((boolean)((Boolean)value));
        }
        return new NullableWrapper<T>(value);
    }

    public static Nullable<Integer> of(int value) {
        return new NullableInt(value);
    }

    public static Nullable<Integer> of(Integer value) {
        return value == null ? Nullable.empty() : Nullable.of((int)value);
    }

    public static Nullable<Long> of(long value) {
        return new NullableLong(value);
    }

    public static Nullable<Long> of(Long value) {
        return value == null ? Nullable.empty() : Nullable.of((long)value);
    }

    public static Nullable<Short> of(short value) {
        return new NullableShort(value);
    }

    public static Nullable<Short> of(Short value) {
        return value == null ? Nullable.empty() : Nullable.of((short)value);
    }

    public static Nullable<Byte> of(byte value) {
        return new NullableByte(value);
    }

    public static Nullable<Byte> of(Byte value) {
        return value == null ? Nullable.empty() : Nullable.of((byte)value);
    }

    public static Nullable<Double> of(double value) {
        return new NullableDouble(value);
    }

    public static Nullable<Double> of(Double value) {
        return value == null ? Nullable.empty() : Nullable.of((double)value);
    }

    public static Nullable<Float> of(float value) {
        return new NullableFloat(value);
    }

    public static Nullable<Float> of(Float value) {
        return value == null ? Nullable.empty() : Nullable.of(value.floatValue());
    }

    public static Nullable<Boolean> of(boolean value) {
        return value ? NullableBoolean.TRUE : NullableBoolean.FALSE;
    }

    public static Nullable<Boolean> of(Boolean value) {
        return value == null ? Nullable.empty() : Nullable.of((boolean)value);
    }

    public static <T> Nullable<T> empty() {
        return NullableEmpty.INSTANCE;
    }

    public static <T> T get(Nullable<? extends T> value) {
        return value == null ? null : (T)value.get();
    }

    default public T get() {
        return (T)this;
    }
}

