/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

public class MutableLong
extends Number
implements Comparable<MutableLong> {
    protected long m_lValue;

    public MutableLong() {
    }

    public MutableLong(long lValue) {
        this.m_lValue = lValue;
    }

    public MutableLong set(long lValue) {
        this.m_lValue = lValue;
        return this;
    }

    public long get() {
        return this.m_lValue;
    }

    public long incrementAndGet() {
        return ++this.m_lValue;
    }

    public long decrementAndGet() {
        return --this.m_lValue;
    }

    public static ThreadLocal<MutableLong> createThreadLocal() {
        return ThreadLocal.withInitial(MutableLong::new);
    }

    @Override
    public int intValue() {
        return (int)this.m_lValue;
    }

    @Override
    public long longValue() {
        return this.m_lValue;
    }

    @Override
    public float floatValue() {
        return this.m_lValue;
    }

    @Override
    public double doubleValue() {
        return this.m_lValue;
    }

    @Override
    public int compareTo(MutableLong that) {
        long lDelta = this.m_lValue - that.m_lValue;
        return lDelta < 0L ? -1 : (lDelta == 0L ? 0 : 1);
    }

    public int hashCode() {
        return (int)(this.m_lValue ^ this.m_lValue >>> 32);
    }

    public boolean equals(Object that) {
        return that == this || that instanceof MutableLong && ((MutableLong)that).m_lValue == this.m_lValue;
    }

    public String toString() {
        return String.valueOf(this.m_lValue);
    }
}

