/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.StackTrace;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class Logger {
    public static final int ALWAYS = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int CONFIG = 4;
    public static final int FINE = 5;
    public static final int FINER = 6;
    public static final int FINEST = 7;

    public static boolean isEnabled(int nSeverity) {
        return CacheFactory.isLogEnabled(nSeverity);
    }

    public static void log(String sMessage, int nSeverity) {
        CacheFactory.log(sMessage, nSeverity);
    }

    public static void log(Supplier<String> supplierMessage, int nSeverity) {
        if (Logger.isEnabled(nSeverity)) {
            Logger.log(supplierMessage.get(), nSeverity);
        }
    }

    public static void log(String sMessage, Throwable e, int nSeverity) {
        if (Logger.isEnabled(nSeverity)) {
            if (((String)(sMessage = ((String)sMessage).trim())).length() > 0 && ((String)sMessage).charAt(((String)sMessage).length() - 1) != ':') {
                sMessage = (String)sMessage + ":";
            }
            Logger.log((String)sMessage + " " + String.valueOf(e), nSeverity);
            Logger.log(StackTrace.printStackTrace(e), nSeverity);
        }
    }

    public static void log(Supplier<String> supplierMessage, Throwable e, int nSeverity) {
        if (Logger.isEnabled(nSeverity)) {
            Logger.log(supplierMessage.get(), e, nSeverity);
        }
    }

    public static void log(Throwable e, int nSeverity) {
        Logger.log(e.toString(), nSeverity);
        Logger.log(StackTrace.printStackTrace(e), nSeverity);
    }

    public static void out(String sMessage) {
        Logger.log(sMessage, 0);
    }

    public static void out(Supplier<String> supplierMessage) {
        Logger.log(supplierMessage, 0);
    }

    public static void out(String sMessage, Throwable e) {
        Logger.log(sMessage, e, 0);
    }

    public static void out(Supplier<String> supplierMessage, Throwable e) {
        Logger.log(supplierMessage, e, 0);
    }

    public static void out(Throwable e) {
        Logger.log(e, 0);
    }

    public static void err(String sMessage) {
        Logger.log(sMessage, 1);
    }

    public static void err(Supplier<String> supplierMessage) {
        Logger.log(supplierMessage, 1);
    }

    public static void err(String sMessage, Throwable e) {
        Logger.log(sMessage, e, 1);
    }

    public static void err(Supplier<String> supplierMessage, Throwable e) {
        Logger.log(supplierMessage, e, 1);
    }

    public static void err(Throwable e) {
        Logger.log(e, 1);
    }

    public static void warn(String sMessage) {
        Logger.log(sMessage, 2);
    }

    public static void warn(Supplier<String> supplierMessage) {
        Logger.log(supplierMessage, 2);
    }

    public static void warn(String sMessage, Throwable e) {
        Logger.log(sMessage, e, 2);
    }

    public static void warn(Supplier<String> supplierMessage, Throwable e) {
        Logger.log(supplierMessage, e, 2);
    }

    public static void warn(Throwable e) {
        Logger.log(e, 2);
    }

    public static void info(String sMessage) {
        Logger.log(sMessage, 3);
    }

    public static void info(Supplier<String> supplierMessage) {
        Logger.log(supplierMessage, 3);
    }

    public static void info(String sMessage, Throwable e) {
        Logger.log(sMessage, e, 3);
    }

    public static void info(Supplier<String> supplierMessage, Throwable e) {
        Logger.log(supplierMessage, e, 3);
    }

    public static void info(Throwable e) {
        Logger.log(e, 3);
    }

    public static void config(String sMessage) {
        Logger.log(sMessage, 4);
    }

    public static void config(Supplier<String> supplierMessage) {
        Logger.log(supplierMessage, 4);
    }

    public static void config(String sMessage, Throwable e) {
        Logger.log(sMessage, e, 4);
    }

    public static void config(Supplier<String> supplierMessage, Throwable e) {
        Logger.log(supplierMessage, e, 4);
    }

    public static void config(Throwable e) {
        Logger.log(e, 4);
    }

    public static void fine(String sMessage) {
        Logger.log(sMessage, 5);
    }

    public static void fine(Supplier<String> supplierMessage) {
        Logger.log(supplierMessage, 5);
    }

    public static void fine(String sMessage, Throwable e) {
        Logger.log(sMessage, e, 5);
    }

    public static void fine(Supplier<String> supplierMessage, Throwable e) {
        Logger.log(supplierMessage, e, 5);
    }

    public static void fine(Throwable e) {
        Logger.log(e, 5);
    }

    public static void finer(String sMessage) {
        Logger.log(sMessage, 6);
    }

    public static void finer(Supplier<String> supplierMessage) {
        Logger.log(supplierMessage, 6);
    }

    public static void finer(String sMessage, Throwable e) {
        Logger.log(sMessage, e, 6);
    }

    public static void finer(Supplier<String> supplierMessage, Throwable e) {
        Logger.log(supplierMessage, e, 6);
    }

    public static void finer(Throwable e) {
        Logger.log(e, 6);
    }

    public static void finest(String sMessage) {
        Logger.log(sMessage, 7);
    }

    public static void finest(Supplier<String> supplierMessage) {
        Logger.log(supplierMessage, 7);
    }

    public static void finest(String sMessage, Throwable e) {
        Logger.log(sMessage, e, 7);
    }

    public static void finest(Supplier<String> supplierMessage, Throwable e) {
        Logger.log(supplierMessage, e, 7);
    }

    public static void finest(Throwable e) {
        Logger.log(e, 7);
    }

    public static void entering(Class<?> clz, String sMethod, Object ... params) {
        Logger.ensureRequirements(clz, sMethod);
        Logger.finest(() -> params == null || params.length == 0 ? String.format("ENTRY [%s.%s]", clz.getName(), sMethod) : String.format("ENTRY [%s.%s] params=%s", clz.getName(), sMethod, Arrays.toString(params)));
    }

    public static void exiting(Class<?> clz, String sMethod) {
        Logger.ensureRequirements(clz, sMethod);
        Logger.finest(() -> String.format("EXIT [%s.%s]", clz.getName(), sMethod));
    }

    public static void exiting(Class<?> clz, String sMethod, Object result, Object ... additionalInfo) {
        Logger.ensureRequirements(clz, sMethod);
        Logger.finest(() -> additionalInfo == null || additionalInfo.length == 0 ? String.format("EXIT [%s.%s] returning=%s", clz.getName(), sMethod, result) : String.format("EXIT [%s.%s] returning=%s, additional-info=%s", clz.getName(), sMethod, result, Arrays.toString(additionalInfo)));
    }

    public static void throwing(Class<?> clz, String sMethod, Throwable throwable, Object ... additionalInfo) {
        Objects.requireNonNull(throwable, "A throwable must be specified");
        Logger.ensureRequirements(clz, sMethod);
        Logger.finest(() -> String.format("THROWING [%s.%s] exception=%s, additional-info=%s", clz.getName(), sMethod, Base.getStackTrace(throwable), Arrays.toString(additionalInfo)));
    }

    public static void setLoggingLevel(int nSeverity) {
        CacheFactory.setLoggingLevel(nSeverity);
    }

    private static void ensureRequirements(Class<?> clz, String sMethod) {
        Objects.requireNonNull(clz, "A class must be specified");
        Objects.requireNonNull(sMethod, "A method name must be specified");
    }
}

