/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.Classes;
import java.rmi.RemoteException;

public abstract class Exceptions {
    public static RuntimeException ensureRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return Exceptions.ensureRuntimeException(e, e.getMessage());
    }

    public static RuntimeException ensureRuntimeException(Throwable e, String s) {
        if (e instanceof RuntimeException && s == null) {
            return (RuntimeException)e;
        }
        return new RuntimeException(s, e);
    }

    public static Throwable getOriginalException(RuntimeException e) {
        Throwable t = e;
        while (true) {
            if (t instanceof RuntimeException) {
                t = t.getCause();
                continue;
            }
            if (t instanceof RemoteException) {
                t = ((RemoteException)t).detail;
                continue;
            }
            if (!t.getClass().getName().equals("javax.ejb.EJBException")) break;
            try {
                t = (Throwable)Classes.invoke(t, "getCausedByException", Classes.VOID);
            }
            catch (Exception x) {
                return t;
            }
        }
        return t;
    }

    public static void throwIfFatal(Throwable t) {
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof LinkageError) {
            throw (LinkageError)t;
        }
    }
}

