/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Notifier;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;

public abstract class ConcurrentNotifier
implements Notifier {
    protected volatile Object m_oWaitHead;
    private static final AtomicReferenceFieldUpdater<ConcurrentNotifier, Object> s_fuHead = AtomicReferenceFieldUpdater.newUpdater(ConcurrentNotifier.class, Object.class, "m_oWaitHead");

    @Override
    public void await(long cMillis) throws InterruptedException {
        Thread threadThis = Thread.currentThread();
        Link linkThis = null;
        long lBitThis = -1L;
        while (!this.isReady()) {
            Object oNew;
            Object oHead = this.m_oWaitHead;
            if (oHead == null) {
                oNew = threadThis;
            } else if (linkThis == null) {
                lBitThis = 1L << threadThis.hashCode() % 61;
                linkThis = this.makeSelfLink(threadThis, lBitThis, oHead);
                oNew = linkThis;
            } else {
                linkThis.next = oHead instanceof Link ? (Link)oHead : new Link((Thread)oHead);
                Link linkNext = linkThis.next;
                linkThis.lFilterThreads = lBitThis | linkNext.lFilterThreads;
                oNew = linkThis;
            }
            if (oNew != null && !s_fuHead.compareAndSet(this, oHead, oNew)) continue;
            this.park(cMillis);
            return;
        }
    }

    @Override
    public void signal() {
        Object oWaitHead = this.m_oWaitHead;
        if (oWaitHead != null) {
            if (oWaitHead instanceof Thread && s_fuHead.compareAndSet(this, oWaitHead, null)) {
                LockSupport.unpark((Thread)oWaitHead);
            } else {
                this.signalInternal();
            }
        }
    }

    protected void signalInternal() {
        Object oWaitHead = this.m_oWaitHead;
        while (oWaitHead != null) {
            if (s_fuHead.compareAndSet(this, oWaitHead, null)) {
                if (oWaitHead instanceof Link) {
                    Link link = (Link)oWaitHead;
                    while (link != null) {
                        LockSupport.unpark(link.thread);
                        Link linkLast = link;
                        link = link.next;
                        linkLast.next = null;
                    }
                } else {
                    LockSupport.unpark((Thread)oWaitHead);
                }
                return;
            }
            oWaitHead = this.m_oWaitHead;
        }
    }

    protected void park(long cMillis) throws InterruptedException {
        if (!this.isReady()) {
            if (cMillis == 0L) {
                Blocking.park(this);
            } else {
                Blocking.parkNanos(this, cMillis * 1000000L);
            }
        }
        if (this.m_oWaitHead != null && Blocking.interrupted()) {
            throw new InterruptedException();
        }
    }

    protected Link makeSelfLink(Thread threadThis, long lBitThis, Object oHead) {
        Link linkHead;
        if (oHead == threadThis) {
            return null;
        }
        if (oHead instanceof Link) {
            Link link = linkHead = (Link)oHead;
            while (link != null && (link.lFilterThreads & lBitThis) != 0L) {
                if (link.thread == threadThis) {
                    return null;
                }
                link = link.next;
            }
        } else {
            linkHead = new Link((Thread)oHead);
            linkHead.lFilterThreads = 1L << oHead.hashCode() % 61;
        }
        Link linkThis = new Link(threadThis);
        linkThis.next = linkHead;
        linkThis.lFilterThreads = lBitThis | linkHead.lFilterThreads;
        return linkThis;
    }

    protected abstract boolean isReady();

    protected static final class Link {
        final Thread thread;
        long lFilterThreads;
        Link next;

        Link(Thread thread) {
            this.thread = thread;
        }
    }
}

