/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.Formatting;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Classes {
    private static Hashtable tblPrimitives = new Hashtable(10, 1.0f);
    public static final Class[] VOID_PARAMS;
    public static final Object[] VOID;

    public static String getSimpleName(Class clz) {
        String sFullClass = clz.getName();
        int ofDotClass = sFullClass.lastIndexOf(46);
        if (ofDotClass < 0) {
            return sFullClass;
        }
        String sName = sFullClass.substring(ofDotClass + 1);
        int ofInnerClass = sName.lastIndexOf(36);
        return ofInnerClass < 0 ? sName : sName.substring(ofInnerClass + 1);
    }

    public static String getSimpleName(String sName) {
        int ofLastDot = sName.lastIndexOf(46);
        if (ofLastDot < 0) {
            return sName;
        }
        if (ofLastDot == sName.length() - 1) {
            return "";
        }
        if (ofLastDot > 0) {
            return sName.substring(ofLastDot + 1);
        }
        return "";
    }

    public static Object newInstance(Class clz, Object[] aoParam) throws InstantiationException, InvocationTargetException {
        int cParams;
        if (clz == null) {
            throw new InstantiationException("Required class object is null");
        }
        if (aoParam == null) {
            aoParam = VOID;
        }
        if ((cParams = aoParam.length) == 0) {
            try {
                return clz.newInstance();
            }
            catch (InstantiationException e) {
                if (e.getMessage() == null) {
                    throw new InstantiationException(clz.getName());
                }
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException(e.toString());
            }
        }
        Class[] aclzParam = new Class[cParams];
        boolean fExactMatch = true;
        for (int i = 0; i < cParams; ++i) {
            if (aoParam[i] == null) {
                fExactMatch = false;
                continue;
            }
            aclzParam[i] = aoParam[i].getClass();
        }
        Constructor<Object> constrMatch = null;
        if (fExactMatch) {
            try {
                constrMatch = clz.getConstructor(aclzParam);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (constrMatch == null) {
            for (Constructor<?> constr : clz.getConstructors()) {
                Class<?>[] aclzActual = constr.getParameterTypes();
                if (aclzActual.length != cParams) continue;
                boolean fMatch = true;
                for (int i = 0; i < cParams && (fMatch = aoParam[i] == null ? !aclzActual[i].isPrimitive() : (aclzActual[i].isPrimitive() ? aclzActual[i] == (Class)tblPrimitives.get(aclzParam[i]) : aclzActual[i].isAssignableFrom(aclzParam[i]))); ++i) {
                }
                if (!fMatch) continue;
                constrMatch = constr;
                break;
            }
        }
        if (constrMatch != null) {
            try {
                return constrMatch.newInstance(aoParam);
            }
            catch (InstantiationException e) {
                if (e.getMessage() == null) {
                    throw new InstantiationException(clz.getName());
                }
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException(e.toString());
            }
            catch (SecurityException e) {
                throw new InstantiationException(e.toString());
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Could not find a constructor for ");
        sb.append(clz.getName());
        sb.append("(");
        for (int i = 0; i < cParams; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aoParam[i] == null ? "null" : aoParam[i].getClass().getName());
        }
        sb.append(")");
        throw new InstantiationException(sb.toString());
    }

    public static Object invokeStatic(Class clz, String sName, Object[] aoParam) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return Classes.invoke(clz, null, sName, aoParam);
    }

    public static Object invoke(Object obj, String sName, Object[] aoParam) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return Classes.invoke(obj.getClass(), obj, sName, aoParam);
    }

    public static Object invoke(Class clz, Object obj, String sName, Object[] aoParam) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int cParams;
        if (aoParam == null) {
            aoParam = VOID;
        }
        Class[] aclzParam = (cParams = aoParam.length) == 0 ? VOID_PARAMS : new Class[cParams];
        for (int i = 0; i < cParams; ++i) {
            Object oParam = aoParam[i];
            if (oParam == null) continue;
            aclzParam[i] = oParam.getClass();
        }
        IllegalAccessException iae = null;
        boolean fStatic = obj == null;
        Method method = Classes.findMethod(clz, sName, aclzParam, fStatic);
        while (method != null) {
            try {
                return method.invoke(obj, aoParam);
            }
            catch (IllegalAccessException e) {
                if (iae == null) {
                    iae = e;
                }
                Class<?>[] aclzIface = clz.getInterfaces();
                int c = aclzIface.length;
                for (int i = 0; i < c; ++i) {
                    method = Classes.findMethod(aclzIface[i], sName, aclzParam, fStatic);
                    if (method == null) continue;
                    try {
                        return method.invoke(obj, aoParam);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                if ((clz = clz.getSuperclass()) == null) {
                    throw iae;
                }
                method = Classes.findMethod(clz, sName, aclzParam, fStatic);
            }
        }
        if (iae == null) {
            throw new NoSuchMethodException(clz.getName() + "." + sName);
        }
        throw iae;
    }

    public static Method findMethod(Class clz, String sName, Class[] aclzParam, boolean fStatic) {
        if (aclzParam == null) {
            aclzParam = VOID_PARAMS;
        }
        int cParams = aclzParam.length;
        boolean fExactMatch = true;
        for (int i = 0; i < cParams; ++i) {
            if (aclzParam[i] != null) continue;
            fExactMatch = false;
            break;
        }
        if (fExactMatch && !fStatic) {
            try {
                return clz.getMethod(sName, aclzParam);
            }
            catch (NoSuchMethodException i) {
                // empty catch block
            }
        }
        block3: for (Method method : clz.getMethods()) {
            Class<?>[] aclzActual;
            if (!method.getName().equals(sName) || Modifier.isStatic(method.getModifiers()) != fStatic || (aclzActual = method.getParameterTypes()).length != cParams) continue;
            for (int i = 0; i < cParams; ++i) {
                Class clzParam = aclzParam[i];
                Class<?> clzActual = aclzActual[i];
                boolean fMatch = clzParam == null ? !clzActual.isPrimitive() : (clzActual.isPrimitive() ? clzActual == tblPrimitives.get(clzParam) : clzActual.isAssignableFrom(clzParam));
                if (!fMatch) continue block3;
            }
            return method;
        }
        return null;
    }

    public static Class[] getClassArray(Object[] aoParam) {
        int cParams;
        if (aoParam != null && (cParams = aoParam.length) > 0) {
            Class[] aClass = new Class[cParams];
            for (int i = 0; i < cParams; ++i) {
                Object oParam = aoParam[i];
                if (oParam == null) continue;
                aClass[i] = oParam.getClass();
            }
            return aClass;
        }
        return VOID_PARAMS;
    }

    public static Class[] unwrap(Class[] aClasses) {
        for (int i = 0; i < aClasses.length; ++i) {
            Class clz = aClasses[i];
            if (clz == null) {
                aClasses[i] = Object.class;
            }
            if (clz == Boolean.class) {
                aClasses[i] = Integer.TYPE;
            }
            if (clz == Byte.class) {
                aClasses[i] = Byte.TYPE;
            }
            if (clz == Character.class) {
                aClasses[i] = Character.TYPE;
            }
            if (clz == Short.class) {
                aClasses[i] = Short.TYPE;
            }
            if (clz == Integer.class) {
                aClasses[i] = Integer.TYPE;
            }
            if (clz == Long.class) {
                aClasses[i] = Long.TYPE;
            }
            if (clz == Float.class) {
                aClasses[i] = Float.TYPE;
            }
            if (clz != Double.class) continue;
            aClasses[i] = Double.TYPE;
        }
        return aClasses;
    }

    public static String[] toTypes(String sSig) {
        char[] ach = sSig.toCharArray();
        if (ach[0] != '(') {
            throw new IllegalArgumentException("JVM Method Signature must start with '('");
        }
        Vector<String> vect = new Vector<String>();
        vect.addElement(null);
        int of = 1;
        while (ach[of] != ')') {
            int cch = Classes.getTypeLength(ach, of);
            vect.addElement(new String(ach, of, cch));
            of += cch;
        }
        vect.setElementAt(new String(ach, ++of, ach.length - of), 0);
        Object[] asSig = new String[vect.size()];
        vect.copyInto(asSig);
        return asSig;
    }

    private static int getTypeLength(char[] ach, int of) {
        switch (ach[of]) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 1;
            }
            case '[': {
                int cch = 1;
                while (Formatting.isDecimal(ach[++of])) {
                    ++cch;
                }
                return cch + Classes.getTypeLength(ach, of);
            }
            case 'L': {
                int cch = 2;
                while (ach[++of] != ';') {
                    ++cch;
                }
                return cch;
            }
        }
        throw new IllegalArgumentException("JVM Type Signature cannot start with '" + ach[of] + "'");
    }

    public static String toTypeStringField(String sSig) {
        switch (sSig.charAt(0)) {
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case 'L': {
                return sSig.substring(1, sSig.indexOf(59)).replace('/', '.');
            }
            case '[': {
                int of = 0;
                while (Formatting.isDecimal(sSig.charAt(++of))) {
                }
                return Classes.toTypeStringField(sSig.substring(of)) + "[" + sSig.substring(1, of) + "]";
            }
        }
        throw new IllegalArgumentException("JVM Type Signature cannot start with '" + sSig.charAt(0) + "'");
    }

    public static String toBoxedTypeField(String sSig) {
        Object sBoxedType = "java/lang/";
        switch (sSig.charAt(0)) {
            case 'V': {
                sBoxedType = (String)sBoxedType + "Void";
                break;
            }
            case 'Z': {
                sBoxedType = (String)sBoxedType + "Boolean";
                break;
            }
            case 'B': {
                sBoxedType = (String)sBoxedType + "Byte";
                break;
            }
            case 'C': {
                sBoxedType = (String)sBoxedType + "Character";
                break;
            }
            case 'S': {
                sBoxedType = (String)sBoxedType + "Short";
                break;
            }
            case 'I': {
                sBoxedType = (String)sBoxedType + "Integer";
                break;
            }
            case 'J': {
                sBoxedType = (String)sBoxedType + "Long";
                break;
            }
            case 'F': {
                sBoxedType = (String)sBoxedType + "Float";
                break;
            }
            case 'D': {
                sBoxedType = (String)sBoxedType + "Double";
                break;
            }
            case 'L': {
                if (sSig.startsWith("Ljava/lang/")) {
                    return sSig.substring(1, sSig.length() - 1);
                }
            }
            case '[': {
                sBoxedType = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("JVM Type Signature cannot start with '" + sSig.charAt(0) + "'");
            }
        }
        return sBoxedType;
    }

    public static char fromBoxedTypeField(String sSig) {
        if (sSig.startsWith("java/lang/")) {
            switch (sSig.substring(10)) {
                case "Void": {
                    return 'V';
                }
                case "Boolean": {
                    return 'Z';
                }
                case "Byte": {
                    return 'B';
                }
                case "Character": {
                    return 'C';
                }
                case "Short": {
                    return 'S';
                }
                case "Integer": {
                    return 'I';
                }
                case "Long": {
                    return 'J';
                }
                case "Float": {
                    return 'F';
                }
                case "Double": {
                    return 'D';
                }
            }
        }
        return '\u0000';
    }

    public static ClassLoader ensureClassLoader(ClassLoader loader) {
        return loader == null ? Classes.getContextClassLoader() : loader;
    }

    public static ClassLoader getContextClassLoader() {
        return Classes.getContextClassLoader(null);
    }

    public static ClassLoader getContextClassLoader(Object o) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            if (o != null) {
                loader = o.getClass().getClassLoader();
            }
            if (loader == null && (loader = ClassLoader.class.getClassLoader()) == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
        }
        return loader;
    }

    public static Class loadClass(String sClass, ClassLoader loader1, ClassLoader loader2) throws ClassNotFoundException {
        for (int i = 1; i <= 3; ++i) {
            ClassLoader loader;
            switch (i) {
                case 1: {
                    loader = loader1;
                    break;
                }
                case 2: {
                    loader = loader2;
                    break;
                }
                case 3: {
                    loader = Classes.getContextClassLoader();
                    if (loader != loader1 && loader != loader2) break;
                    loader = null;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            try {
                if (loader == null) continue;
                return Class.forName(sClass, false, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(sClass);
    }

    public static String toString(Class clz) {
        if (clz.isPrimitive()) {
            return clz.toString();
        }
        if (clz.isArray()) {
            return "Array of " + Classes.toString(clz.getComponentType());
        }
        if (clz.isInterface()) {
            return Classes.toInterfaceString(clz, "");
        }
        return Classes.toClassString(clz, "");
    }

    private static String toClassString(Class clz, String sIndent) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)sIndent).append("Class ").append(clz.getName()).append("  (").append(Classes.toString(clz.getClassLoader())).append(')');
        sIndent = (String)sIndent + "  ";
        Class<?>[] aclz = clz.getInterfaces();
        int c = aclz.length;
        for (int i = 0; i < c; ++i) {
            sb.append('\n').append(Classes.toInterfaceString(aclz[i], (String)sIndent));
        }
        if ((clz = clz.getSuperclass()) != null) {
            sb.append('\n').append(Classes.toClassString(clz, (String)sIndent));
        }
        return sb.toString();
    }

    private static String toInterfaceString(Class clz2, String sIndent) {
        StringBuilder sb = new StringBuilder();
        sb.append(sIndent).append("Interface ").append(clz2.getName()).append("  (").append(Classes.toString(clz2.getClassLoader())).append(')');
        for (Class<?> clz2 : clz2.getInterfaces()) {
            sb.append('\n').append(Classes.toInterfaceString(clz2, sIndent + "  "));
        }
        return sb.toString();
    }

    private static String toString(ClassLoader loader) {
        if (loader == null) {
            return "System ClassLoader";
        }
        return "ClassLoader class=" + loader.getClass().getName() + ", hashCode=" + loader.hashCode();
    }

    static {
        tblPrimitives.put(Boolean.class, Boolean.TYPE);
        tblPrimitives.put(Character.class, Character.TYPE);
        tblPrimitives.put(Byte.class, Byte.TYPE);
        tblPrimitives.put(Short.class, Short.TYPE);
        tblPrimitives.put(Integer.class, Integer.TYPE);
        tblPrimitives.put(Long.class, Long.TYPE);
        tblPrimitives.put(Float.class, Float.TYPE);
        tblPrimitives.put(Double.class, Double.TYPE);
        tblPrimitives.put(Void.class, Void.TYPE);
        VOID_PARAMS = new Class[0];
        VOID = new Object[0];
    }
}

