/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import java.time.Duration;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class CaffeineCache
implements ConfigurableCacheMap,
ConcurrentMap {
    private boolean m_fOptimizeGetTime;
    private final Policy.VarExpiration<Object, Object> f_expiration;
    private final Policy.Eviction<Object, Object> f_eviction;
    private final MapListenerSupport f_listeners;
    private final Cache<Object, Object> f_cache = Caffeine.newBuilder().ticker(() -> TimeUnit.MILLISECONDS.toNanos(this.getCurrentTimeMillis())).evictionListener(this::notifyEvicted).expireAfter((Expiry)new ExpireAfterWrite()).maximumWeight(Long.MAX_VALUE).executor(Runnable::run).weigher(this::weigh).build();
    private final SimpleCacheStatistics f_stats;
    private volatile long m_cExpireAfterWriteNanos;
    private volatile ConfigurableCacheMap.UnitCalculator m_unitCalculator;
    private volatile int m_nUnitFactor = 1;
    private Collection m_colValues;
    private Set m_setEntries;
    private Set m_setKeys;

    public CaffeineCache() {
        this.f_expiration = (Policy.VarExpiration)this.f_cache.policy().expireVariably().orElseThrow();
        this.f_eviction = (Policy.Eviction)this.f_cache.policy().eviction().orElseThrow();
        this.f_listeners = new MapListenerSupport();
        this.f_stats = new SimpleCacheStatistics();
        this.m_unitCalculator = LocalCache.INSTANCE_FIXED;
        this.m_cExpireAfterWriteNanos = Long.MAX_VALUE;
    }

    public CacheStatistics getCacheStatistics() {
        return this.f_stats;
    }

    public void setOptimizeGetTime(boolean fOptimize) {
        this.m_fOptimizeGetTime = fOptimize;
    }

    private long getCurrentTimeMillis() {
        return this.m_fOptimizeGetTime ? Base.getLastSafeTimeMillis() : Base.getSafeTimeMillis();
    }

    public Map getAll(Collection colKeys) {
        Map map = this.f_cache.getAllPresent((Iterable)colKeys);
        this.f_stats.registerHits(map.size(), 0L);
        if (map.size() != colKeys.size()) {
            this.f_stats.registerMisses(Set.copyOf(colKeys).size() - map.size(), 0L);
        }
        return map;
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        Objects.requireNonNull(oValue);
        Duration duration = cMillis == -1L ? Duration.ofNanos(Long.MAX_VALUE) : (cMillis == 0L ? Duration.ofNanos(this.m_cExpireAfterWriteNanos) : Duration.ofMillis(cMillis));
        Object[] aoPrevious = new Object[]{null};
        this.f_expiration.compute(oKey, (k, oValueOld) -> {
            if (oValueOld == null) {
                this.notifyCreate(oKey, oValue);
            } else {
                this.notifyUpdate(oKey, oValueOld, oValue);
                aoPrevious[0] = oValueOld;
            }
            return oValue;
        }, duration);
        this.f_stats.registerPut(0L);
        return aoPrevious[0];
    }

    @Override
    public int getUnits() {
        return CaffeineCache.toExternalUnits(this.f_eviction.weightedSize().getAsLong(), this.getUnitFactor());
    }

    @Override
    public int getHighUnits() {
        return CaffeineCache.toExternalUnits(this.f_eviction.getMaximum(), this.getUnitFactor());
    }

    @Override
    public synchronized void setHighUnits(int units) {
        this.f_eviction.setMaximum(CaffeineCache.toInternalUnits(units, this.getUnitFactor()));
    }

    @Override
    public int getLowUnits() {
        return this.getHighUnits();
    }

    @Override
    public void setLowUnits(int units) {
    }

    @Override
    public int getUnitFactor() {
        return this.m_nUnitFactor;
    }

    @Override
    public synchronized void setUnitFactor(int nUnitFactor) {
        long cCurrentMaxUnits;
        if (nUnitFactor <= 0) {
            throw new IllegalArgumentException();
        }
        if (!this.isEmpty()) {
            throw new IllegalStateException("The unit factor cannot be set after the cache has been populated");
        }
        if (this.m_nUnitFactor == 1 && (cCurrentMaxUnits = this.f_eviction.getMaximum()) < 9223372034707292160L) {
            long cMaxUnits = cCurrentMaxUnits * (long)nUnitFactor;
            this.f_eviction.setMaximum(cMaxUnits < 0L ? Long.MAX_VALUE : cMaxUnits);
        }
        this.m_nUnitFactor = nUnitFactor;
    }

    @Override
    public ConfigurableCacheMap.UnitCalculator getUnitCalculator() {
        return this.m_unitCalculator;
    }

    @Override
    public void setUnitCalculator(ConfigurableCacheMap.UnitCalculator calculator) {
        this.m_unitCalculator = calculator == null ? LocalCache.INSTANCE_FIXED : calculator;
        for (Object oKey : this.f_cache.asMap().keySet()) {
            this.f_expiration.getExpiresAfter(oKey).ifPresent(duration -> this.f_expiration.compute(oKey, (k, oValue) -> oValue, duration));
        }
    }

    protected static long toInternalUnits(int cUnits, int nFactor) {
        return cUnits <= 0 || cUnits == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)cUnits * (long)nFactor;
    }

    protected static int toExternalUnits(long cUnits, int nFactor) {
        if (nFactor > 1) {
            cUnits = (cUnits + (long)nFactor - 1L) / (long)nFactor;
        }
        return cUnits > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)cUnits;
    }

    @Override
    public void evict(Object oKey) {
        this.f_expiration.setExpiresAfter(oKey, Duration.ZERO);
    }

    @Override
    public void evictAll(Collection colKeys) {
        colKeys.forEach(this::evict);
    }

    @Override
    public void evict() {
        this.f_cache.cleanUp();
    }

    @Override
    public int getExpiryDelay() {
        long cNanos = this.m_cExpireAfterWriteNanos;
        if (cNanos == Long.MAX_VALUE) {
            return 0;
        }
        return (int)Math.min(TimeUnit.NANOSECONDS.toMillis(cNanos), Integer.MAX_VALUE);
    }

    @Override
    public void setExpiryDelay(int cMillis) {
        if (cMillis < 0) {
            throw new IllegalArgumentException();
        }
        this.m_cExpireAfterWriteNanos = cMillis == 0 ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toNanos(cMillis);
    }

    @Override
    public long getNextExpiryTime() {
        if (this.isEmpty()) {
            return 0L;
        }
        return ((Optional)this.f_expiration.oldest(Stream::findFirst)).map(entry -> this.getCurrentTimeMillis() + entry.expiresAfter().toMillis()).orElse(0L);
    }

    @Override
    public ConfigurableCacheMap.Entry getCacheEntry(Object oKey) {
        Policy.CacheEntry entry = this.f_cache.policy().getEntryIfPresentQuietly(oKey);
        if (entry == null) {
            return null;
        }
        long lExpiresAt = this.getCurrentTimeMillis() + entry.expiresAfter().toMillis();
        return new CacheEntry(oKey, entry.getValue(), entry.weight(), lExpiresAt);
    }

    @Override
    public ConfigurableCacheMap.EvictionApprover getEvictionApprover() {
        return null;
    }

    @Override
    public void setEvictionApprover(ConfigurableCacheMap.EvictionApprover approver) {
    }

    @Override
    public ConfigurableCacheMap.EvictionPolicy getEvictionPolicy() {
        return null;
    }

    @Override
    public void setEvictionPolicy(ConfigurableCacheMap.EvictionPolicy policy) {
    }

    @Override
    public void addMapListener(MapListener listener) {
        this.f_listeners.addListener(listener, (Filter)null, false);
    }

    @Override
    public void removeMapListener(MapListener listener) {
        this.f_listeners.removeListener(listener, (Filter)null);
    }

    @Override
    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        this.f_listeners.addListener(listener, filter, fLite);
    }

    @Override
    public void removeMapListener(MapListener listener, Filter filter) {
        this.f_listeners.removeListener(listener, filter);
    }

    @Override
    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        this.f_listeners.addListener(listener, oKey, fLite);
    }

    @Override
    public void removeMapListener(MapListener listener, Object oKey) {
        this.f_listeners.removeListener(listener, oKey);
    }

    @Override
    public boolean isEmpty() {
        return this.f_cache.asMap().isEmpty();
    }

    @Override
    public int size() {
        return this.f_cache.asMap().size();
    }

    @Override
    public void clear() {
        this.f_cache.asMap().keySet().forEach(this::remove);
    }

    @Override
    public boolean containsKey(Object oKey) {
        return this.f_cache.asMap().containsKey(oKey);
    }

    @Override
    public boolean containsValue(Object oValue) {
        return this.f_cache.asMap().containsValue(oValue);
    }

    @Override
    public Object get(Object oKey) {
        Object oValue = this.f_cache.getIfPresent(oKey);
        if (oValue == null) {
            this.f_stats.registerMiss();
        } else {
            this.f_stats.registerHit();
        }
        return oValue;
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, 0L);
    }

    @Override
    public void putAll(Map map) {
        map.forEach(this::put);
    }

    @Override
    public Object putIfAbsent(Object oKey, Object oValue) {
        Objects.requireNonNull(oValue);
        boolean[] afAdded = new boolean[]{false};
        Object oResult = this.f_cache.get(oKey, k -> {
            this.notifyCreate(oKey, oValue);
            afAdded[0] = true;
            return oValue;
        });
        return afAdded[0] ? null : oResult;
    }

    @Override
    public Object replace(Object oKey, Object oValue) {
        Objects.requireNonNull(oValue);
        Object[] aoReplaced = new Object[]{null};
        this.f_cache.asMap().computeIfPresent(oKey, (? super K k, ? super V oldValue) -> {
            this.notifyUpdate(oKey, oldValue, oValue);
            aoReplaced[0] = oldValue;
            return oValue;
        });
        return aoReplaced[0];
    }

    @Override
    public boolean replace(Object oKey, Object oValueOld, Object oValueNew) {
        Objects.requireNonNull(oValueOld);
        Objects.requireNonNull(oValueNew);
        boolean[] afReplaced = new boolean[]{false};
        this.f_cache.asMap().computeIfPresent(oKey, (? super K k, ? super V v) -> {
            if (oValueOld.equals(v)) {
                this.notifyUpdate(oKey, oValueOld, oValueNew);
                afReplaced[0] = true;
                return oValueNew;
            }
            return v;
        });
        return afReplaced[0];
    }

    @Override
    public void replaceAll(BiFunction function) {
        Objects.requireNonNull(function);
        this.f_cache.asMap().replaceAll((? super K oKey, ? super V oValueOld) -> {
            Object oValueNew = function.apply(oKey, oValueOld);
            this.notifyUpdate(oKey, oValueOld, oValueNew);
            return oValueNew;
        });
    }

    @Override
    public Object remove(Object oKey) {
        Object[] aoRemoved = new Object[]{null};
        this.f_cache.asMap().computeIfPresent(oKey, (? super K k, ? super V oldValue) -> {
            this.notifyDelete(k, oldValue);
            aoRemoved[0] = oldValue;
            return null;
        });
        return aoRemoved[0];
    }

    @Override
    public boolean remove(Object oKey, Object oValue) {
        Objects.requireNonNull(oValue);
        boolean[] afRemoved = new boolean[]{false};
        this.f_cache.asMap().computeIfPresent(oKey, (? super K k, ? super V oldValue) -> {
            if (oValue.equals(oldValue)) {
                this.notifyDelete(k, oldValue);
                afRemoved[0] = true;
                return null;
            }
            return oldValue;
        });
        return afRemoved[0];
    }

    @Override
    public Object computeIfAbsent(Object oKey, Function mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        boolean[] afComputed = new boolean[]{false};
        Object oResult = this.f_cache.asMap().computeIfAbsent(oKey, (? super K k) -> {
            Object oValue = mappingFunction.apply(oKey);
            if (oValue != null) {
                this.notifyCreate(oKey, oValue);
            }
            afComputed[0] = true;
            return oValue;
        });
        if (afComputed[0]) {
            this.f_stats.registerMiss();
        } else {
            this.f_stats.registerHit();
        }
        return oResult;
    }

    @Override
    public Object computeIfPresent(Object oKey, BiFunction remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        return this.f_cache.asMap().computeIfPresent(oKey, (? super K k, ? super V oValueOld) -> {
            Object oValueNew = remappingFunction.apply(oKey, oValueOld);
            if (oValueNew == null) {
                this.notifyDelete(oKey, oValueOld);
                return null;
            }
            this.notifyUpdate(oKey, oValueOld, oValueNew);
            return oValueNew;
        });
    }

    @Override
    public Object compute(Object oKey, BiFunction remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        return this.f_cache.asMap().compute(oKey, (? super K k, ? super V oValueOld) -> {
            Object oValueNew = remappingFunction.apply(oKey, oValueOld);
            if (oValueOld == null) {
                if (oValueNew == null) {
                    return null;
                }
                this.notifyCreate(oKey, oValueNew);
                return oValueNew;
            }
            if (oValueNew == null) {
                this.notifyDelete(oKey, oValueOld);
                return null;
            }
            this.notifyUpdate(oKey, oValueOld, oValueNew);
            return oValueNew;
        });
    }

    @Override
    public Object merge(Object oKey, Object oValue, BiFunction remappingFunction) {
        Objects.requireNonNull(oValue);
        Objects.requireNonNull(remappingFunction);
        return this.f_cache.asMap().compute(oKey, (? super K k, ? super V oValueOld) -> {
            if (oValueOld == null) {
                this.notifyCreate(oKey, oValue);
                return oValue;
            }
            Object oValueNew = remappingFunction.apply(oValueOld, oValue);
            if (oValueNew == null) {
                this.notifyDelete(oKey, oValueOld);
                return null;
            }
            this.notifyUpdate(oKey, oValueOld, oValueNew);
            return oValueNew;
        });
    }

    @Override
    public Set keySet() {
        Set setKeys = this.m_setKeys;
        return setKeys == null ? (this.m_setKeys = new KeySetView()) : setKeys;
    }

    @Override
    public Collection values() {
        Collection colValues = this.m_colValues;
        return colValues == null ? (this.m_colValues = new ValuesView()) : colValues;
    }

    @Override
    public Set<Map.Entry> entrySet() {
        Set setEntries = this.m_setEntries;
        return setEntries == null ? (this.m_setEntries = new EntrySetView()) : setEntries;
    }

    @Override
    public boolean equals(Object o) {
        return this.f_cache.asMap().equals(o);
    }

    @Override
    public int hashCode() {
        return this.f_cache.asMap().hashCode();
    }

    public String toString() {
        return this.f_cache.asMap().toString();
    }

    private int weigh(Object oKey, Object oValue) {
        return this.m_unitCalculator.calculateUnits(oKey, oValue);
    }

    private void notifyCreate(Object oKey, Object oValueNew) {
        if (!this.f_listeners.isEmpty()) {
            CacheEvent<Object, Object> event = new CacheEvent<Object, Object>(this, 1, oKey, null, oValueNew, false);
            this.f_listeners.fireEvent(event, false);
        }
    }

    private void notifyUpdate(Object oKey, Object oValueOld, Object oValueNew) {
        if (!this.f_listeners.isEmpty()) {
            CacheEvent<Object, Object> event = new CacheEvent<Object, Object>(this, 2, oKey, oValueOld, oValueNew, false);
            this.f_listeners.fireEvent(event, false);
        }
    }

    private void notifyDelete(Object oKey, Object oValueOld) {
        if (!this.f_listeners.isEmpty()) {
            CacheEvent<Object, Object> event = new CacheEvent<Object, Object>(this, 3, oKey, oValueOld, null, false);
            this.f_listeners.fireEvent(event, false);
        }
    }

    private void notifyEvicted(Object oKey, Object oValueOld, RemovalCause removalCause) {
        if (!this.f_listeners.isEmpty()) {
            boolean fExpired = removalCause == RemovalCause.EXPIRED;
            CacheEvent<Object, Object> event = new CacheEvent<Object, Object>(this, 3, oKey, oValueOld, null, true, CacheEvent.TransformationState.TRANSFORMABLE, false, fExpired);
            this.f_listeners.fireEvent(event, false);
        }
    }

    private final class ExpireAfterWrite
    implements Expiry<Object, Object> {
        private ExpireAfterWrite() {
        }

        public long expireAfterCreate(Object oKey, Object oValue, long lCurrentTime) {
            return CaffeineCache.this.m_cExpireAfterWriteNanos;
        }

        public long expireAfterUpdate(Object oKey, Object oValue, long lCurrentTime, long lCurrentDuration) {
            return CaffeineCache.this.m_cExpireAfterWriteNanos;
        }

        public long expireAfterRead(Object oKey, Object oValue, long lCurrentTime, long lCurrentDuration) {
            return lCurrentDuration;
        }
    }

    private final class CacheEntry
    extends WriteThroughEntry
    implements ConfigurableCacheMap.Entry {
        private final long f_lExpiresAt;
        private final int f_nWeight;

        CacheEntry(Object oKey, Object oValue, int nWeight, long lExpiresAt) {
            super(oKey, oValue);
            this.f_nWeight = nWeight;
            this.f_lExpiresAt = lExpiresAt;
        }

        @Override
        public void touch() {
        }

        @Override
        public int getTouchCount() {
            return 0;
        }

        @Override
        public long getLastTouchMillis() {
            return 0L;
        }

        @Override
        public long getExpiryMillis() {
            return this.f_lExpiresAt;
        }

        @Override
        public void setExpiryMillis(long cMillis) {
            if (cMillis < 0L) {
                throw new IllegalArgumentException();
            }
            CaffeineCache.this.put(this.getKey(), this.getValue(), cMillis);
        }

        @Override
        public int getUnits() {
            return this.f_nWeight;
        }

        @Override
        public void setUnits(int cUnits) {
        }
    }

    final class KeySetView
    extends AbstractSet<Object> {
        KeySetView() {
        }

        @Override
        public int size() {
            return CaffeineCache.this.size();
        }

        @Override
        public void clear() {
            CaffeineCache.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return CaffeineCache.this.f_cache.asMap().containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return CaffeineCache.this.remove(o) != null;
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeyIterator();
        }

        @Override
        public Spliterator<Object> spliterator() {
            return CaffeineCache.this.f_cache.asMap().keySet().spliterator();
        }

        @Override
        public Object[] toArray() {
            return CaffeineCache.this.f_cache.asMap().keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return CaffeineCache.this.f_cache.asMap().keySet().toArray(array);
        }
    }

    final class ValuesView
    extends AbstractCollection<Object> {
        ValuesView() {
        }

        @Override
        public int size() {
            return CaffeineCache.this.size();
        }

        @Override
        public void clear() {
            CaffeineCache.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return CaffeineCache.this.f_cache.asMap().containsValue(o);
        }

        @Override
        public boolean removeIf(Predicate<? super Object> filter) {
            Objects.requireNonNull(filter);
            boolean fRemoved = false;
            for (Map.Entry entry : CaffeineCache.this.f_cache.asMap().entrySet()) {
                if (!filter.test(entry.getValue())) continue;
                fRemoved |= CaffeineCache.this.remove(entry.getKey(), entry.getValue());
            }
            return fRemoved;
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator();
        }

        @Override
        public Spliterator spliterator() {
            return CaffeineCache.this.f_cache.asMap().values().spliterator();
        }
    }

    final class EntrySetView
    extends AbstractSet<Map.Entry> {
        EntrySetView() {
        }

        @Override
        public int size() {
            return CaffeineCache.this.size();
        }

        @Override
        public void clear() {
            CaffeineCache.this.clear();
        }

        @Override
        public boolean contains(Object obj) {
            return CaffeineCache.this.f_cache.asMap().entrySet().contains(obj);
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return CaffeineCache.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry> filter) {
            Objects.requireNonNull(filter);
            boolean fRemoved = false;
            for (Map.Entry entry : this) {
                if (!filter.test(entry)) continue;
                fRemoved |= CaffeineCache.this.remove(entry.getKey(), entry.getValue());
            }
            return fRemoved;
        }

        @Override
        public Iterator<Map.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Spliterator<Map.Entry> spliterator() {
            return CaffeineCache.this.f_cache.asMap().entrySet().spliterator();
        }
    }

    private class WriteThroughEntry
    extends AbstractMap.SimpleEntry {
        WriteThroughEntry(Object oKey, Object oValue) {
            super(oKey, oValue);
        }

        @Override
        public Object setValue(Object oValue) {
            CaffeineCache.this.put(this.getKey(), oValue);
            return super.setValue(oValue);
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry> {
        private final Iterator<Map.Entry<Object, Object>> iterator;
        private Object oRemovalKey;

        EntryIterator() {
            this.iterator = CaffeineCache.this.f_cache.asMap().entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        Object nextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.oRemovalKey = this.iterator.next().getKey();
            return this.oRemovalKey;
        }

        Object nextValue() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<Object, Object> entry = this.iterator.next();
            this.oRemovalKey = entry.getKey();
            return entry.getValue();
        }

        @Override
        public Map.Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<Object, Object> entry = this.iterator.next();
            this.oRemovalKey = entry.getKey();
            return new WriteThroughEntry(entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            if (this.oRemovalKey == null) {
                throw new IllegalStateException();
            }
            CaffeineCache.this.remove(this.oRemovalKey);
            this.oRemovalKey = null;
        }
    }

    final class ValueIterator
    implements Iterator<Object> {
        private final EntryIterator iterator;

        ValueIterator() {
            this.iterator = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Object next() {
            return this.iterator.nextValue();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    final class KeyIterator
    implements Iterator<Object> {
        private final EntryIterator iterator;

        KeyIterator() {
            this.iterator = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Object next() {
            return this.iterator.nextKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

