/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.ai.util;

import com.oracle.coherence.ai.BitVector;
import com.oracle.coherence.ai.Vector;
import java.util.BitSet;

public class Vectors {
    public static final float EPSILON = 1.0E-30f;

    public static double magnitude(BitSet v) {
        return Math.sqrt(v.cardinality());
    }

    public static double magnitude(byte[] v) {
        double magnitude = 0.0;
        for (byte b : v) {
            magnitude += (double)(b * b);
        }
        return Math.sqrt(magnitude);
    }

    public static double magnitude(float[] v) {
        double magnitude = 0.0;
        for (float f : v) {
            magnitude += (double)(f * f);
        }
        return Math.sqrt(magnitude);
    }

    public static double dotProduct(BitSet v1, BitSet v2) {
        BitSet v = BitSet.valueOf(v1.toLongArray());
        v.and(v2);
        return v.cardinality();
    }

    public static double dotProduct(byte[] v1, byte[] v2) {
        double dotProduct = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            dotProduct += (double)(v1[i] * v2[i]);
        }
        return dotProduct;
    }

    public static double dotProduct(float[] v1, float[] v2) {
        double dotProduct = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            dotProduct += (double)(v1[i] * v2[i]);
        }
        return dotProduct;
    }

    public static double l2squared(BitSet v1, BitSet v2) {
        BitSet v = BitSet.valueOf(v1.toLongArray());
        v.xor(v2);
        return v.cardinality();
    }

    public static double l2squared(byte[] v1, byte[] v2) {
        double l2squared = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            int n = v1[i] - v2[i];
            l2squared += (double)(n ^ 2);
        }
        return l2squared;
    }

    public static double l2squared(float[] v1, float[] v2) {
        double l2squared = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            float f = v1[i] - v2[i];
            l2squared += (double)(f * f);
        }
        return l2squared;
    }

    public static float[] normalize(byte[] array) {
        float norm = 0.0f;
        int cDim = array.length;
        byte[] byArray = array;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            float v = byArray[i];
            norm += v * v;
        }
        norm = 1.0f / ((float)Math.sqrt(norm) + 1.0E-30f);
        float[] aNorm = new float[cDim];
        for (int i = 0; i < cDim; ++i) {
            aNorm[i] = (float)array[i] * norm;
        }
        return aNorm;
    }

    public static float[] normalize(float[] array) {
        float norm = 0.0f;
        int cDim = array.length;
        for (float v : array) {
            norm += v * v;
        }
        norm = 1.0f / ((float)Math.sqrt(norm) + 1.0E-30f);
        for (int i = 0; i < cDim; ++i) {
            array[i] = array[i] * norm;
        }
        return array;
    }

    public static BitVector binaryQuant(float[] vector) {
        if (vector == null) {
            return null;
        }
        BitSet bin = new BitSet(vector.length);
        for (int i = 0; i < vector.length; ++i) {
            if (!(vector[i] > 0.0f)) continue;
            bin.set(i);
        }
        return new BitVector(bin);
    }

    public static BitVector binaryQuant(byte[] vector) {
        if (vector == null) {
            return null;
        }
        BitSet bin = new BitSet(vector.length);
        for (int i = 0; i < vector.length; ++i) {
            if (vector[i] <= 0) continue;
            bin.set(i);
        }
        return new BitVector(bin);
    }

    public static int hammingDistance(Vector<BitSet> x, Vector<BitSet> y) {
        return Vectors.hammingDistance(x.get(), y.get());
    }

    public static int hammingDistance(BitSet x, BitSet y) {
        if (x.size() != y.size()) {
            throw new IllegalArgumentException(String.format("BitSets have different length: x[%d], y[%d]", x.size(), y.size()));
        }
        long[] ax = x.toLongArray();
        long[] ay = y.toLongArray();
        int dist = 0;
        for (int i = 0; i < ax.length; ++i) {
            dist += Vectors.d(ax[i], ay[i]);
        }
        return dist;
    }

    private static int d(long x, long y) {
        int dist = 0;
        for (long val = x ^ y; val != 0L; val &= val - 1L) {
            ++dist;
        }
        return dist;
    }
}

