/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.ai.search;

import com.oracle.coherence.ai.DistanceAlgorithm;
import com.oracle.coherence.ai.QueryResult;
import com.oracle.coherence.ai.Vector;
import com.oracle.coherence.ai.VectorIndex;
import com.oracle.coherence.ai.distance.CosineDistance;
import com.oracle.coherence.ai.index.BinaryQuantIndex;
import com.oracle.coherence.ai.search.BinaryQueryResult;
import com.oracle.coherence.ai.search.ConverterResult;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.SortedBag;
import com.tangosol.util.Streamer;
import com.tangosol.util.ValueExtractor;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbTransient;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SimilaritySearch<K, V, T>
implements InvocableMap.StreamingAggregator<K, V, List<BinaryQueryResult>, List<QueryResult<K, V>>>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="extractor")
    protected ValueExtractor<? super V, ? extends Vector<T>> m_extractor;
    @JsonbProperty(value="vector")
    protected Vector<T> m_vector;
    @JsonbProperty(value="algorithm")
    protected DistanceAlgorithm<T> m_algorithm = new CosineDistance();
    @JsonbProperty(value="maxResults")
    protected int m_nMaxResults;
    @JsonbProperty(value="bruteForce")
    protected boolean m_fBruteForce;
    @JsonbProperty(value="filter")
    protected Filter<?> m_filter;
    @JsonbTransient
    protected final transient SortedBag<BinaryQueryResult> m_results = new SortedBag(Comparator.naturalOrder());

    public SimilaritySearch() {
    }

    public SimilaritySearch(ValueExtractor<? super V, ? extends Vector<T>> extractor, Vector<T> vector, int maxResults) {
        this.m_extractor = ValueExtractor.of(Objects.requireNonNull(extractor));
        this.m_vector = Objects.requireNonNull(vector);
        this.m_nMaxResults = maxResults;
    }

    private SimilaritySearch(ValueExtractor<? super V, ? extends Vector<T>> extractor, Vector<T> vector, DistanceAlgorithm<T> algorithm, int nMaxResults, Filter<?> filter, boolean fBruteForce) {
        this.m_extractor = extractor;
        this.m_vector = vector;
        this.m_algorithm = algorithm;
        this.m_nMaxResults = nMaxResults;
        this.m_filter = filter;
        this.m_fBruteForce = fBruteForce;
    }

    public SimilaritySearch<K, V, T> algorithm(DistanceAlgorithm<T> algorithm) {
        this.m_algorithm = algorithm;
        return this;
    }

    public SimilaritySearch<K, V, T> bruteForce() {
        this.m_fBruteForce = true;
        return this;
    }

    public SimilaritySearch<K, V, T> filter(Filter<?> filter) {
        this.m_filter = filter;
        return this;
    }

    public ValueExtractor<? super V, ? extends Vector<T>> getExtractor() {
        return this.m_extractor;
    }

    public Vector<T> getVector() {
        return this.m_vector;
    }

    public DistanceAlgorithm<T> getAlgorithm() {
        return this.m_algorithm;
    }

    public int getMaxResults() {
        return this.m_nMaxResults;
    }

    public boolean isBruteForce() {
        return this.m_fBruteForce;
    }

    public Filter<?> getFilter() {
        return this.m_filter;
    }

    @Override
    public int characteristics() {
        return 73;
    }

    @Override
    public InvocableMap.StreamingAggregator<K, V, List<BinaryQueryResult>, List<QueryResult<K, V>>> supply() {
        return new SimilaritySearch<K, V, T>(this.m_extractor, this.m_vector, this.m_algorithm, this.m_nMaxResults, this.m_filter, this.m_fBruteForce);
    }

    @Override
    public boolean accumulate(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer) {
        InvocableMap.Entry entry;
        if (this.m_fBruteForce) {
            return this.bruteForce(streamer, null);
        }
        if (streamer.hasNext() && !this.searchPartition((entry = (InvocableMap.Entry)streamer.next()).asBinaryEntry(), this.m_vector)) {
            return this.bruteForce(streamer, entry);
        }
        return false;
    }

    @Override
    public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
        if (this.m_filter == null || InvocableMapHelper.evaluateEntry(this.m_filter, entry)) {
            Vector<T> vector;
            BinaryEntry<K, V> binaryEntry = entry.asBinaryEntry();
            Binary binaryKey = binaryEntry.getBinaryKey();
            Map<ValueExtractor, MapIndex> mapIndex = binaryEntry.getIndexMap();
            MapIndex index = mapIndex.get(this.m_extractor);
            Vector<T> vector2 = vector = index instanceof VectorIndex ? InvocableMapHelper.extractFromEntry(this.m_extractor, entry) : entry.extract(this.m_extractor);
            if (vector == null) {
                return true;
            }
            double distance = this.m_algorithm.distance(this.m_vector, vector);
            BinaryQueryResult result = new BinaryQueryResult(distance, binaryKey, binaryEntry.getBinaryValue());
            this.m_results.add(result);
            if (this.m_results.size() > this.m_nMaxResults) {
                this.m_results.removeLast();
            }
        }
        return true;
    }

    @Override
    public boolean combine(List<BinaryQueryResult> partialResult) {
        Iterator<BinaryQueryResult> it = partialResult.iterator();
        for (int size = this.m_results.size(); size < this.m_nMaxResults && it.hasNext(); ++size) {
            this.m_results.add(it.next());
        }
        while (it.hasNext()) {
            this.m_results.add(it.next());
            this.m_results.removeLast();
        }
        return true;
    }

    @Override
    public List<BinaryQueryResult> getPartialResult() {
        return new ArrayList<BinaryQueryResult>(this.m_results);
    }

    @Override
    public List<QueryResult<K, V>> finalizeResult() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<QueryResult<K, V>> finalizeResult(Converter<Binary, ?> converterBin) {
        Converter convUp = r -> new ConverterResult((BinaryQueryResult)r, converterBin);
        return ConverterCollections.getList(new ArrayList<BinaryQueryResult>(this.m_results), convUp, x -> null);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_extractor = (ValueExtractor)in.readObject(0);
        this.m_vector = (Vector)in.readObject(1);
        this.m_algorithm = (DistanceAlgorithm)in.readObject(2);
        this.m_nMaxResults = in.readInt(3);
        this.m_filter = (Filter)in.readObject(4);
        this.m_fBruteForce = in.readBoolean(5);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_extractor);
        out.writeObject(1, this.m_vector);
        out.writeObject(2, this.m_algorithm);
        out.writeInt(3, this.m_nMaxResults);
        out.writeObject(4, this.m_filter);
        out.writeBoolean(5, this.m_fBruteForce);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_extractor = (ValueExtractor)ExternalizableHelper.readObject(in);
        this.m_vector = (Vector)ExternalizableHelper.readObject(in);
        this.m_algorithm = (DistanceAlgorithm)ExternalizableHelper.readObject(in);
        this.m_nMaxResults = in.readInt();
        this.m_filter = (Filter)ExternalizableHelper.readObject(in);
        this.m_fBruteForce = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_extractor);
        ExternalizableHelper.writeObject(out, this.m_vector);
        ExternalizableHelper.writeObject(out, this.m_algorithm);
        out.writeInt(this.m_nMaxResults);
        ExternalizableHelper.writeObject(out, this.m_filter);
        out.writeBoolean(this.m_fBruteForce);
    }

    protected boolean bruteForce(Streamer<? extends InvocableMap.Entry<? extends K, ? extends V>> streamer, InvocableMap.Entry<? extends K, ? extends V> entry) {
        if (entry != null) {
            this.accumulate(entry);
        }
        while (streamer.hasNext()) {
            this.accumulate((InvocableMap.Entry)streamer.next());
        }
        return true;
    }

    protected boolean searchPartition(BinaryEntry binaryEntry, Vector<T> vector) {
        Map<ValueExtractor, MapIndex> mapIndex = binaryEntry.getIndexMap();
        MapIndex index = mapIndex.get(this.m_extractor);
        if (index instanceof VectorIndex) {
            BinaryQueryResult[] results = ((VectorIndex)index).query(vector, this.m_nMaxResults, this.m_filter);
            boolean fRemove = false;
            double nBottom = this.m_results.isEmpty() ? 3.4028234663852886E38 : this.m_results.last().getDistance();
            for (BinaryQueryResult result : results) {
                double nScore;
                if (index instanceof BinaryQuantIndex.BinaryQuantMapIndex) {
                    BackingMapContext ctx = binaryEntry.getBackingMapContext();
                    InvocableMap.Entry entry = ctx.getReadOnlyEntry(result.getKey());
                    result.setDistance(this.m_algorithm.distance(this.m_vector, InvocableMapHelper.extractFromEntry(this.m_extractor, entry)));
                }
                if (!((nScore = result.getDistance()) < nBottom)) continue;
                this.m_results.add(result);
                if (!fRemove && this.m_results.size() <= this.m_nMaxResults) continue;
                fRemove = true;
                this.m_results.removeLast();
                nBottom = this.m_results.last().getDistance();
            }
            return true;
        }
        return false;
    }
}

