/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.ai.search;

import com.oracle.coherence.ai.QueryResult;
import com.oracle.coherence.ai.search.BinaryQueryResult;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import java.util.Objects;

public class ConverterResult<K, V>
implements QueryResult<K, V> {
    protected final BinaryQueryResult wrapped;
    protected final Converter<Binary, ?> converter;

    public ConverterResult(BinaryQueryResult wrapped, Converter<Binary, ?> converter) {
        this.wrapped = Objects.requireNonNull(wrapped);
        this.converter = Objects.requireNonNull(converter);
    }

    public BinaryQueryResult getBinaryQueryResult() {
        return this.wrapped;
    }

    public Converter<Binary, ?> getConverter() {
        return this.converter;
    }

    @Override
    public double getDistance() {
        return this.wrapped.getDistance();
    }

    @Override
    public K getKey() {
        Binary binKey = (Binary)this.wrapped.getKey();
        return binKey == null ? null : (K)this.converter.convert(binKey);
    }

    @Override
    public V getValue() {
        Binary binValue = (Binary)this.wrapped.getValue();
        return binValue == null ? null : (V)this.converter.convert(binValue);
    }

    public String toString() {
        K oKey = this.getKey();
        return "ConverterResult{ result=" + this.getDistance() + ", key=" + String.valueOf(oKey) + "}";
    }
}

