/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.ai.search;

import com.oracle.coherence.ai.QueryResult;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;

public abstract class BaseQueryResult<K, V>
extends AbstractEvolvable
implements QueryResult<K, V>,
ExternalizableLite,
EvolvablePortableObject {
    @JsonbProperty(value="distance")
    protected double m_distance;
    @JsonbProperty(value="key")
    protected K m_key;
    @JsonbProperty(value="value")
    protected V m_value;

    protected BaseQueryResult() {
    }

    protected BaseQueryResult(double result, K key, V value) {
        this.m_key = key;
        this.m_distance = result;
        this.m_value = value;
    }

    @Override
    public double getDistance() {
        return this.m_distance;
    }

    @Override
    public K getKey() {
        return this.m_key;
    }

    @Override
    public V getValue() {
        return this.m_value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseQueryResult that = (BaseQueryResult)o;
        return Double.compare(this.m_distance, that.m_distance) == 0 && Objects.equals(this.m_key, that.m_key);
    }

    public int hashCode() {
        return Objects.hash(this.m_key, this.m_distance);
    }

    public String toString() {
        return "BaseQueryResult{ result=" + this.m_distance + ", key=" + String.valueOf(this.m_key) + "}";
    }

    @Override
    public int getImplVersion() {
        return 0;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_key = in.readObject(0);
        this.m_distance = in.readDouble(1);
        this.m_value = in.readObject(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_key);
        out.writeDouble(1, this.m_distance);
        out.writeObject(2, this.m_value);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_key = ExternalizableHelper.readObject(in);
        this.m_distance = in.readDouble();
        this.m_value = ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_key);
        out.writeDouble(this.m_distance);
        ExternalizableHelper.writeObject(out, this.m_value);
    }
}

