/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.ai.index;

import com.oracle.coherence.ai.Vector;
import com.oracle.coherence.ai.VectorIndex;
import com.oracle.coherence.ai.VectorIndexExtractor;
import com.oracle.coherence.ai.search.BinaryQueryResult;
import com.oracle.coherence.ai.util.Vectors;
import com.tangosol.internal.fastutil.ints.Int2ObjectAVLTreeMap;
import com.tangosol.internal.fastutil.ints.IntIterator;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.BackingMapContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ValueExtractor;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BinaryQuantIndex<K, V, T>
extends AbstractEvolvable
implements VectorIndexExtractor<V, T>,
ExternalizableLite,
EvolvablePortableObject {
    public static final int POF_IMPL_VERSION = 0;
    @JsonbProperty(value="extractor")
    private ValueExtractor<V, Vector<T>> f_extractor;
    @JsonbProperty(value="oversamplingFactor")
    private int m_nOversamplingFactor = 3;

    public BinaryQuantIndex() {
    }

    public BinaryQuantIndex(ValueExtractor<V, Vector<T>> extractor) {
        this.f_extractor = ValueExtractor.of(Objects.requireNonNull(extractor));
    }

    public BinaryQuantIndex<K, V, T> oversamplingFactor(int nOversamplingFactor) {
        this.m_nOversamplingFactor = nOversamplingFactor;
        return this;
    }

    @Override
    public Vector<T> extract(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MapIndex<K, V, Vector<T>> createIndex(boolean b, Comparator comparator, Map<ValueExtractor<V, Vector<T>>, MapIndex> map, BackingMapContext backingMapContext) {
        BinaryQuantMapIndex mapIndex = new BinaryQuantMapIndex(backingMapContext);
        map.put(this.f_extractor, mapIndex);
        return mapIndex;
    }

    @Override
    public MapIndex<K, V, Vector<T>> destroyIndex(Map<ValueExtractor<V, Vector<T>>, MapIndex> map) {
        return map.remove(this.f_extractor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryQuantIndex that = (BinaryQuantIndex)o;
        return Objects.equals(this.f_extractor, that.f_extractor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.f_extractor);
    }

    public String toString() {
        return "BinaryQuantIndex{extractor=" + String.valueOf(this.f_extractor) + "}";
    }

    @Override
    public int getImplVersion() {
        return 0;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.f_extractor = (ValueExtractor)in.readObject(0);
        this.m_nOversamplingFactor = in.readInt(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.f_extractor);
        out.writeInt(1, this.m_nOversamplingFactor);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.f_extractor = (ValueExtractor)ExternalizableHelper.readObject(in);
        this.m_nOversamplingFactor = in.readInt();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.f_extractor);
        out.writeInt(this.m_nOversamplingFactor);
    }

    public class BinaryQuantMapIndex
    implements VectorIndex<K, V, Vector<T>> {
        private final BackingMapContext f_backingMapContext;
        private final ConcurrentMap<K, BitSet> f_mapIndex = new ConcurrentHashMap();

        private BinaryQuantMapIndex(BackingMapContext ctx) {
            this.f_backingMapContext = ctx;
        }

        @Override
        public ValueExtractor<V, Vector<T>> getValueExtractor() {
            return BinaryQuantIndex.this.f_extractor;
        }

        @Override
        public boolean isOrdered() {
            return false;
        }

        @Override
        public boolean isPartial() {
            return false;
        }

        @Override
        public Map<Vector<T>, Set<K>> getIndexContents() {
            return NullImplementation.getMap();
        }

        @Override
        public Object get(K k) {
            return this.f_mapIndex.get(k);
        }

        @Override
        public Comparator<Vector<T>> getComparator() {
            return null;
        }

        @Override
        public void insert(Map.Entry<? extends K, ? extends V> entry) {
            Vector v = InvocableMapHelper.extractFromEntry(BinaryQuantIndex.this.f_extractor, entry);
            if (v != null) {
                Object oKey = entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : entry.getKey();
                this.f_mapIndex.put(oKey, v.binaryQuant().get());
            }
        }

        @Override
        public void update(Map.Entry<? extends K, ? extends V> entry) {
            Vector v = InvocableMapHelper.extractFromEntry(BinaryQuantIndex.this.f_extractor, entry);
            if (v != null) {
                Object oKey = entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : entry.getKey();
                this.f_mapIndex.put(oKey, v.binaryQuant().get());
            } else {
                this.delete(entry);
            }
        }

        @Override
        public void delete(Map.Entry<? extends K, ? extends V> entry) {
            Object oKey = entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : entry.getKey();
            this.f_mapIndex.remove(oKey);
        }

        @Override
        public BinaryQueryResult[] query(Vector<T> vector, int k, Filter<?> filter) {
            BitSet bitSet = Objects.requireNonNull(vector).binaryQuant().get();
            Int2ObjectAVLTreeMap<LinkedList<Binary>> mapDistances = new Int2ObjectAVLTreeMap<LinkedList<Binary>>();
            for (Map.Entry entry : this.f_mapIndex.entrySet()) {
                int d = Vectors.hammingDistance(bitSet, (BitSet)entry.getValue());
                LinkedList<Binary> lstKeys = (LinkedList<Binary>)mapDistances.get(d);
                if (lstKeys == null) {
                    lstKeys = new LinkedList<Binary>();
                    mapDistances.put(d, lstKeys);
                }
                lstKeys.add((Binary)entry.getKey());
            }
            int cAdded = 0;
            int cResults = Math.min(k * BinaryQuantIndex.this.m_nOversamplingFactor, this.f_mapIndex.size());
            BinaryQueryResult[] aResults = new BinaryQueryResult[cResults];
            IntIterator it = mapDistances.keySet().intIterator();
            block1: while (it.hasNext() && cAdded < cResults) {
                int d = it.nextInt();
                List lstKeys = (List)mapDistances.get(d);
                for (Binary binKey : lstKeys) {
                    BinaryEntry entry = this.f_backingMapContext.getReadOnlyEntry(binKey).asBinaryEntry();
                    if (filter != null && !InvocableMapHelper.evaluateEntry(filter, entry)) continue;
                    Binary binValue = entry.getBinaryValue();
                    aResults[cAdded++] = new BinaryQueryResult((double)d, binKey, binValue);
                    if (cAdded != cResults) continue;
                    continue block1;
                }
            }
            return cAdded == cResults ? aResults : Arrays.copyOfRange(aResults, 0, cAdded);
        }
    }
}

