/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.ai.distance;

import com.oracle.coherence.ai.distance.AbstractDistance;
import com.oracle.coherence.ai.util.Vectors;
import java.util.BitSet;

public class CosineDistance<T>
extends AbstractDistance<T> {
    @Override
    protected double distance(BitSet v1, BitSet v2) {
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        for (int i = 0; i < v1.size(); ++i) {
            int a = v1.get(i) ? 1 : 0;
            int b = v2.get(i) ? 1 : 0;
            normA += (double)(a * a);
            normB += (double)(b * b);
            dotProduct += (double)(a * b);
        }
        return 1.0f - (float)(dotProduct / Math.max(Math.sqrt(normA) * Math.sqrt(normB), (double)1.0E-30f));
    }

    @Override
    protected double distance(byte[] v1, byte[] v2) {
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            byte a = v1[i];
            byte b = v2[i];
            normA += (double)(a * a);
            normB += (double)(b * b);
            dotProduct += (double)(a * b);
        }
        return 1.0f - (float)(dotProduct / Math.max(Math.sqrt(normA) * Math.sqrt(normB), (double)1.0E-30f));
    }

    @Override
    protected double distance(float[] v1, float[] v2) {
        return 1.0f - (float)Vectors.dotProduct(v1, v2);
    }
}

