/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.ai.distance;

import com.oracle.coherence.ai.BitVector;
import com.oracle.coherence.ai.DistanceAlgorithm;
import com.oracle.coherence.ai.Float32Vector;
import com.oracle.coherence.ai.Int8Vector;
import com.oracle.coherence.ai.Vector;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;

public abstract class AbstractDistance<T>
implements DistanceAlgorithm<T>,
ExternalizableLite,
PortableObject {
    @Override
    public double distance(Vector<T> v1, Vector<T> v2) {
        if (v1.dimensions() != v2.dimensions()) {
            throw new IllegalArgumentException("Length of vector v1 (%,d) must be equal to the length of vector v2 (%,d)".formatted(v1.dimensions(), v2.dimensions()));
        }
        if (v1 instanceof Float32Vector) {
            return this.distance(((Float32Vector)v1).get(), ((Float32Vector)v2).get());
        }
        if (v1 instanceof Int8Vector) {
            return this.distance(((Int8Vector)v1).get(), ((Int8Vector)v2).get());
        }
        if (v1 instanceof BitVector) {
            return this.distance(((BitVector)v1).get(), ((BitVector)v2).get());
        }
        throw new IllegalArgumentException("Unsupported vector type " + v1.getClass().getName());
    }

    protected abstract double distance(BitSet var1, BitSet var2);

    protected abstract double distance(byte[] var1, byte[] var2);

    protected abstract double distance(float[] var1, float[] var2);

    @Override
    public void readExternal(PofReader in) {
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
    }
}

