/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.ai;

import com.oracle.coherence.ai.BitVector;
import com.oracle.coherence.ai.Vector;
import com.oracle.coherence.ai.util.Vectors;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public final class Int8Vector
implements Vector<byte[]> {
    public static final byte[] EMPTY = new byte[0];
    @JsonbProperty(value="array")
    private byte[] m_array;

    public Int8Vector() {
        this(EMPTY);
    }

    public Int8Vector(byte[] array) {
        this.m_array = array;
    }

    @Override
    public int dimensions() {
        return this.m_array.length;
    }

    @Override
    public byte[] get() {
        return this.m_array;
    }

    @Override
    public BitVector binaryQuant() {
        return Vectors.binaryQuant(this.m_array);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_array = in.readByteArray(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeByteArray(0, this.m_array);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_array = ExternalizableHelper.readByteArray(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeByteArray(out, this.m_array);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Int8Vector that = (Int8Vector)o;
        return Objects.deepEquals(this.m_array, that.m_array);
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_array);
    }

    public String toString() {
        return "Int8Vector{vector=" + Arrays.toString(this.m_array) + "}";
    }
}

