/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.ai;

import com.oracle.coherence.ai.BitVector;
import com.oracle.coherence.ai.Vector;
import com.oracle.coherence.ai.util.Vectors;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public final class Float32Vector
implements Vector<float[]> {
    public static final float[] EMPTY = new float[0];
    @JsonbProperty(value="array")
    private float[] m_array;

    public Float32Vector() {
        this(EMPTY);
    }

    public Float32Vector(float[] array) {
        this.m_array = array;
    }

    @Override
    public int dimensions() {
        return this.m_array.length;
    }

    @Override
    public float[] get() {
        return this.m_array;
    }

    @Override
    public BitVector binaryQuant() {
        return Vectors.binaryQuant(this.m_array);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_array = in.readFloatArray(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeFloatArray(0, this.m_array, true);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_array = ExternalizableHelper.readFloatArray(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeFloatArray(out, this.m_array);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Float32Vector that = (Float32Vector)o;
        return Objects.deepEquals(this.m_array, that.m_array);
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_array);
    }

    public String toString() {
        return "Float32Vector{vector=" + Arrays.toString(this.m_array) + "}";
    }
}

