/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.ai;

import com.oracle.coherence.ai.Float32Vector;
import com.oracle.coherence.ai.Vector;
import com.oracle.coherence.common.base.Classes;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class DocumentChunk
extends AbstractEvolvable
implements EvolvablePortableObject,
ExternalizableLite {
    public static final int IMPL_VERSION = 0;
    @JsonbProperty(value="text")
    private String m_text;
    @JsonbProperty(value="metadata")
    private Map<String, Object> m_mapMetadata;
    @JsonbProperty(value="vector")
    private Vector<float[]> m_vector;

    public DocumentChunk() {
    }

    public DocumentChunk(String text) {
        this(text, null, null);
    }

    public DocumentChunk(String text, Vector<float[]> vector) {
        this(text, null, vector);
    }

    public DocumentChunk(String text, Map<String, Object> metadata) {
        this(text, metadata, null);
    }

    public DocumentChunk(String text, Map<String, Object> metadata, Vector<float[]> vector) {
        this.m_text = text;
        this.m_mapMetadata = metadata == null ? new LinkedHashMap() : metadata;
        this.m_vector = vector;
    }

    public String text() {
        return this.m_text;
    }

    public Map<String, Object> metadata() {
        return this.m_mapMetadata;
    }

    public boolean isEmbedded() {
        return this.m_vector != null;
    }

    public Vector<float[]> vector() {
        return this.m_vector;
    }

    public DocumentChunk setVector(float[] vector) {
        return this.setVector(new Float32Vector(vector));
    }

    public DocumentChunk setVector(Vector<float[]> vector) {
        this.m_vector = vector;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DocumentChunk that = (DocumentChunk)obj;
        return Objects.equals(this.m_text, that.m_text) && Objects.equals(this.m_mapMetadata, that.m_mapMetadata) && Objects.equals(this.m_vector, that.m_vector);
    }

    public int hashCode() {
        return Objects.hash(this.m_text, this.m_mapMetadata, this.m_vector);
    }

    public String toString() {
        return "DocumentChunk[text=" + this.m_text + ", metadata=" + String.valueOf(this.m_mapMetadata) + "vector=" + String.valueOf(this.m_vector) + "]";
    }

    @Override
    public int getImplVersion() {
        return 0;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_vector = (Vector)in.readObject(0);
        this.m_text = in.readString(1);
        this.m_mapMetadata = in.readMap(2, new LinkedHashMap());
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_vector);
        out.writeString(1, this.m_text);
        out.writeMap(2, this.m_mapMetadata);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_vector = (Vector)ExternalizableHelper.readObject(in);
        this.m_text = ExternalizableHelper.readSafeUTF(in);
        this.m_mapMetadata = new LinkedHashMap<String, Object>();
        ExternalizableHelper.readMap(in, this.m_mapMetadata, Classes.getContextClassLoader());
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_vector);
        ExternalizableHelper.writeSafeUTF(out, this.m_text);
        ExternalizableHelper.writeMap(out, this.m_mapMetadata);
    }

    public static Id id(String sDocId, int nIndex) {
        return new Id(sDocId, nIndex);
    }

    public static class Id
    implements PortableObject,
    ExternalizableLite {
        @JsonbProperty(value="docId")
        private String m_sDocId;
        @JsonbProperty(value="index")
        private int m_nIndex;

        public Id() {
        }

        public Id(String sDocId, int nIndex) {
            this.m_sDocId = sDocId;
            this.m_nIndex = nIndex;
        }

        public String docId() {
            return this.m_sDocId;
        }

        public int index() {
            return this.m_nIndex;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_sDocId = in.readString(0);
            this.m_nIndex = in.readInt(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeString(0, this.m_sDocId);
            out.writeInt(1, this.m_nIndex);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_sDocId = ExternalizableHelper.readSafeUTF(in);
            this.m_nIndex = ExternalizableHelper.readInt(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeSafeUTF(out, this.m_sDocId);
            ExternalizableHelper.writeInt(out, this.m_nIndex);
        }

        public String toString() {
            if (this.m_nIndex == 0) {
                return this.m_sDocId;
            }
            return this.m_sDocId + "#" + this.m_nIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id = (Id)o;
            return this.m_nIndex == id.m_nIndex && Objects.equals(this.m_sDocId, id.m_sDocId);
        }

        public int hashCode() {
            return Objects.hash(this.m_sDocId, this.m_nIndex);
        }

        public static Id parse(String s) {
            int idx = s.lastIndexOf(35);
            if (idx != -1) {
                return new Id(s.substring(0, idx), Integer.parseInt(s.substring(idx + 1)));
            }
            return new Id(s, 0);
        }
    }
}

